/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.plugin.maven;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.X4ODriverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX4OLanguageMojo
extends AbstractMojo {
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/x4o";
    @Parameter(property="outputDirectory", defaultValue="target/x4o")
    private File outputDirectory;
    @Parameter
    private Map<String, String> languages;
    @Parameter(property="languages")
    private String languageCommandLineString;
    @Parameter(defaultValue="false", property="verbose")
    private boolean verbose = false;
    @Parameter(defaultValue="true", property="failOnError")
    private boolean failOnError = true;

    abstract String getLanguageTaskDirectoryLabel();

    abstract String getLanguageTaskName();

    abstract void executeLanguageTask(String var1, String var2, File var3) throws MojoExecutionException;

    private void executeLanguageTask() throws MojoExecutionException {
        if (this.languages == null) {
            this.languages = new HashMap<String, String>(10);
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(DEFAULT_OUTPUT_DIRECTORY);
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("Output directory: " + this.outputDirectory));
            this.getLog().info((CharSequence)("Verbose: " + this.verbose));
            this.getLog().info((CharSequence)("Fail on error: " + this.failOnError));
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
            if (this.verbose) {
                this.getLog().info((CharSequence)("Created directory: " + this.outputDirectory));
            }
        }
        if (this.languageCommandLineString != null && this.languageCommandLineString.startsWith("{") && this.languageCommandLineString.endsWith("}")) {
            String[] lang;
            this.languages.clear();
            String langString = this.languageCommandLineString.substring(1, this.languageCommandLineString.length() - 1);
            for (String l : lang = langString.split(",")) {
                String[] ll = l.split("=");
                if (ll.length != 2) {
                    this.getLog().warn((CharSequence)("Wrong langauge key split: '" + l + "' of languageString: '" + this.languageCommandLineString + "'"));
                    continue;
                }
                String langName = ll[0];
                String langVersion = ll[1];
                this.languages.put(langName, langVersion);
            }
        }
        if (this.languages.size() == 0) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"Defaulting to all languages in classpath.");
            }
            for (String[] lang : X4ODriverManager.getX4OLanguages()) {
                this.languages.put((String)lang, "ALL");
            }
        }
        for (String languageName : this.languages.keySet()) {
            String languageVersions = this.languages.get(languageName);
            if (languageVersions.contains("*") || languageVersions.contains("ALL")) {
                X4ODriver driver = X4ODriverManager.getX4ODriver((String)languageName);
                if (driver == null) {
                    throw new MojoExecutionException("Couln't load x4o language driver for: " + languageName);
                }
                for (String supportedVersion : driver.getLanguageVersions()) {
                    this.executeLanguageTask(languageName, supportedVersion);
                }
                continue;
            }
            if (languageVersions.contains("-")) {
                for (String languageVersion : languageVersions.split("-")) {
                    this.executeLanguageTask(languageName, languageVersion);
                }
                continue;
            }
            this.executeLanguageTask(languageName, languageVersions);
        }
    }

    private void executeLanguageTask(String languageName, String languageVersion) throws MojoExecutionException {
        long startTime = System.currentTimeMillis();
        if (this.verbose) {
            this.getLog().info((CharSequence)("Starting " + this.getLanguageTaskName() + " for " + languageName + ":" + languageVersion));
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.outputDirectory.getAbsolutePath());
        buf.append(File.separatorChar);
        buf.append(this.getLanguageTaskDirectoryLabel());
        buf.append("-");
        buf.append(languageName);
        buf.append("-");
        buf.append(languageVersion);
        File outputLanguagPath = new File(buf.toString());
        if (!outputLanguagPath.exists()) {
            outputLanguagPath.mkdir();
            if (this.verbose) {
                this.getLog().info((CharSequence)("Created directory: " + outputLanguagPath));
            }
        }
        this.executeLanguageTask(languageName, languageVersion, outputLanguagPath);
        long stopTime = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Done " + this.getLanguageTaskName() + " for " + languageName + ":" + languageVersion + " in " + (stopTime - startTime) + " ms."));
    }

    public void execute() throws MojoExecutionException {
        try {
            this.executeLanguageTask();
        }
        catch (MojoExecutionException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public Map<String, String> getLanguages() {
        return this.languages;
    }

    public void addLanguage(String languageName, String languageVersion) {
        this.languages.put(languageName, languageVersion);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

