/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.x4o.xml.eld.doc.api.ApiDocNodeWriterMethod;
import org.x4o.xml.eld.doc.api.dom.ApiDoc;
import org.x4o.xml.eld.doc.api.dom.ApiDocNode;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeBody;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeWriter;
import org.x4o.xml.eld.doc.api.dom.ApiDocWriteEvent;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDocNodeWriterBean
implements ApiDocNodeWriter {
    private ApiDocNodeBody nodeBody = null;
    private Integer nodeBodyOrder = null;
    private Object bean = null;
    private String method = null;
    private List<Class<?>> targetClasses = new ArrayList(5);
    private String contentGroup = null;
    private String contentGroupType = null;

    public ApiDocNodeWriterBean() {
    }

    public ApiDocNodeWriterBean(ApiDocNodeBody nodeBody, Object bean, String method, Class<?> ... classes) {
        this();
        this.setNodeBody(nodeBody);
        this.setBean(bean);
        this.setMethod(method);
        for (Class<?> cl : classes) {
            this.addtargetClass(cl);
        }
    }

    public static void addAnnotatedNodeContentWriters(ApiDoc doc, Object bean) {
        if (doc == null) {
            throw new NullPointerException("Can't add to null ApiDoc.");
        }
        if (bean == null) {
            throw new NullPointerException("Can't scan null bean.");
        }
        for (Method method : bean.getClass().getMethods()) {
            ApiDocNodeWriterMethod ammo = method.getAnnotation(ApiDocNodeWriterMethod.class);
            if (ammo == null) continue;
            ApiDocNodeWriterBean methodWriter = new ApiDocNodeWriterBean(ammo.nodeBody(), bean, method.getName(), ammo.targetClasses());
            if (ammo.nodeBodyOrder() != -1) {
                methodWriter.setNodeBodyOrder(ammo.nodeBodyOrder());
            }
            if (ammo.contentGroup().length() > 0) {
                methodWriter.setContentGroup(ammo.contentGroup());
            }
            if (ammo.contentGroupType().length() > 0) {
                methodWriter.setContentGroupType(ammo.contentGroupType());
            }
            doc.addNodeBodyWriter(methodWriter);
        }
    }

    @Override
    public void writeNodeContent(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        Class<?> beanClass = this.getBean().getClass();
        try {
            Method methodBean = beanClass.getMethod(this.getMethod(), ApiDocWriteEvent.class);
            methodBean.invoke(this.getBean(), event);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void addtargetClass(Class<?> targetClass) {
        this.targetClasses.add(targetClass);
    }

    public void removetargetClass(Class<?> targetClass) {
        this.targetClasses.remove(this.targetClasses);
    }

    @Override
    public List<Class<?>> getTargetClasses() {
        return this.targetClasses;
    }

    @Override
    public ApiDocNodeBody getNodeBody() {
        return this.nodeBody;
    }

    public void setNodeBody(ApiDocNodeBody nodeBody) {
        this.nodeBody = nodeBody;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Integer getNodeBodyOrder() {
        return this.nodeBodyOrder;
    }

    public void setNodeBodyOrder(Integer nodeBodyOrder) {
        this.nodeBodyOrder = nodeBodyOrder;
    }

    public String getContentGroup() {
        return this.contentGroup;
    }

    public void setContentGroup(String contentGroup) {
        this.contentGroup = contentGroup;
    }

    public String getContentGroupType() {
        return this.contentGroupType;
    }

    public void setContentGroupType(String contentGroupType) {
        this.contentGroupType = contentGroupType;
    }
}

