/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.x4o.xml.eld.doc.api.ApiDocContentWriter;
import org.x4o.xml.eld.doc.api.DefaultPageWriterTree;
import org.x4o.xml.eld.doc.api.dom.ApiDoc;
import org.x4o.xml.eld.doc.api.dom.ApiDocNode;
import org.x4o.xml.eld.doc.api.dom.ApiDocPage;
import org.x4o.xml.eld.doc.api.dom.ApiDocPageWriter;
import org.x4o.xml.eld.doc.api.dom.ApiDocWriteEvent;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.io.sax.ext.ContentWriterHtml;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EldDocXTreePageWriter
extends DefaultPageWriterTree
implements ApiDocPageWriter {
    public static ApiDocPage createDocPage() {
        return new ApiDocPage("overview-xtree", "XTree", "XTree of dom elements.", new EldDocXTreePageWriter());
    }

    private void walkTree(TreeNode node, ApiDocContentWriter writer, String pathPrefix) throws SAXException {
        String href = this.toElementUri(pathPrefix, node.module, node.namespace, node.elementClass);
        writer.printTagStart((Enum)ContentWriterHtml.Tag.ul);
        writer.printTagStart(ContentWriterHtml.Tag.li, "", null, "circle");
        writer.characters(node.namespace.getId());
        writer.characters(":");
        writer.printHref(href, node.elementClass.getId(), node.elementClass.getId(), "strong");
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.li);
        List<TreeNode> childs = this.findChilderen(node);
        for (TreeNode child : childs) {
            this.walkTree(child, writer, pathPrefix);
        }
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
    }

    @Override
    public void writePageContent(ApiDocWriteEvent<ApiDocPage> e) throws SAXException {
        ApiDoc doc = e.getDoc();
        X4OLanguageContext context = (X4OLanguageContext)doc.getRootNode().getUserData();
        String pathPrefix = "language/";
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>(3);
        for (X4OLanguageModule mod : context.getLanguage().getLanguageModules()) {
            for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                if (ns.getLanguageRoot() == null || !ns.getLanguageRoot().booleanValue()) continue;
                for (ElementClass ec : ns.getElementClasses()) {
                    TreeNode node = new TreeNode();
                    node.context = context;
                    node.module = mod;
                    node.namespace = ns;
                    node.elementClass = ec;
                    rootNodes.add(node);
                }
            }
        }
        Collections.sort(rootNodes, new TreeNodeComparator());
        for (TreeNode rootNode : rootNodes) {
            this.walkTree(rootNode, e.getWriter(), pathPrefix);
        }
    }

    private String toElementUri(String pathPrefix, X4OLanguageModule mod, ElementNamespaceContext namespace, ElementClass ec) {
        StringBuffer buf = new StringBuffer(100);
        if (pathPrefix != null) {
            buf.append(pathPrefix);
        }
        buf.append(ApiDocContentWriter.toSafeUri(mod.getId()));
        buf.append("/");
        buf.append(ApiDocContentWriter.toSafeUri(namespace.getId()));
        buf.append("/");
        buf.append(ApiDocContentWriter.toSafeUri(ec.getId()));
        buf.append("/index.html");
        return buf.toString();
    }

    @Override
    protected ApiDocNode selectRootNode(ApiDoc doc) {
        try {
            return this.createXTree(doc);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Could not create XTree for: " + doc.getName() + " error: " + e.getMessage(), e);
        }
    }

    private ApiDocNode createXTree(ApiDoc doc) throws SAXException {
        X4OLanguageContext context = (X4OLanguageContext)doc.getRootNode().getUserData();
        ApiDocNode root = new ApiDocNode(context, "root", "Root", "Language root");
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>(3);
        for (X4OLanguageModule mod : context.getLanguage().getLanguageModules()) {
            for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                if (ns.getLanguageRoot() == null || !ns.getLanguageRoot().booleanValue()) continue;
                for (ElementClass ec : ns.getElementClasses()) {
                    TreeNode node = new TreeNode();
                    node.context = context;
                    node.module = mod;
                    node.namespace = ns;
                    node.elementClass = ec;
                    rootNodes.add(node);
                }
            }
        }
        Collections.sort(rootNodes, new TreeNodeComparator());
        for (TreeNode rootNode : rootNodes) {
            this.walkTree(rootNode, "../");
        }
        return root;
    }

    private void walkTree(TreeNode node, String pathPrefix) throws SAXException {
        List<TreeNode> childs = this.findChilderen(node);
        for (TreeNode child : childs) {
            this.walkTree(child, pathPrefix);
        }
    }

    public List<TreeNode> findChilderen(TreeNode node) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(10);
        if (node.indent > 20) {
            return result;
        }
        for (X4OLanguageModule mod : node.context.getLanguage().getLanguageModules()) {
            for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                for (ElementClass ec : ns.getElementClasses()) {
                    TreeNode n = null;
                    List tags = ec.getElementParents(node.namespace.getUri());
                    if (tags != null && tags.contains(node.elementClass.getId())) {
                        n = new TreeNode();
                        n.context = node.context;
                        n.module = mod;
                        n.namespace = ns;
                        n.elementClass = ec;
                        n.indent = node.indent + 1;
                        n.parent = node;
                    } else {
                        if (ec.getObjectClass() == null) continue;
                        for (ElementInterface ei : node.context.getLanguage().findElementInterfaces((Object)ec.getObjectClass())) {
                            List eiTags = ei.getElementParents(node.namespace.getUri());
                            if (eiTags == null || !eiTags.contains(node.elementClass.getId())) continue;
                            n = new TreeNode();
                            n.context = node.context;
                            n.module = mod;
                            n.namespace = ns;
                            n.elementClass = ec;
                            n.indent = node.indent + 1;
                            n.parent = node;
                            break;
                        }
                        if (node.elementClass.getObjectClass() == null) continue;
                        List binds = node.context.getLanguage().findElementBindingHandlers((Object)node.elementClass.getObjectClass(), (Object)ec.getObjectClass());
                        if (!binds.isEmpty()) {
                            n = new TreeNode();
                            n.context = node.context;
                            n.module = mod;
                            n.namespace = ns;
                            n.elementClass = ec;
                            n.indent = node.indent + 1;
                            n.parent = node;
                        }
                    }
                    if (n == null || this.isInTree(node, n)) continue;
                    result.add(n);
                }
            }
        }
        Collections.sort(result, new TreeNodeComparator());
        return result;
    }

    private boolean isInTree(TreeNode node, TreeNode checkNode) {
        if (node.namespace.getUri().equals(checkNode.namespace.getUri()) && node.elementClass.getId().equals(checkNode.elementClass.getId())) {
            return true;
        }
        if (node.parent != null) {
            return this.isInTree(node.parent, checkNode);
        }
        return false;
    }

    public List<TreeNode> findParents(TreeNode node) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(10);
        TreeNode n = null;
        for (X4OLanguageModule mod : node.context.getLanguage().getLanguageModules()) {
            for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                List tags = node.elementClass.getElementParents(ns.getUri());
                if (tags != null) {
                    for (ElementClass ec : ns.getElementClasses()) {
                        if (!tags.contains(ec.getId())) continue;
                        n = new TreeNode();
                        n.context = node.context;
                        n.module = mod;
                        n.namespace = ns;
                        n.elementClass = ec;
                        n.indent = node.indent + 1;
                        n.parent = node;
                        result.add(n);
                    }
                }
                for (ElementClass ec : ns.getElementClasses()) {
                    List binds;
                    if (node.elementClass.getObjectClass() != null) {
                        for (ElementInterface ei : node.context.getLanguage().findElementInterfaces((Object)node.elementClass.getObjectClass())) {
                            List eiTags = ei.getElementParents(ns.getUri());
                            if (eiTags == null || !eiTags.contains(ec.getId())) continue;
                            n = new TreeNode();
                            n.context = node.context;
                            n.module = mod;
                            n.namespace = ns;
                            n.elementClass = ec;
                            n.indent = node.indent + 1;
                            n.parent = node;
                            result.add(n);
                            break;
                        }
                    }
                    if (ec.getObjectClass() == null || node.elementClass.getObjectClass() == null || (binds = node.context.getLanguage().findElementBindingHandlers((Object)ec.getObjectClass(), (Object)node.elementClass.getObjectClass())).isEmpty()) continue;
                    n = new TreeNode();
                    n.context = node.context;
                    n.module = mod;
                    n.namespace = ns;
                    n.elementClass = ec;
                    n.indent = node.indent + 1;
                    n.parent = node;
                    if (this.isInTree(node, n)) continue;
                    result.add(n);
                }
            }
        }
        Collections.sort(result, new TreeNodeComparator());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TreeNodeComparator
    implements Comparator<TreeNode> {
        TreeNodeComparator() {
        }

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            return o1.elementClass.getId().compareTo(o2.elementClass.getId());
        }
    }

    class TreeNode {
        X4OLanguageContext context;
        X4OLanguageModule module;
        ElementNamespaceContext namespace;
        ElementClass elementClass;
        TreeNode parent;
        int indent = 0;

        TreeNode() {
        }
    }
}

