/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc;

import java.lang.reflect.Method;
import java.util.List;
import org.x4o.xml.eld.doc.EldDocXTreePageWriter;
import org.x4o.xml.eld.doc.api.ApiDocContentWriter;
import org.x4o.xml.eld.doc.api.ApiDocNodeWriterMethod;
import org.x4o.xml.eld.doc.api.dom.ApiDocNode;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeBody;
import org.x4o.xml.eld.doc.api.dom.ApiDocWriteEvent;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.io.sax.ext.ContentWriterHtml;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EldDocWriterElementClass {
    private String printList(List<String> list) {
        StringBuffer buf = new StringBuffer(40);
        buf.append("[L: ");
        if (list.isEmpty()) {
            buf.append("Empty.");
        }
        for (String s : list) {
            buf.append(s);
            buf.append(' ');
        }
        buf.append("]");
        return buf.toString();
    }

    @ApiDocNodeWriterMethod(nodeBody=ApiDocNodeBody.SUMMARY, targetClasses={ElementClass.class})
    public void writeElementX4OSummary(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocContentWriter writer = event.getWriter();
        ElementClass ec = (ElementClass)event.getEvent().getUserData();
        writer.docTableStart("Element X4O Properties", "Element X4O Property Overview");
        writer.docTableHeader("Name", "Value");
        writer.docTableRow("id", "" + ec.getId());
        writer.docTableRow("objectClass", "" + ec.getObjectClass());
        writer.docTableRow("elementClass", "" + ec.getElementClass());
        writer.docTableRow("autoAttributes", "" + ec.getAutoAttributes());
        writer.docTableRow("skipPhases", this.printList(ec.getSkipPhases()));
        writer.docTableRow("schemaContentBase", "" + ec.getSchemaContentBase());
        writer.docTableRow("schemaContentComplex", "" + ec.getSchemaContentComplex());
        writer.docTableRow("schemaContentMixed", "" + ec.getSchemaContentMixed());
        writer.docTableEnd();
    }

    @ApiDocNodeWriterMethod(nodeBody=ApiDocNodeBody.SUMMARY, targetClasses={ElementClass.class})
    public void writeElementX4OAttributeSummary(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocContentWriter writer = event.getWriter();
        ElementClass ec = (ElementClass)event.getEvent().getUserData();
        writer.docTableStart("Element X4O Attributes", "All Element X4O Attributes Overview");
        writer.docTableHeader("URI", "Name");
        for (ElementClassAttribute attr : ec.getElementClassAttributes()) {
            writer.docTableRow(attr.getId(), attr.getDescription());
        }
        writer.docTableEnd();
    }

    @ApiDocNodeWriterMethod(nodeBody=ApiDocNodeBody.SUMMARY, targetClasses={ElementClass.class})
    public void writeElementObjectPropertiesSummary(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocContentWriter writer = event.getWriter();
        ElementClass ec = (ElementClass)event.getEvent().getUserData();
        Class beanClass = ec.getElementClass();
        if (beanClass == null) {
            return;
        }
        writer.docTableStart("Class Properties", "Bean class properties overview.");
        writer.docTableHeader("Name", "Value");
        for (Method m : beanClass.getMethods()) {
            if (!m.getName().startsWith("set")) continue;
            String n = m.getName().substring(3);
            if (m.getParameterTypes().length == 0 || n.length() < 2) continue;
            n = n.substring(0, 1).toLowerCase() + n.substring(1, n.length());
            Class<?> type = m.getParameterTypes()[0];
            writer.docTableRow(n, "" + type);
        }
        writer.docTableEnd();
    }

    @ApiDocNodeWriterMethod(nodeBody=ApiDocNodeBody.DESCRIPTION_LINKS, targetClasses={ElementClass.class})
    public void writeElementRelationLinks(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocContentWriter writer = event.getWriter();
        ElementClass ec = (ElementClass)event.getEvent().getUserData();
        ElementNamespaceContext ns = (ElementNamespaceContext)event.getEvent().getParent().getUserData();
        X4OLanguageModule mod = (X4OLanguageModule)event.getEvent().getParent().getParent().getUserData();
        X4OLanguageContext context = (X4OLanguageContext)event.getEvent().getParent().getParent().getParent().getUserData();
        EldDocXTreePageWriter xtree = (EldDocXTreePageWriter)event.getDoc().findDocPageById("overview-xtree").getPageWriters().get(0);
        EldDocXTreePageWriter.TreeNode node = xtree.new EldDocXTreePageWriter.TreeNode();
        node.context = context;
        node.module = mod;
        node.namespace = ns;
        node.elementClass = ec;
        String pathPrefix = "../../../../language/";
        List<EldDocXTreePageWriter.TreeNode> parents = xtree.findParents(node);
        writer.printTagStart((Enum)ContentWriterHtml.Tag.dl);
        writer.printTagCharacters((Enum)ContentWriterHtml.Tag.dt, "Element Parents:");
        writer.printTagStart((Enum)ContentWriterHtml.Tag.dd);
        if (parents.isEmpty()) {
            writer.characters("No parent.");
        }
        for (int i = 0; i < parents.size(); ++i) {
            EldDocXTreePageWriter.TreeNode n = parents.get(i);
            String uri = this.toElementUri(pathPrefix, n.module, n.namespace, n.elementClass);
            writer.printHref(uri, n.namespace.getId() + ":" + n.elementClass.getId());
            if (i >= parents.size() - 1) continue;
            writer.charactersRaw(",&nbsp;");
        }
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.dd);
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.dl);
        List<EldDocXTreePageWriter.TreeNode> childs = xtree.findChilderen(node);
        writer.printTagStart((Enum)ContentWriterHtml.Tag.dl);
        writer.printTagCharacters((Enum)ContentWriterHtml.Tag.dt, "Element Childeren:");
        writer.printTagStart((Enum)ContentWriterHtml.Tag.dd);
        if (childs.isEmpty()) {
            writer.characters("No childeren.");
        }
        for (int i = 0; i < childs.size(); ++i) {
            EldDocXTreePageWriter.TreeNode n = childs.get(i);
            String uri = this.toElementUri(pathPrefix, n.module, n.namespace, n.elementClass);
            writer.printHref(uri, n.namespace.getId() + ":" + n.elementClass.getId());
            if (i >= childs.size() - 1) continue;
            writer.charactersRaw(",&nbsp;");
        }
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.dd);
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.dl);
    }

    private String toElementUri(String pathPrefix, X4OLanguageModule mod, ElementNamespaceContext namespace, ElementClass ec) {
        StringBuffer buf = new StringBuffer(100);
        if (pathPrefix != null) {
            buf.append(pathPrefix);
        }
        buf.append(ApiDocContentWriter.toSafeUri(mod.getId()));
        buf.append("/");
        buf.append(ApiDocContentWriter.toSafeUri(namespace.getId()));
        buf.append("/");
        buf.append(ApiDocContentWriter.toSafeUri(ec.getId()));
        buf.append("/index.html");
        return buf.toString();
    }
}

