/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.x4o.xml.eld.EldModuleLoader;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageLoader;
import org.x4o.xml.lang.X4OLanguageLoaderException;
import org.x4o.xml.lang.X4OLanguageLocal;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageModuleLoader;
import org.x4o.xml.lang.X4OLanguageModuleLoaderSibling;
import org.x4o.xml.lang.X4OLanguageVersionFilter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultX4OLanguageLoader
implements X4OLanguageLoader {
    private Logger logger = Logger.getLogger(DefaultX4OLanguageLoader.class.getName());
    protected List<Map<String, Map<String, String>>> modulesAll = new ArrayList<Map<String, Map<String, String>>>(20);

    private void logMessage(X4OLanguage language, String message) {
        this.logger.finest(message + " from: " + language.getLanguageName());
    }

    public void loadLanguage(X4OLanguageLocal languageLocal, String language, String languageVersion) throws X4OLanguageLoaderException {
        try {
            this.logger.finer("Loading all modules for language: " + language);
            this.loadLanguageModules(languageLocal, language);
            X4OLanguageVersionFilter lvf = (X4OLanguageVersionFilter)X4OLanguageClassLoader.newInstance(languageLocal.getLanguageConfiguration().getDefaultLanguageVersionFilter());
            for (Map<String, Map<String, String>> map : this.modulesAll) {
                ArrayList<String> versions = new ArrayList<String>(map.keySet());
                String modulesVersion = lvf.filterVersion(languageVersion, versions);
                if (modulesVersion == null) {
                    throw new X4OLanguageLoaderException("No modules config for version: " + languageVersion);
                }
                Map<String, String> modules = map.get(modulesVersion);
                this.logger.finer("Filtered modules to version: " + modulesVersion);
                if (modules == null) {
                    throw new X4OLanguageLoaderException("No modules defined for version: " + modulesVersion);
                }
                for (String key : modules.keySet()) {
                    String value = modules.get(key);
                    X4OLanguageModule module = (X4OLanguageModule)X4OLanguageClassLoader.newInstance(languageLocal.getLanguageConfiguration().getDefaultElementLanguageModule());
                    module.setSourceResource(value);
                    this.logMessage(languageLocal, "Parsing language config key: " + key + " value: " + value);
                    if ("module-loader".equals(key)) {
                        try {
                            module.setLanguageModuleLoader((X4OLanguageModuleLoader)X4OLanguageClassLoader.loadClass(value).newInstance());
                        }
                        catch (Exception ee) {
                            throw new SAXException("Could not load: " + value + " error: " + ee.getMessage(), ee);
                        }
                    }
                    if ("eld-resource".equals(key)) {
                        String languagePrefix = languageLocal.getLanguageConfiguration().getLanguageResourcePathPrefix();
                        String resource = languagePrefix + "/" + language + "/" + value;
                        if (language.equals("eld")) {
                            module.setLanguageModuleLoader(new EldModuleLoader(resource, true));
                        } else {
                            module.setLanguageModuleLoader(new EldModuleLoader(resource, false));
                        }
                        module.setSourceResource(resource);
                    } else if ("elb-resource".equals(key)) {
                        this.logger.finer("elb-resources are not done yet.");
                    } else if ("sibling-loader".equals(key)) {
                        try {
                            module.setLanguageModuleLoader((X4OLanguageModuleLoaderSibling)X4OLanguageClassLoader.loadClass(value).newInstance());
                        }
                        catch (Exception ee) {
                            throw new SAXException("Could not load: " + value + " error: " + ee.getMessage(), ee);
                        }
                    }
                    if (module.getLanguageModuleLoader() == null) {
                        this.logger.warning("module with null loader: " + module + " tag: " + key + " chars: " + value);
                        continue;
                    }
                    this.logMessage(languageLocal, "Starting modules: " + module + " for language: " + language);
                    module.getLanguageModuleLoader().loadLanguageModule(languageLocal, module);
                    languageLocal.addLanguageModule(module);
                }
            }
        }
        catch (Exception e1) {
            throw new X4OLanguageLoaderException(e1.getMessage() + " for language: " + language, e1);
        }
    }

    protected void loadLanguageModules(X4OLanguageLocal languageLocal, String language) throws IOException, SAXException {
        URL u;
        StringBuilder buf = new StringBuilder(150);
        buf.append(languageLocal.getLanguageConfiguration().getLanguageResourcePathPrefix());
        buf.append('/');
        buf.append(language);
        buf.append('/');
        buf.append(language);
        buf.append(languageLocal.getLanguageConfiguration().getLanguageResourceModulesFileName());
        this.logger.finer("loading X4O language: " + language);
        Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(buf.toString());
        while (e.hasMoreElements()) {
            u = e.nextElement();
            this.logMessage(languageLocal, "Loading relative modules: " + u + " for: " + language);
            this.loadModulesXml(u.openStream());
        }
        e = Thread.currentThread().getContextClassLoader().getResources("/" + buf.toString());
        while (e.hasMoreElements()) {
            u = e.nextElement();
            this.logMessage(languageLocal, "Loading root modules: " + u + " for: " + language);
            this.loadModulesXml(u.openStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModulesXml(InputStream in) throws IOException, SAXException {
        if (in == null) {
            throw new NullPointerException("Can't parse null input stream");
        }
        ModulesTagHandler xth = new ModulesTagHandler();
        XMLReader saxParser = XMLReaderFactory.createXMLReader();
        saxParser.setContentHandler(xth);
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", xth);
        saxParser.setProperty("http://xml.org/sax/properties/declaration-handler", xth);
        try {
            saxParser.parse(new InputSource(in));
        }
        finally {
            in.close();
        }
    }

    private class ModulesTagHandler
    extends DefaultHandler2 {
        private StringBuffer buf = new StringBuffer();
        private String version = null;

        private ModulesTagHandler() {
        }

        public void startDocument() throws SAXException {
            DefaultX4OLanguageLoader.this.modulesAll.add(new HashMap(20));
        }

        public void startElement(String namespaceUri, String tag, String qName, Attributes attr) throws SAXException {
            if ("language".equals(tag)) {
                this.version = attr.getValue("version");
                DefaultX4OLanguageLoader.this.logger.finest("Version attribute: " + this.version);
            }
        }

        public void endElement(String namespaceUri, String tag, String qName) throws SAXException {
            String value = this.buf.toString();
            this.buf = new StringBuffer();
            if ("modules".equals(tag)) {
                return;
            }
            if ("language".equals(tag)) {
                return;
            }
            if (this.version == null) {
                return;
            }
            Map<String, String> modules = DefaultX4OLanguageLoader.this.modulesAll.get(DefaultX4OLanguageLoader.this.modulesAll.size() - 1).get(this.version);
            if (modules == null) {
                modules = new HashMap<String, String>(20);
                DefaultX4OLanguageLoader.this.modulesAll.get(DefaultX4OLanguageLoader.this.modulesAll.size() - 1).put(this.version, modules);
            }
            modules.put(tag, value);
            DefaultX4OLanguageLoader.this.logger.finest("Stored tag: " + tag + " value: " + value);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length).trim();
            if (text.length() == 0) {
                return;
            }
            this.buf.append(text);
        }
    }
}

