/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.io.sax.X4OContentHandler;
import org.x4o.xml.io.sax.X4OEntityResolver;
import org.x4o.xml.io.sax.X4OErrorHandler;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class X4OContentParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(X4OLanguageContext languageContext) throws SAXException, IOException {
        Object requestSystemId;
        Object value;
        X4OContentHandler xth = new X4OContentHandler(languageContext);
        XMLReader saxParser = XMLReaderFactory.createXMLReader();
        saxParser.setErrorHandler(new X4OErrorHandler(languageContext));
        saxParser.setEntityResolver(new X4OEntityResolver(languageContext));
        saxParser.setContentHandler(xth);
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", xth);
        saxParser.setProperty("http://xml.org/sax/properties/declaration-handler", xth);
        Map<String, Object> saxParserProperties = languageContext.getLanguage().getLanguageConfiguration().getSAXParserProperties(languageContext);
        for (Map.Entry<String, Object> entry : saxParserProperties.entrySet()) {
            String name = entry.getKey();
            Object value2 = entry.getValue();
            saxParser.setProperty(name, value2);
            this.debugMessage("Set SAX property: " + name + " to: " + value2, languageContext);
        }
        Map<String, Object> saxParserPropertiesOptional = languageContext.getLanguage().getLanguageConfiguration().getSAXParserPropertiesOptional(languageContext);
        for (Map.Entry<String, Object> entry : saxParserPropertiesOptional.entrySet()) {
            String name = entry.getKey();
            value = entry.getValue();
            try {
                saxParser.setProperty(name, value);
                this.debugMessage("Set SAX optional property: " + name + " to: " + value, languageContext);
            }
            catch (SAXException e) {
                this.debugMessage("Could not set optional SAX property: " + name + " to: " + value + " error: " + e.getMessage(), languageContext);
            }
        }
        Map<String, Boolean> features = languageContext.getLanguage().getLanguageConfiguration().getSAXParserFeatures(languageContext);
        for (String key : features.keySet()) {
            value = features.get(key);
            saxParser.setFeature(key, (Boolean)value);
            this.debugMessage("Set SAX feature: " + key + " to: " + value, languageContext);
        }
        Map<String, Boolean> featuresOptional = languageContext.getLanguage().getLanguageConfiguration().getSAXParserFeaturesOptional(languageContext);
        for (String key : featuresOptional.keySet()) {
            Boolean value3 = featuresOptional.get(key);
            try {
                saxParser.setFeature(key, value3);
                this.debugMessage("Set SAX optional feature: " + key + " to: " + value3, languageContext);
            }
            catch (SAXException e) {
                this.debugMessage("Could not set optional SAX feature: " + key + " to: " + value3 + " error: " + e.getMessage(), languageContext);
            }
        }
        List<String> requiredFeatures = languageContext.getLanguage().getLanguageConfiguration().getSAXParserFeaturesRequired(languageContext);
        for (String requiredFeature : requiredFeatures) {
            this.debugMessage("Checking required SAX feature: " + requiredFeature, languageContext);
            if (saxParser.getFeature(requiredFeature)) continue;
            throw new IllegalStateException("Missing required feature: " + requiredFeature);
        }
        Object requestInputSource = languageContext.getLanguageProperty(X4OLanguageProperty.READER_INPUT_SOURCE);
        InputSource input = null;
        InputStream inputStream = null;
        if (requestInputSource instanceof InputSource) {
            input = (InputSource)requestInputSource;
        } else {
            inputStream = (InputStream)languageContext.getLanguageProperty(X4OLanguageProperty.READER_INPUT_STREAM);
            input = new InputSource(inputStream);
        }
        Object requestInputEncoding = languageContext.getLanguageProperty(X4OLanguageProperty.READER_INPUT_ENCODING);
        if (requestInputEncoding != null && requestInputEncoding instanceof String) {
            input.setEncoding(requestInputEncoding.toString());
        }
        if ((requestSystemId = languageContext.getLanguageProperty(X4OLanguageProperty.READER_INPUT_SYSTEM_ID)) != null && requestSystemId instanceof String) {
            input.setSystemId(requestSystemId.toString());
        }
        try {
            saxParser.parse(input);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void debugMessage(String message, X4OLanguageContext languageContext) throws SAXException {
        if (languageContext.hasX4ODebugWriter()) {
            try {
                languageContext.getX4ODebugWriter().debugPhaseMessage(message, X4OContentParser.class);
            }
            catch (ElementException ee) {
                throw new SAXException(ee);
            }
        }
    }
}

