/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.lang;

import java.util.List;
import org.x4o.xml.element.AbstractElementConfigurator;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementConfiguratorException;

public class AttributeFromBodyConfigurator
extends AbstractElementConfigurator {
    private String name = null;
    private String bodyType = null;

    public void doConfigElement(Element element) throws ElementConfiguratorException {
        if (this.name == null) {
            throw new ElementConfiguratorException(this, "name attribute is not set.");
        }
        if (this.name.length() == 0) {
            throw new ElementConfiguratorException(this, "name attribute is empty.");
        }
        if (this.bodyType == null) {
            this.bodyType = Element.ElementType.characters.name();
        }
        String value = null;
        if ("characters".equals(this.bodyType)) {
            value = this.fetchBodyType(element, Element.ElementType.characters);
        } else if ("comment".equals(this.bodyType)) {
            value = this.fetchBodyType(element, Element.ElementType.comment);
        } else if ("ignorableWhitespace".equals(this.bodyType)) {
            value = this.fetchBodyType(element, Element.ElementType.ignorableWhitespace);
        } else {
            throw new ElementConfiguratorException(this, "bodyType attribute value is unknown; " + this.bodyType);
        }
        if (value.trim().length() == 0) {
            return;
        }
        element.getAttributes().put(this.name, value);
    }

    private String fetchBodyType(Element element, Element.ElementType elementType) {
        StringBuffer buf = new StringBuffer(300);
        List<Element> childsAll = element.getAllChilderen();
        List<Element> childs = Element.ElementType.filterElements(childsAll, elementType);
        for (int i = 0; i < childs.size(); ++i) {
            Element e = childs.get(i);
            buf.append(e.getElementObject().toString());
        }
        return buf.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }
}

