/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.conv;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterProvider;
import org.x4o.xml.conv.text.BooleanConverter;
import org.x4o.xml.conv.text.ByteConverter;
import org.x4o.xml.conv.text.CharacterConverter;
import org.x4o.xml.conv.text.ClassConverter;
import org.x4o.xml.conv.text.DoubleConverter;
import org.x4o.xml.conv.text.FloatConverter;
import org.x4o.xml.conv.text.IntegerConverter;
import org.x4o.xml.conv.text.LongConverter;
import org.x4o.xml.conv.text.URLConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectConverterProvider
implements ObjectConverterProvider {
    private Map<Class<?>, ObjectConverter> converters = new HashMap(20);

    public DefaultObjectConverterProvider() {
    }

    public DefaultObjectConverterProvider(boolean addDefaults) {
        this();
        if (addDefaults) {
            this.addDefaults();
        }
    }

    public void addDefaults() {
        this.addObjectConverter(new BooleanConverter());
        this.addObjectConverter(new ByteConverter());
        this.addObjectConverter(new CharacterConverter());
        this.addObjectConverter(new DoubleConverter());
        this.addObjectConverter(new FloatConverter());
        this.addObjectConverter(new IntegerConverter());
        this.addObjectConverter(new LongConverter());
        this.addObjectConverter(new URLConverter());
        this.addObjectConverter(new ClassConverter());
    }

    public void addObjectConverter(ObjectConverter converter) {
        this.converters.put(converter.getObjectClassTo(), converter);
    }

    @Override
    public ObjectConverter getObjectConverterForClass(Class<?> clazz) {
        return this.converters.get(clazz);
    }

    protected Collection<ObjectConverter> getObjectConverters() {
        return this.converters.values();
    }
}

