/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.check.CheckElement;

public class CheckAnnotation
extends CheckElement {
    private int begin;
    private int end;
    private String typeName;
    private String coveredText;
    private String shortTypeName;
    private Map<Feature, String> features;

    public CheckAnnotation(AnnotationFS afs) {
        this.begin = afs.getBegin();
        this.end = afs.getEnd();
        this.typeName = afs.getType().getName();
        this.shortTypeName = afs.getType().getShortName();
        this.coveredText = afs.getCoveredText();
        this.features = new HashMap<Feature, String>();
        for (Feature feat : afs.getType().getFeatures()) {
            try {
                this.features.put(feat, afs.getFeatureValueAsString(feat));
            }
            catch (Exception e) {}
        }
    }

    public AnnotationFS toAnnotationFS(CAS cas, Type type) {
        AnnotationFS afs = cas.createAnnotation(type, this.begin, this.end);
        for (Map.Entry<Feature, String> entry : this.features.entrySet()) {
            afs.setFeatureValueFromString(entry.getKey(), entry.getValue());
        }
        return afs;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getCoveredText() {
        return this.coveredText;
    }

    public void setCoveredText(String coveredText) {
        this.coveredText = coveredText;
    }

    public String getShortType() {
        return this.shortTypeName;
    }

    public void setShortType(String shortType) {
        this.shortTypeName = shortType;
    }

    public Map<Feature, String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<Feature, String> features) {
        this.features = features;
    }
}

