/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.Extension;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.websocket.PerMessageDeflate;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationBuilder;
import org.apache.tomcat.websocket.WsExtension;

public class TransformationFactory {
    private static final TransformationFactory factory = new TransformationFactory();
    private Map<String, TransformationBuilder> builders = new HashMap<String, TransformationBuilder>();

    private TransformationFactory() {
        this.builders.put("permessage-deflate", PerMessageDeflate.BUILDER);
    }

    public static TransformationFactory getInstance() {
        return factory;
    }

    public Transformation create(String name, List<List<Extension.Parameter>> preferences, boolean isServer) {
        TransformationBuilder builder = this.builders.get(name);
        if (builder != null) {
            return builder.build(preferences, isServer);
        }
        return null;
    }

    public void registerExtension(String name, TransformationBuilder builder) {
        this.builders.put(name, builder);
    }

    public Set<String> getInstalledExtensionNames() {
        return new HashSet<String>(this.builders.keySet());
    }

    public Set<Extension> getInstalledExtensions() {
        HashSet<WsExtension> result = new HashSet<WsExtension>();
        for (String extensionName : this.builders.keySet()) {
            result.add(new WsExtension(extensionName));
        }
        return Collections.unmodifiableSet(result);
    }
}

