/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.longs;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class Fixed64PackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new Fixed64PackedWriters(protoField));
    }

    private static class Fixed64PackedWriters
    extends AbstractPrimitiveWriters<long[], Long> {
        public Fixed64PackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (long element : array) {
                    output.writePackedFixed64(element);
                }
            });
            this.arrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (Long element : array) {
                    if (element != null) {
                        output.writePackedFixed64(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.collectionWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                for (Long element : collection) {
                    if (element != null) {
                        output.writePackedFixed64(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.stringArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        long parsedValue = Long.parseLong(element, 10);
                        output.writePackedFixed64(parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
        }
    }
}

