/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementBase;
import org.apache.jena.rdf.model.impl.StatementTermImpl;
import org.apache.jena.shared.JenaException;

public class StatementImpl
extends StatementBase
implements Statement {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;
    protected static ModelCom empty = (ModelCom)ModelFactory.createDefaultModel();

    public StatementImpl(Resource subject, Property predicate, RDFNode object, ModelCom model) {
        super(model);
        this.subject = subject.inModel(model);
        this.predicate = predicate.inModel(model);
        this.object = object.inModel(model);
    }

    public StatementImpl(Resource subject, Property predicate, RDFNode object) {
        super(empty);
        this.subject = subject.inModel(this.model);
        this.predicate = predicate.inModel(this.model);
        this.object = object.inModel(this.model);
    }

    public static Statement toStatement(Triple t, ModelCom eg) {
        ResourceImpl s = new ResourceImpl(t.getSubject(), eg);
        PropertyImpl p = new PropertyImpl(t.getPredicate(), (EnhGraph)eg);
        RDFNode o = StatementImpl.createObject(t.getObject(), eg);
        return new StatementImpl(s, p, o, eg);
    }

    @Override
    public Resource getSubject() {
        return this.subject;
    }

    @Override
    public Property getPredicate() {
        return this.predicate;
    }

    @Override
    public RDFNode getObject() {
        return this.object;
    }

    @Override
    public Statement getStatementProperty(Property p) {
        return this.getResource().getRequiredProperty(p);
    }

    @Override
    public Resource getResource() {
        return this.mustBeResource(this.object);
    }

    @Override
    public Statement getProperty(Property p) {
        return this.getResource().getRequiredProperty(p);
    }

    @Override
    public Literal getLiteral() {
        if (this.object instanceof Literal) {
            return (Literal)this.object;
        }
        throw new LiteralRequiredException(this.object);
    }

    @Override
    public Bag getBag() {
        return this.object.as(Bag.class);
    }

    @Override
    public Alt getAlt() {
        return this.object.as(Alt.class);
    }

    @Override
    public Seq getSeq() {
        return this.object.as(Seq.class);
    }

    @Override
    public RDFList getList() {
        return this.object.as(RDFList.class);
    }

    @Override
    protected StatementImpl replace(RDFNode n) {
        StatementImpl s = new StatementImpl(this.subject, this.predicate, n, this.model);
        this.model.remove(this).add(s);
        return s;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Statement && this.sameAs((Statement)o);
    }

    private final boolean sameAs(Statement o) {
        return this.subject.equals(o.getSubject()) && this.predicate.equals(o.getPredicate()) && this.object.equals(o.getObject());
    }

    @Override
    public int hashCode() {
        return this.asTriple().hashCode();
    }

    @Override
    public Statement remove() {
        this.model.remove(this);
        return this;
    }

    @Override
    public Triple asTriple() {
        return Triple.create(this.subject.asNode(), this.predicate.asNode(), this.object.asNode());
    }

    public static Triple[] asTriples(Statement[] statements) {
        Triple[] triples = new Triple[statements.length];
        for (int i = 0; i < statements.length; ++i) {
            triples[i] = statements[i].asTriple();
        }
        return triples;
    }

    public static RDFNode createObject(Node n, EnhGraph g) {
        if (n.isBlank() || n.isURI()) {
            return new ResourceImpl(n, g);
        }
        if (n.isLiteral()) {
            return new LiteralImpl(n, g);
        }
        if (n.isTripleTerm()) {
            return new StatementTermImpl(n, g);
        }
        if (Node.ANY.equals(n)) {
            return new ResourceImpl(n, g);
        }
        throw new JenaException("Node type not compatible with Model: " + String.valueOf(n));
    }
}

