/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation.event;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.shacl.engine.constraint.DatatypeConstraint;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluationEvent;
import org.apache.jena.shacl.validation.event.EventUtil;
import org.apache.jena.shacl.validation.event.FocusNodeValidationEvent;
import org.apache.jena.shacl.validation.event.ShapeValidationEvent;
import org.apache.jena.shacl.validation.event.ValidationEvent;

public abstract class EventPredicates {
    public static Predicate<ValidationEvent> isOfType(Class<? extends ValidationEvent> type) {
        return e -> type.equals(e.getClass());
    }

    public static Predicate<ValidationEvent> isOfTypeOrSubtype(Class<? extends ValidationEvent> type) {
        return e -> EventUtil.getSuperclassesAndInterfaces(e.getClass()).anyMatch(s -> s.equals(type));
    }

    public static <E extends ValidationEvent> Predicate<ValidationEvent> testIfType(Class<E> type, Predicate<E> predicate, boolean defaultValue) {
        return e -> EventPredicates.testIfType(e, type, predicate, defaultValue);
    }

    public static <E extends ValidationEvent> Predicate<ValidationEvent> testIfTypeElseFalse(Class<E> type, Predicate<E> predicate) {
        return e -> EventPredicates.testIfType(e, type, predicate, false);
    }

    private static <E extends ValidationEvent> boolean testIfType(ValidationEvent e, Class<E> type, Predicate<E> predicate, boolean defaultValue) {
        if (type.isAssignableFrom(e.getClass())) {
            return predicate.test((ValidationEvent)type.cast(e));
        }
        return defaultValue;
    }

    public static NodePredicate<ShapeValidationEvent> shapeNode() {
        return new NodePredicate<ShapeValidationEvent>(ShapeValidationEvent.class, e -> e.getShape().getShapeNode());
    }

    public static NodePredicate<FocusNodeValidationEvent> focusNode() {
        return new NodePredicate<FocusNodeValidationEvent>(FocusNodeValidationEvent.class, FocusNodeValidationEvent::getFocusNode);
    }

    public static Predicate<ValidationEvent> hasConstraintOfType(Class<? extends Constraint> constraintType) {
        Objects.requireNonNull(constraintType);
        return EventPredicates.testIfType(ConstraintEvaluationEvent.class, e -> constraintType.isAssignableFrom(e.getConstraint().getClass()), false);
    }

    public static Predicate<ValidationEvent> hasDatatypeConstraint() {
        return EventPredicates.hasConstraintOfType(DatatypeConstraint.class);
    }

    public static Predicate<ValidationEvent> isValid() {
        return EventPredicates.testIfTypeElseFalse(ConstraintEvaluatedEvent.class, ConstraintEvaluatedEvent::isValid);
    }

    public static class NodePredicate<E extends ValidationEvent> {
        private final Function<ValidationEvent, Node> nodeAccessor = e -> type.isAssignableFrom(e.getClass()) ? (Node)nodeAccessor.apply(e) : null;

        public NodePredicate(Class<E> type, Function<E, Node> nodeAccessor) {
        }

        public Predicate<ValidationEvent> makePredicate(Predicate<Node> predicate) {
            return e -> Optional.ofNullable(this.nodeAccessor.apply((ValidationEvent)e)).map(predicate::test).orElse(false);
        }

        public Predicate<ValidationEvent> isBlank() {
            return this.makePredicate(Node::isBlank);
        }

        public Predicate<ValidationEvent> isLiteral() {
            return this.makePredicate(Node::isLiteral);
        }

        public Predicate<ValidationEvent> uriEquals(String uri) {
            return this.makePredicate(n -> n.isURI() && n.getURI().equals(uri));
        }

        public Predicate<ValidationEvent> literalEquals(LiteralLabel literalLabel) {
            return this.makePredicate(n -> n.isLiteral() && n.getLiteral().sameValueAs(literalLabel));
        }
    }
}

