/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.actionstate;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.InputEvent;
import org.apache.flink.agents.api.OutputEvent;
import org.apache.flink.agents.runtime.actionstate.ActionState;
import org.apache.flink.agents.runtime.operator.ActionTask;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionStateKafkaSeder
implements Serializer<ActionState>,
Deserializer<ActionState> {
    private static final Logger LOG = LoggerFactory.getLogger(ActionStateKafkaSeder.class);
    private static final ObjectMapper OBJECT_MAPPER = ActionStateKafkaSeder.createObjectMapper();

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public ActionState deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(data, ActionState.class);
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize ActionState for topic: {}", (Object)topic, (Object)e);
            throw new RuntimeException("Failed to deserialize ActionState", e);
        }
    }

    @Override
    public byte[] serialize(String topic, ActionState data) {
        if (data == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(data);
        }
        catch (Exception e) {
            LOG.error("Failed to serialize ActionState for topic: {}", (Object)topic, (Object)e);
            throw new RuntimeException("Failed to serialize ActionState", e);
        }
    }

    @Override
    public void close() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(Event.class, EventTypeInfoMixin.class);
        mapper.addMixIn(InputEvent.class, EventTypeInfoMixin.class);
        mapper.addMixIn(OutputEvent.class, EventTypeInfoMixin.class);
        SimpleModule module = new SimpleModule();
        module.addSerializer(ActionTask.class, new ActionTaskSerializer());
        mapper.registerModule(module);
        return mapper;
    }

    public static class ActionTaskSerializer
    extends JsonSerializer<ActionTask> {
        @Override
        public void serialize(ActionTask value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNull();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    public static abstract class EventTypeInfoMixin {
    }
}

