/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;

public final class Abs
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item arg, XPathContext context) {
        return ((NumericValue)arg).abs();
    }

    @Override
    public Elaborator getElaborator() {
        return new AbsElaborator();
    }

    public static class AbsElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator argEval = fnc.getArg(0).makeElaborator().elaborateForItem();
            boolean nullable = Cardinality.allowsZero(fnc.getArg(0).getCardinality());
            if (nullable) {
                return context -> {
                    NumericValue result = (NumericValue)argEval.eval(context);
                    if (result == null) {
                        return null;
                    }
                    return result.abs();
                };
            }
            return context -> ((NumericValue)argEval.eval(context)).abs();
        }
    }
}

