/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.Suppliers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayUtilsTest
extends AbstractLangTest {
    private static final long SEED = 16111981L;

    ArrayUtilsTest() {
    }

    private static Random seededRandom() {
        return new Random(16111981L);
    }

    @SafeVarargs
    private static <T> T[] toArrayPropagatingType(T ... items) {
        return ArrayUtils.toArray((Object[])items);
    }

    private void assertIsEquals(Object array1, Object array2, Object array3) {
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array1, (Object)array1));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array2, (Object)array2));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array3));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array3, (Object)array1));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
    }

    @Test
    void testArraycopyFunction() {
        String[] arr = new String[]{"a", "b"};
        LangAssertions.assertNullPointerException(() -> ArrayUtils.arraycopy(null, (int)0, (int)0, (int)1, i -> new String[3]));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.arraycopy((Object)arr, (int)0, (int)0, (int)1, i -> null));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.arraycopy((Object)arr, (int)0, (int)0, (int)1, (Function)null));
    }

    @Test
    void testArraycopySupplier() {
        String[] arr = new String[]{"a", "b"};
        LangAssertions.assertNullPointerException(() -> ArrayUtils.arraycopy(null, (int)0, (int)0, (int)1, () -> new String[3]));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.arraycopy((Object)arr, (int)0, (int)0, (int)1, (Supplier)Suppliers.nul()));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.arraycopy((Object)arr, (int)0, (int)0, (int)1, (Supplier)null));
    }

    @Test
    void testArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)"foo", (Object)array[0]);
        Assertions.assertEquals((Object)"bar", (Object)array[1]);
    }

    @Test
    void testArrayCreationWithDifferentTypes() {
        Number[] array = (Number[])ArrayUtils.toArray((Object[])new Number[]{42, Math.PI});
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)42, (Object)array[0]);
        Assertions.assertEquals((Object)Math.PI, (Object)array[1]);
    }

    @Test
    void testArrayCreationWithGeneralReturnType() {
        Object[] obj = ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Assertions.assertInstanceOf(String[].class, (Object)obj);
    }

    @Test
    void testClone() {
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.clone((Object[])null));
        Object[] original1 = new Object[]{};
        Object[] cloned1 = ArrayUtils.clone((Object[])original1);
        Assertions.assertArrayEquals((Object[])original1, (Object[])cloned1);
        Assertions.assertNotSame((Object)original1, (Object)cloned1);
        StringBuilder builder = new StringBuilder("pick");
        original1 = new Object[]{builder, "a", new String[]{"stick"}};
        cloned1 = ArrayUtils.clone((Object[])original1);
        Assertions.assertArrayEquals((Object[])original1, (Object[])cloned1);
        Assertions.assertNotSame((Object)original1, (Object)cloned1);
        Assertions.assertSame((Object)original1[0], (Object)cloned1[0]);
        Assertions.assertSame((Object)original1[1], (Object)cloned1[1]);
        Assertions.assertSame((Object)original1[2], (Object)cloned1[2]);
    }

    @Test
    void testCloneBoolean() {
        Assertions.assertNull((Object)ArrayUtils.clone((boolean[])null));
        boolean[] original = new boolean[]{true, false};
        boolean[] cloned = ArrayUtils.clone((boolean[])original);
        Assertions.assertArrayEquals((boolean[])original, (boolean[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneByte() {
        Assertions.assertNull((Object)ArrayUtils.clone((byte[])null));
        byte[] original = new byte[]{1, 6};
        byte[] cloned = ArrayUtils.clone((byte[])original);
        Assertions.assertArrayEquals((byte[])original, (byte[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneChar() {
        Assertions.assertNull((Object)ArrayUtils.clone((char[])null));
        char[] original = new char[]{'a', '4'};
        char[] cloned = ArrayUtils.clone((char[])original);
        Assertions.assertArrayEquals((char[])original, (char[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneDouble() {
        Assertions.assertNull((Object)ArrayUtils.clone((double[])null));
        double[] original = new double[]{2.4, 5.7};
        double[] cloned = ArrayUtils.clone((double[])original);
        Assertions.assertArrayEquals((double[])original, (double[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneFloat() {
        Assertions.assertNull((Object)ArrayUtils.clone((float[])null));
        float[] original = new float[]{2.6f, 6.4f};
        float[] cloned = ArrayUtils.clone((float[])original);
        Assertions.assertArrayEquals((float[])original, (float[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneInt() {
        Assertions.assertNull((Object)ArrayUtils.clone((int[])null));
        int[] original = new int[]{5, 8};
        int[] cloned = ArrayUtils.clone((int[])original);
        Assertions.assertArrayEquals((int[])original, (int[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneLong() {
        Assertions.assertNull((Object)ArrayUtils.clone((long[])null));
        long[] original = new long[]{0L, 1L};
        long[] cloned = ArrayUtils.clone((long[])original);
        Assertions.assertArrayEquals((long[])original, (long[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testCloneShort() {
        Assertions.assertNull((Object)ArrayUtils.clone((short[])null));
        short[] original = new short[]{1, 4};
        short[] cloned = ArrayUtils.clone((short[])original);
        Assertions.assertArrayEquals((short[])original, (short[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new ArrayUtils());
        Constructor<?>[] cons = ArrayUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ArrayUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ArrayUtils.class.getModifiers()));
    }

    @Test
    void testContains() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertFalse((boolean)ArrayUtils.contains(null, null));
        Assertions.assertFalse((boolean)ArrayUtils.contains(null, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"0"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"2"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"3"));
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])array, (Object)"notInArray"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, null));
        String stringToFind = "4";
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])new String[]{"4"}, (Object)new Object()));
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])new String[]{"4"}, (Object)1));
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])new Charset[]{StandardCharsets.US_ASCII}, (Object)1));
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])new TestClass[]{new TestClass()}, (Object)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])new Object[]{"4"}, (Object)"4"));
        String csToFind = "4";
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])new String[]{"4"}, (Object)csToFind));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])new CharSequence[]{"4"}, (Object)"4"));
    }

    @Test
    void testContains_LANG_1261() {
        final class LANG1261ChildObject
        extends LANG1261ParentObject {
            LANG1261ChildObject() {
                class LANG1261ParentObject {
                    LANG1261ParentObject() {
                    }

                    public boolean equals(Object o) {
                        return true;
                    }

                    public int hashCode() {
                        return 0;
                    }
                }
            }
        }
        Object[] array = new LANG1261ChildObject[]{new LANG1261ChildObject()};
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)new LANG1261ParentObject()));
    }

    @Test
    void testContainsAnyEnum() {
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((Object[])ElementType.values(), (Object[])new Object[]{ElementType.ANNOTATION_TYPE}));
        Assertions.assertFalse((boolean)ArrayUtils.containsAny((Object[])ElementType.values(), (Object[])new Object[]{null}));
    }

    @Test
    void testContainsAnyInt() {
        int[] array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertFalse((boolean)ArrayUtils.containsAny((int[])null, (int[])new int[]{1}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((int[])array, (int[])new int[]{0}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((int[])array, (int[])new int[]{1}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((int[])array, (int[])new int[]{2}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((int[])array, (int[])new int[]{3}));
    }

    @Test
    void testContainsAnyObject() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertFalse((boolean)ArrayUtils.containsAny(null, (Object[])new Object[]{null}));
        Assertions.assertFalse((boolean)ArrayUtils.containsAny(null, (Object[])new Object[]{"1"}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((Object[])array, (Object[])new Object[]{"0"}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((Object[])array, (Object[])new Object[]{"1"}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((Object[])array, (Object[])new Object[]{"2"}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((Object[])array, (Object[])new Object[]{"3"}));
        Assertions.assertFalse((boolean)ArrayUtils.containsAny((Object[])array, (Object[])new Object[]{"notInArray"}));
        Assertions.assertTrue((boolean)ArrayUtils.containsAny((Object[])array, (Object[])new String[]{null}));
    }

    @Test
    void testContainsBoolean() {
        boolean[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assertions.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        Assertions.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        Assertions.assertFalse((boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
    }

    @Test
    void testContainsByte() {
        byte[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (byte)1));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)2));
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)3));
        Assertions.assertFalse((boolean)ArrayUtils.contains((byte[])array, (byte)99));
    }

    @Test
    void testContainsChar() {
        char[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (char)'b'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'a'));
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'b'));
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'c'));
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'d'));
        Assertions.assertFalse((boolean)ArrayUtils.contains((char[])array, (char)'e'));
    }

    @Test
    void testContainsDouble() {
        double[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (double)1.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)0.0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)1.0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)3.0));
        Assertions.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)99.0));
    }

    @Test
    void testContainsDoubleNaN() {
        double[] a = new double[]{Double.NEGATIVE_INFINITY, Double.NaN, Double.POSITIVE_INFINITY};
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])a, (double)Double.POSITIVE_INFINITY));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])a, (double)Double.NEGATIVE_INFINITY));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])a, (double)Double.NaN));
    }

    @Test
    void testContainsDoubleTolerance() {
        double[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (double)1.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)4.0, (double)0.33));
        Assertions.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.49));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.5));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.51));
    }

    @Test
    void testContainsFloat() {
        float[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (float)1.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)0.0f));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)1.0f));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)2.0f));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)3.0f));
        Assertions.assertFalse((boolean)ArrayUtils.contains((float[])array, (float)99.0f));
    }

    @Test
    void testContainsFloatNaN() {
        float[] array = new float[]{Float.NEGATIVE_INFINITY, Float.NaN, Float.POSITIVE_INFINITY};
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)Float.POSITIVE_INFINITY));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)Float.NEGATIVE_INFINITY));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)Float.NaN));
    }

    @Test
    void testContainsInt() {
        int[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (int)1));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)2));
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)3));
        Assertions.assertFalse((boolean)ArrayUtils.contains((int[])array, (int)99));
    }

    @Test
    void testContainsLong() {
        long[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (long)1L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)0L));
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)1L));
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)2L));
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)3L));
        Assertions.assertFalse((boolean)ArrayUtils.contains((long[])array, (long)99L));
    }

    @Test
    void testContainsShort() {
        short[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (short)1));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)2));
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)3));
        Assertions.assertFalse((boolean)ArrayUtils.contains((short[])array, (short)99));
    }

    @Test
    void testEmptyArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[0]);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testGet() {
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)-1));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)0));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)1));
        Object[] array0 = new String[]{};
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)-1));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)0));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)1));
        Object[] array1 = new String[]{""};
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array1, (int)-1));
        Assertions.assertEquals((Object)"", (Object)ArrayUtils.get((Object[])array1, (int)0));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array1, (int)1));
    }

    @Test
    void testGetComponentType() {
        Object[] newArray = new TestClass[]{};
        Class componentType = ArrayUtils.getComponentType((Object[])newArray);
        Assertions.assertEquals(TestClass.class, (Object)componentType);
        Assertions.assertNull((Object)ArrayUtils.getComponentType(null));
    }

    @Test
    void testGetDefault() {
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)-1, null));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)0, null));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)1, null));
        Object[] array0 = new String[]{};
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)-1, null));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)0, null));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)1, null));
        Object[] array1 = new String[]{""};
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array1, (int)-1, null));
        Assertions.assertEquals((Object)"", (Object)ArrayUtils.get((Object[])array1, (int)0, null));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array1, (int)1, null));
        String defaultValue = "defaultValue";
        array1 = new String[]{""};
        Assertions.assertEquals((Object)"defaultValue", (Object)ArrayUtils.get((Object[])array1, (int)-1, (Object)"defaultValue"));
        Assertions.assertEquals((Object)"", (Object)ArrayUtils.get((Object[])array1, (int)0, (Object)"defaultValue"));
        Assertions.assertEquals((Object)"defaultValue", (Object)ArrayUtils.get((Object[])array1, (int)1, (Object)"defaultValue"));
    }

    @Test
    void testGetLength() {
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Object[] emptyObjectArray = new Object[]{};
        Object[] notEmptyObjectArray = new Object[]{"aValue"};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyObjectArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyObjectArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyIntArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyShortArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyCharArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyByteArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyDoubleArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyFloatArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyBooleanArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyBooleanArray));
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.getLength((Object)"notAnArray"));
    }

    @Test
    void testHashCode() {
        long[][] array1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] array2 = new long[][]{{2L, 5L}, {4L, 6L}};
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)array1), (int)ArrayUtils.hashCode((Object)array1));
        Assertions.assertNotEquals((int)ArrayUtils.hashCode((Object)array1), (int)ArrayUtils.hashCode((Object)array2));
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)array3), (int)ArrayUtils.hashCode((Object)array3));
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)array3), (int)ArrayUtils.hashCode((Object)array4));
        Object[] arrayA = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Object[] arrayB = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)arrayB), (int)ArrayUtils.hashCode((Object)arrayA));
    }

    @Test
    void testIndexesOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])null, null));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])new Object[0], (Object)"0"));
        testSet.set(5);
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"0"));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"2"));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"3"));
        testSet.clear();
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, null));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    void testIndexesOfBoolean() {
        boolean[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (boolean)true));
        array = new boolean[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        testSet.set(0);
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false));
    }

    @Test
    void testIndexesOfBooleanWithStartIndex() {
        boolean[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (boolean)true, (int)0));
        array = new boolean[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true, (int)0));
        array = new boolean[]{true, false, true};
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true, (int)1));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false, (int)1));
        array = new boolean[]{true, true};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false, (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false, (int)-1));
    }

    @Test
    void testIndexesOfByte() {
        byte[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)2));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)3));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)99));
    }

    @Test
    void testIndexesOfByteWithStartIndex() {
        byte[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)1, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)2, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)3, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)3, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)99, (int)0));
    }

    @Test
    void testIndexesOfChar() {
        char[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a'));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'b'));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'c'));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'d'));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((char[])array, (char)'e'));
    }

    @Test
    void testIndexesOfCharWithStartIndex() {
        char[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (char)'a', (int)0));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a', (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a', (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a', (int)-1));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'b', (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'c', (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'d', (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((char[])array, (char)'d', (int)5));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((char[])array, (char)'e', (int)0));
    }

    @Test
    void testIndexesOfDouble() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.0));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)3.0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)99.0));
    }

    @Test
    void testIndexesOfDoubleTolerance() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (double)0.3));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)4.15, (double)2.0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    void testIndexesOfDoubleWithStartIndex() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.0, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)3.0, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)3.0, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)99.0, (int)0));
    }

    @Test
    void testIndexesOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0, (int)0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)1, (double)0.3));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)0, (double)0.3));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)0, (double)0.35));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)2, (double)0.35));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)-1, (double)0.35));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)3, (double)0.35));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)4.15, (int)0, (double)2.0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.00001324, (int)0, (double)1.0E-4));
    }

    @Test
    void testIndexesOfFloat() {
        float[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)0.0f));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)1.0f));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)2.0f));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)3.0f));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((float[])array, (float)99.0f));
    }

    @Test
    void testIndexesOfFloatWithStartIndex() {
        float[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)0.0f, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)0.0f, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)1.0f, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)2.0f, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)3.0f, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)3.0f, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((float[])array, (float)99.0f, (int)0));
    }

    @Test
    void testIndexesOfIntWithStartIndex() {
        int[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)1, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)2, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)3, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)3, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((int[])array, (int)99, (int)0));
    }

    @Test
    void testIndexesOfLong() {
        long[] array = new long[]{0L, 1L, 2L, 3L};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])null, (long)0L));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])array, (long)4L));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)0L));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)1L));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)2L));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)3L));
    }

    @Test
    void testIndexesOfLongWithStartIndex() {
        long[] array = new long[]{0L, 1L, 2L, 3L, 2L, 1L, 0L, 1L};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])null, (long)0L, (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])array, (long)4L, (int)0));
        testSet.set(6);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)0L, (int)1));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)0L, (int)0));
        testSet.clear();
        testSet.set(1);
        testSet.set(5);
        testSet.set(7);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)1L, (int)0));
        testSet.clear();
        testSet.set(2);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)2L, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)3L, (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])array, (long)3L, (int)8));
    }

    @Test
    void testIndexesOfShort() {
        short[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)2));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)3));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((short[])array, (short)99));
    }

    @Test
    void testIndexesOfShortWithStartIndex() {
        short[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)1, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)2, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)3, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)3, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((short[])array, (short)99, (int)0));
    }

    @Test
    void testIndexesOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", "2", "3", "1", null, "0"};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(null, null, (int)2));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])new Object[0], (Object)"0", (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(null, (Object)"0", (int)2));
        testSet.set(8);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"0", (int)8));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"0", (int)0));
        testSet.clear();
        testSet.set(6);
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"1", (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"1", (int)9));
        testSet.clear();
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"2", (int)3));
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"2", (int)0));
        testSet.clear();
        testSet.set(3);
        testSet.set(5);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"3", (int)0));
        testSet.clear();
        testSet.set(7);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, null, (int)0));
    }

    @Test
    void testIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0"));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0"));
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((Object[])array, (Object)"0"));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1"));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2"));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3"));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    void testIndexOfBoolean() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (boolean)true));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false));
    }

    @Test
    void testIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
    }

    @Test
    void testIndexOfByte() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((byte[])array, (byte)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((byte[])array, (byte)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((byte[])array, (byte)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)99));
    }

    @Test
    void testIndexOfByteWithStartIndex() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((byte[])array, (byte)0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((byte[])array, (byte)2, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)99, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)0, (int)6));
    }

    @Test
    void testIndexOfChar() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((char[])array, (char)'a'));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((char[])array, (char)'b'));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((char[])array, (char)'c'));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d'));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'e'));
    }

    @Test
    void testIndexOfCharWithStartIndex() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((char[])array, (char)'a', (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'b', (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((char[])array, (char)'c', (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d', (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d', (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'e', (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'a', (int)6));
    }

    @Test
    void testIndexOfDouble() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.0));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.0));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)99.0));
    }

    @Test
    void testIndexOfDoubleNaN() {
        double[] array = new double[]{Double.NEGATIVE_INFINITY, Double.NaN, Double.POSITIVE_INFINITY, Double.NaN};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)Double.NEGATIVE_INFINITY));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)Double.NaN));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)Double.POSITIVE_INFINITY));
    }

    @Test
    void testIndexOfDoubleTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.2, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    void testIndexOfDoubleWithStartIndex() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)1.0, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.0, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)99.0, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)6));
    }

    @Test
    void testIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)0, (double)0.3));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.2, (int)0, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (int)0, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)0, (double)1.0E-4));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (int)-1, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)-300, (double)1.0E-4));
    }

    @Test
    void testIndexOfFloat() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (float)0.0f));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((float[])array, (float)0.0f));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((float[])array, (float)1.0f));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)2.0f));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)99.0f));
    }

    @Test
    void testIndexOfFloatNaN() {
        float[] array = new float[]{Float.NEGATIVE_INFINITY, Float.NaN, Float.POSITIVE_INFINITY, Float.NaN};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((float[])array, (float)Float.NEGATIVE_INFINITY));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((float[])array, (float)Float.NaN));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)Float.POSITIVE_INFINITY));
    }

    @Test
    void testIndexOfFloatWithStartIndex() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)1.0f, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)2.0f, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)99.0f, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)6));
    }

    @Test
    void testIndexOfInt() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((int[])array, (int)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((int[])array, (int)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((int[])array, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)99));
    }

    @Test
    void testIndexOfIntWithStartIndex() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((int[])array, (int)0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((int[])array, (int)2, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)99, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)0, (int)6));
    }

    @Test
    void testIndexOfLong() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((long[])array, (long)0L));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((long[])array, (long)1L));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((long[])array, (long)2L));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)99L));
    }

    @Test
    void testIndexOfLongWithStartIndex() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((long[])array, (long)0L, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)1L, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((long[])array, (long)2L, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)99L, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)0L, (int)6));
    }

    @Test
    void testIndexOfShort() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((short[])array, (short)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((short[])array, (short)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((short[])array, (short)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)99));
    }

    @Test
    void testIndexOfShortWithStartIndex() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((short[])array, (short)0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((short[])array, (short)2, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)99, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)0, (int)6));
    }

    @Test
    void testIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0", (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0", (int)2));
        Assertions.assertEquals((int)5, (int)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1", (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2", (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3", (int)2));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray", (int)2));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, null, (int)8));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)8));
    }

    @Test
    void testIndirectArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType("foo", "bar");
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)"foo", (Object)array[0]);
        Assertions.assertEquals((Object)"bar", (Object)array[1]);
    }

    @Test
    void testIndirectEmptyArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType(new String[0]);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testIsArrayIndexValid() {
        Assertions.assertFalse((boolean)ArrayUtils.isArrayIndexValid(null, (int)0));
        Object[] array = new String[1];
        Assertions.assertFalse((boolean)ArrayUtils.isArrayIndexValid((Object[])array, (int)1));
        Assertions.assertFalse((boolean)ArrayUtils.isArrayIndexValid((Object[])array, (int)-1));
        Assertions.assertTrue((boolean)ArrayUtils.isArrayIndexValid((Object[])array, (int)0));
    }

    @Test
    void testIsEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{"Value"};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((Object[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((Object[])notEmptyArray));
    }

    @Test
    void testIsEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((long[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((long[])emptyLongArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((int[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((int[])emptyIntArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((short[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((short[])emptyShortArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((char[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((char[])emptyCharArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((byte[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((byte[])emptyByteArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((double[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((double[])emptyDoubleArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((float[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((float[])emptyFloatArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((boolean[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((boolean[])emptyBooleanArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((boolean[])notEmptyBooleanArray));
    }

    @Test
    void testIsEquals() {
        long[][] larray1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] larray2 = new long[][]{{2L, 5L}, {4L, 6L}};
        long[] larray3 = new long[]{2L, 5L};
        this.assertIsEquals(larray1, larray2, larray3);
        int[][] iarray1 = new int[][]{{2, 5}, {4, 5}};
        int[][] iarray2 = new int[][]{{2, 5}, {4, 6}};
        int[] iarray3 = new int[]{2, 5};
        this.assertIsEquals(iarray1, iarray2, iarray3);
        short[][] sarray1 = new short[][]{{2, 5}, {4, 5}};
        short[][] sarray2 = new short[][]{{2, 5}, {4, 6}};
        short[] sarray3 = new short[]{2, 5};
        this.assertIsEquals(sarray1, sarray2, sarray3);
        float[][] farray1 = new float[][]{{2.0f, 5.0f}, {4.0f, 5.0f}};
        float[][] farray2 = new float[][]{{2.0f, 5.0f}, {4.0f, 6.0f}};
        float[] farray3 = new float[]{2.0f, 5.0f};
        this.assertIsEquals(farray1, farray2, farray3);
        double[][] darray1 = new double[][]{{2.0, 5.0}, {4.0, 5.0}};
        double[][] darray2 = new double[][]{{2.0, 5.0}, {4.0, 6.0}};
        double[] darray3 = new double[]{2.0, 5.0};
        this.assertIsEquals(darray1, darray2, darray3);
        byte[][] byteArray1 = new byte[][]{{2, 5}, {4, 5}};
        byte[][] byteArray2 = new byte[][]{{2, 5}, {4, 6}};
        byte[] byteArray3 = new byte[]{2, 5};
        this.assertIsEquals(byteArray1, byteArray2, byteArray3);
        char[][] charArray1 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0005'}};
        char[][] charArray2 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0006'}};
        char[] charArray3 = new char[]{'\u0002', '\u0005'};
        this.assertIsEquals(charArray1, charArray2, charArray3);
        boolean[][] barray1 = new boolean[][]{{true, false}, {true, true}};
        boolean[][] barray2 = new boolean[][]{{true, false}, {true, false}};
        boolean[] barray3 = new boolean[]{false, true};
        this.assertIsEquals(barray1, barray2, barray3);
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array4));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals(null, null));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals(null, (Object)array4));
    }

    @Test
    void testIsNotEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{"Value"};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((Object[])notEmptyArray));
    }

    @Test
    void testIsNotEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])emptyLongArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])emptyIntArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])emptyShortArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])emptyCharArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])emptyByteArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])emptyDoubleArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])emptyFloatArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])emptyBooleanArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((boolean[])notEmptyBooleanArray));
    }

    @Test
    void testIsSorted() {
        Comparable[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new Integer[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Comparable[])array));
        array = new Integer[]{1, 2, 3};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Comparable[])array));
        array = new Integer[]{1, 3, 2};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((Comparable[])array));
    }

    @Test
    void testIsSortedBool() {
        boolean[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new boolean[]{true};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((boolean[])array));
        array = new boolean[]{false, true};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((boolean[])array));
        array = new boolean[]{true, false};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((boolean[])array));
    }

    @Test
    void testIsSortedByte() {
        byte[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new byte[]{16};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((byte[])array));
        array = new byte[]{16, 32, 48};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((byte[])array));
        array = new byte[]{16, 48, 32};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((byte[])array));
    }

    @Test
    void testIsSortedChar() {
        char[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new char[]{'a'};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((char[])array));
        array = new char[]{'a', 'b', 'c'};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((char[])array));
        array = new char[]{'a', 'c', 'b'};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((char[])array));
    }

    @Test
    void testIsSortedComparator() {
        Comparator c = Comparator.reverseOrder();
        Object[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array, c));
        array = new Integer[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Object[])array, c));
        array = new Integer[]{3, 2, 1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Object[])array, c));
        array = new Integer[]{1, 3, 2};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((Object[])array, c));
    }

    @Test
    void testIsSortedDouble() {
        double[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new double[]{0.0};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((double[])array));
        array = new double[]{-1.0, 0.0, 0.1, 0.2};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((double[])array));
        array = new double[]{-1.0, 0.2, 0.1, 0.0};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((double[])array));
    }

    @Test
    void testIsSortedFloat() {
        float[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new float[]{0.0f};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((float[])array));
        array = new float[]{-1.0f, 0.0f, 0.1f, 0.2f};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((float[])array));
        array = new float[]{-1.0f, 0.2f, 0.1f, 0.0f};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((float[])array));
    }

    @Test
    void testIsSortedInt() {
        int[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new int[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((int[])array));
        array = new int[]{1, 2, 3};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((int[])array));
        array = new int[]{1, 3, 2};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((int[])array));
    }

    @Test
    void testIsSortedLong() {
        long[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new long[]{0L};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((long[])array));
        array = new long[]{-1L, 0L, 1L};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((long[])array));
        array = new long[]{-1L, 1L, 0L};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((long[])array));
    }

    @Test
    void testIsSortedNullComparator() {
        LangAssertions.assertNullPointerException(() -> ArrayUtils.isSorted(null, null));
    }

    @Test
    void testIsSortedShort() {
        short[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new short[]{0};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((short[])array));
        array = new short[]{-1, 0, 1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((short[])array));
        array = new short[]{-1, 1, 0};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((short[])array));
    }

    @Test
    void testLastIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, (Object)"0"));
        Assertions.assertEquals((int)5, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0"));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"1"));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"2"));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3"));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((Object[])array, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    void testLastIndexOfBoolean() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (boolean)true));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
    }

    @Test
    void testLastIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)1));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
    }

    @Test
    void testLastIndexOfByte() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
    }

    @Test
    void testLastIndexOfByteWithStartIndex() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)2, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)88));
    }

    @Test
    void testLastIndexOfChar() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a'));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'b'));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((char[])array, (char)'c'));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d'));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
    }

    @Test
    void testLastIndexOfCharWithStartIndex() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'b', (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((char[])array, (char)'c', (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)88));
    }

    @Test
    void testLastIndexOfDouble() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.0));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
    }

    @Test
    void testLastIndexOfDoubleTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    void testLastIndexOfDoubleWithStartIndex() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)88));
    }

    @Test
    void testLastIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{3.0};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (int)3, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)array.length, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (int)array.length, (double)1.0E-4));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)-200, (double)2.0));
    }

    @Test
    void testLastIndexOfFloat() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (float)0.0f));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((float[])array, (float)1.0f));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((float[])array, (float)2.0f));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
    }

    @Test
    void testLastIndexOfFloatWithStartIndex() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((float[])array, (float)1.0f, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((float[])array, (float)2.0f, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)88));
    }

    @Test
    void testLastIndexOfInt() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((int[])array, (int)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((int[])array, (int)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((int[])array, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((int[])array, (int)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)99));
    }

    @Test
    void testLastIndexOfIntWithStartIndex() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((int[])array, (int)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((int[])array, (int)2, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)99));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)88));
    }

    @Test
    void testLastIndexOfLong() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((long[])array, (long)1L));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((long[])array, (long)2L));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)99L));
    }

    @Test
    void testLastIndexOfLongWithStartIndex() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((long[])array, (long)1L, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((long[])array, (long)2L, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)99L, (int)4));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)88));
    }

    @Test
    void testLastIndexOfShort() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((short[])array, (short)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((short[])array, (short)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((short[])array, (short)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((short[])array, (short)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)99));
    }

    @Test
    void testLastIndexOfShortWithStartIndex() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((short[])array, (short)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((short[])array, (short)2, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)99));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)88));
    }

    @Test
    void testLastIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, (Object)"0", (int)2));
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"1", (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"2", (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)-1));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)5));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray", (int)5));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)-1));
        Assertions.assertEquals((int)5, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)88));
    }

    @Test
    void testNullToEmptyBoolean() {
        boolean[] original = new boolean[]{true, false};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((boolean[])original));
    }

    @Test
    void testNullToEmptyBooleanEmptyArray() {
        boolean[] empty = new boolean[]{};
        boolean[] result = ArrayUtils.nullToEmpty((boolean[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyBooleanNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.nullToEmpty((boolean[])null));
    }

    @Test
    void testNullToEmptyBooleanObject() {
        Object[] original = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Boolean[])original));
    }

    @Test
    void testNullToEmptyBooleanObjectEmptyArray() {
        Boolean[] empty = new Boolean[]{};
        Object[] result = ArrayUtils.nullToEmpty((Boolean[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyBooleanObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Boolean[])null));
    }

    @Test
    void testNullToEmptyByte() {
        byte[] original = new byte[]{15, 14};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((byte[])original));
    }

    @Test
    void testNullToEmptyByteEmptyArray() {
        byte[] empty = new byte[]{};
        byte[] result = ArrayUtils.nullToEmpty((byte[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyByteNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.nullToEmpty((byte[])null));
    }

    @Test
    void testNullToEmptyByteObject() {
        Object[] original = new Byte[]{(byte)15, (byte)14};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Byte[])original));
    }

    @Test
    void testNullToEmptyByteObjectEmptyArray() {
        Byte[] empty = new Byte[]{};
        Object[] result = ArrayUtils.nullToEmpty((Byte[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyByteObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Byte[])null));
    }

    @Test
    void testNullToEmptyChar() {
        char[] original = new char[]{'a', 'b'};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((char[])original));
    }

    @Test
    void testNullToEmptyCharEmptyArray() {
        char[] empty = new char[]{};
        char[] result = ArrayUtils.nullToEmpty((char[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyCharNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.nullToEmpty((char[])null));
    }

    @Test
    void testNullToEmptyCharObject() {
        Object[] original = new Character[]{Character.valueOf('a'), Character.valueOf('b')};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Character[])original));
    }

    @Test
    void testNullToEmptyCharObjectEmptyArray() {
        Character[] empty = new Character[]{};
        Object[] result = ArrayUtils.nullToEmpty((Character[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNUllToEmptyCharObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Character[])null));
    }

    @Test
    void testNullToEmptyClass() {
        Object[] original = new Class[]{Object.class, String.class};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Class[])original));
    }

    @Test
    void testNullToEmptyClassEmptyArray() {
        Class[] empty = new Class[]{};
        Object[] result = ArrayUtils.nullToEmpty((Class[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyClassNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ArrayUtils.nullToEmpty((Class[])null));
    }

    @Test
    void testNullToEmptyDouble() {
        double[] original = new double[]{1.0, 2.0};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((double[])original));
    }

    @Test
    void testNullToEmptyDoubleEmptyArray() {
        double[] empty = new double[]{};
        double[] result = ArrayUtils.nullToEmpty((double[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyDoubleNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.nullToEmpty((double[])null));
    }

    @Test
    void testNullToEmptyDoubleObject() {
        Object[] original = new Double[]{1.0, 2.0};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Double[])original));
    }

    @Test
    void testNullToEmptyDoubleObjectEmptyArray() {
        Double[] empty = new Double[]{};
        Object[] result = ArrayUtils.nullToEmpty((Double[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyDoubleObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Double[])null));
    }

    @Test
    void testNullToEmptyFloat() {
        float[] original = new float[]{2.6f, 3.8f};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((float[])original));
    }

    @Test
    void testNullToEmptyFloatEmptyArray() {
        float[] empty = new float[]{};
        float[] result = ArrayUtils.nullToEmpty((float[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyFloatNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.nullToEmpty((float[])null));
    }

    @Test
    void testNullToEmptyFloatObject() {
        Object[] original = new Float[]{Float.valueOf(2.6f), Float.valueOf(3.8f)};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Float[])original));
    }

    @Test
    void testNullToEmptyFloatObjectEmptyArray() {
        Float[] empty = new Float[]{};
        Object[] result = ArrayUtils.nullToEmpty((Float[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyFloatObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Float[])null));
    }

    @Test
    void testNullToEmptyGeneric() {
        Object[] input = new TestClass[]{new TestClass(), new TestClass()};
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, TestClass[].class);
        Assertions.assertSame((Object)input, (Object)output);
    }

    @Test
    void testNullToEmptyGenericEmpty() {
        Object[] input = new TestClass[]{};
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, TestClass[].class);
        Assertions.assertSame((Object)input, (Object)output);
    }

    @Test
    void testNullToEmptyGenericNull() {
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty(null, TestClass[].class);
        Assertions.assertNotNull((Object)output);
        Assertions.assertEquals((int)0, (int)output.length);
    }

    @Test
    void testNullToEmptyGenericNullType() {
        TestClass[] input = new TestClass[]{};
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.nullToEmpty((Object[])input, null));
    }

    @Test
    void testNullToEmptyInt() {
        int[] original = new int[]{1, 2};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((int[])original));
    }

    @Test
    void testNullToEmptyIntEmptyArray() {
        int[] empty = new int[]{};
        int[] result = ArrayUtils.nullToEmpty((int[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyIntNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.nullToEmpty((int[])null));
    }

    @Test
    void testNullToEmptyIntObject() {
        Object[] original = new Integer[]{1, 2};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Integer[])original));
    }

    @Test
    void testNullToEmptyIntObjectEmptyArray() {
        Integer[] empty = new Integer[]{};
        Object[] result = ArrayUtils.nullToEmpty((Integer[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyIntObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Integer[])null));
    }

    @Test
    void testNullToEmptyLong() {
        long[] original = new long[]{1L, 2L};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((long[])original));
    }

    @Test
    void testNullToEmptyLongEmptyArray() {
        long[] empty = new long[]{};
        long[] result = ArrayUtils.nullToEmpty((long[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyLongNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.nullToEmpty((long[])null));
    }

    @Test
    void testNullToEmptyLongObject() {
        Object[] original = new Long[]{1L, 2L};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Long[])original));
    }

    @Test
    void testNullToEmptyLongObjectEmptyArray() {
        Long[] empty = new Long[]{};
        Object[] result = ArrayUtils.nullToEmpty((Long[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyLongObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Long[])null));
    }

    @Test
    void testNullToEmptyObject() {
        Object[] original = new Object[]{Boolean.TRUE, Boolean.FALSE};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Object[])original));
    }

    @Test
    void testNullToEmptyObjectEmptyArray() {
        Object[] empty = new Object[]{};
        Object[] result = ArrayUtils.nullToEmpty((Object[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Object[])null));
    }

    @Test
    void testNullToEmptyShort() {
        short[] original = new short[]{1, 2};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((short[])original));
    }

    @Test
    void testNullToEmptyShortEmptyArray() {
        short[] empty = new short[]{};
        short[] result = ArrayUtils.nullToEmpty((short[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyShortNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.nullToEmpty((short[])null));
    }

    @Test
    void testNullToEmptyShortObject() {
        Object[] original = new Short[]{(short)1, (short)2};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Short[])original));
    }

    @Test
    void testNullToEmptyShortObjectEmptyArray() {
        Short[] empty = new Short[]{};
        Object[] result = ArrayUtils.nullToEmpty((Short[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyShortObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Short[])null));
    }

    @Test
    void testNullToEmptyString() {
        Object[] original = new String[]{"abc", "def"};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((String[])original));
    }

    @Test
    void testNullToEmptyStringEmptyArray() {
        String[] empty = new String[]{};
        Object[] result = ArrayUtils.nullToEmpty((String[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    void testNullToEmptyStringNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.nullToEmpty((String[])null));
    }

    @Test
    void testNullToShortObject() {
        Object[] original = new Short[]{(short)1, (short)2};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullTo((Object[])original, (Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY));
    }

    @Test
    void testReverse() {
        StringBuffer str1 = new StringBuffer("pick");
        String str2 = "a";
        String[] str3 = new String[]{"stick"};
        String str4 = "up";
        Object[] array = new Object[]{str1, "a", str3};
        ArrayUtils.reverse((Object[])array);
        Assertions.assertEquals((Object)array[0], (Object)str3);
        Assertions.assertEquals((Object)array[1], (Object)"a");
        Assertions.assertEquals((Object)array[2], (Object)str1);
        array = new Object[]{str1, "a", str3, "up"};
        ArrayUtils.reverse((Object[])array);
        Assertions.assertEquals((Object)array[0], (Object)"up");
        Assertions.assertEquals((Object)array[1], (Object)str3);
        Assertions.assertEquals((Object)array[2], (Object)"a");
        Assertions.assertEquals((Object)array[3], (Object)str1);
        array = null;
        ArrayUtils.reverse((Object[])array);
        Assertions.assertArrayEquals(null, (Object[])array);
    }

    @Test
    void testReverseBoolean() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = null;
        ArrayUtils.reverse((boolean[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseBooleanRange() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)0, (int)3);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)0, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)-1, (int)3);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = null;
        ArrayUtils.reverse((boolean[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseByte() {
        byte[] array = new byte[]{2, 3, 4};
        ArrayUtils.reverse((byte[])array);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        array = null;
        ArrayUtils.reverse((byte[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseByteRange() {
        byte[] array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((byte[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseChar() {
        char[] array = new char[]{'a', 'f', 'C'};
        ArrayUtils.reverse((char[])array);
        Assertions.assertEquals((char)'C', (char)array[0]);
        Assertions.assertEquals((char)'f', (char)array[1]);
        Assertions.assertEquals((char)'a', (char)array[2]);
        array = null;
        ArrayUtils.reverse((char[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseCharRange() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((char[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseDouble() {
        double[] array = new double[]{0.3, 0.4, 0.5};
        ArrayUtils.reverse((double[])array);
        Assertions.assertEquals((double)0.5, (double)array[0]);
        Assertions.assertEquals((double)0.4, (double)array[1]);
        Assertions.assertEquals((double)0.3, (double)array[2]);
        array = null;
        ArrayUtils.reverse((double[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseDoubleRange() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)0, (int)3);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)0, (int)2);
        Assertions.assertEquals((double)2.0, (double)array[0]);
        Assertions.assertEquals((double)1.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)-1, (int)3);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = null;
        ArrayUtils.reverse((double[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseFloat() {
        float[] array = new float[]{0.3f, 0.4f, 0.5f};
        ArrayUtils.reverse((float[])array);
        Assertions.assertEquals((float)0.5f, (float)array[0]);
        Assertions.assertEquals((float)0.4f, (float)array[1]);
        Assertions.assertEquals((float)0.3f, (float)array[2]);
        array = null;
        ArrayUtils.reverse((float[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseFloatRange() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)0, (int)3);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)0, (int)2);
        Assertions.assertEquals((float)2.0f, (float)array[0]);
        Assertions.assertEquals((float)1.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)-1, (int)3);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = null;
        ArrayUtils.reverse((float[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((int[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseIntRange() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((int[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((long[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseLongRange() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)0, (int)3);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)0, (int)2);
        Assertions.assertEquals((long)2L, (long)array[0]);
        Assertions.assertEquals((long)1L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)-1, (int)3);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((long[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseObjectRange() {
        Object[] array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)0, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)0, (int)2);
        Assertions.assertEquals((Object)"2", (Object)array[0]);
        Assertions.assertEquals((Object)"1", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)-1, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        array = null;
        ArrayUtils.reverse((Object[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((short[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testReverseShortRange() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((short[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testSameLength() {
        Object[] nullArray = null;
        Object[] emptyArray = new Object[]{};
        Object[] oneArray = new Object[]{"pick"};
        Object[] twoArray = new Object[]{"pick", "stick"};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (Object[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (Object[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])twoArray));
    }

    @Test
    void testSameLengthAll() {
        Object[] nullArrayObject = null;
        Object[] emptyArrayObject = new Object[]{};
        Object[] oneArrayObject = new Object[]{"pick"};
        Object[] twoArrayObject = new Object[]{"pick", "stick"};
        boolean[] nullArrayBoolean = null;
        boolean[] emptyArrayBoolean = new boolean[]{};
        boolean[] oneArrayBoolean = new boolean[]{true};
        boolean[] twoArrayBoolean = new boolean[]{true, false};
        long[] nullArrayLong = null;
        long[] emptyArrayLong = new long[]{};
        long[] oneArrayLong = new long[]{0L};
        long[] twoArrayLong = new long[]{0L, 76L};
        int[] nullArrayInt = null;
        int[] emptyArrayInt = new int[]{};
        int[] oneArrayInt = new int[]{4};
        int[] twoArrayInt = new int[]{5, 7};
        short[] nullArrayShort = null;
        short[] emptyArrayShort = new short[]{};
        short[] oneArrayShort = new short[]{4};
        short[] twoArrayShort = new short[]{6, 8};
        char[] nullArrayChar = null;
        char[] emptyArrayChar = new char[]{};
        char[] oneArrayChar = new char[]{'f'};
        char[] twoArrayChar = new char[]{'d', 't'};
        byte[] nullArrayByte = null;
        byte[] emptyArrayByte = new byte[]{};
        byte[] oneArrayByte = new byte[]{3};
        byte[] twoArrayByte = new byte[]{4, 6};
        double[] nullArrayDouble = null;
        double[] emptyArrayDouble = new double[]{};
        double[] oneArrayDouble = new double[]{1.3};
        double[] twoArrayDouble = new double[]{4.5, 6.3};
        float[] nullArrayFloat = null;
        float[] emptyArrayFloat = new float[]{};
        float[] oneArrayFloat = new float[]{2.5f};
        float[] twoArrayFloat = new float[]{6.4f, 5.8f};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object[])emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (long[])emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (int[])emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (short[])emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (char[])emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (byte[])emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object[])oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (long[])oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (int[])oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (short[])oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (char[])oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (byte[])oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (double[])oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (float[])oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object[])twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (long[])twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (int[])twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (short[])twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (char[])twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (byte[])twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (double[])twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (float[])twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, (Object[])emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, (long[])emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, (int[])emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, (short[])emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, (char[])emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, (byte[])emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, (Object[])oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, (long[])oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, (int[])oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, (short[])oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, (char[])oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, (byte[])oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, (double[])oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, (float[])oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, (Object[])twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, (long[])twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, (int[])twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, (short[])twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, (char[])twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, (byte[])twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, (double[])twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, (float[])twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, (Object[])emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, (long[])emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, (int[])emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, (short[])emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, (char[])emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, (byte[])emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, (Object[])oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, (long[])oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, (int[])oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, (short[])oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, (char[])oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, (byte[])oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, (double[])oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, (float[])oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, (Object[])twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, (long[])twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, (int[])twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, (short[])twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, (char[])twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, (byte[])twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, (double[])twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, (float[])twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, (Object[])emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, (long[])emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, (int[])emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, (short[])emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, (char[])emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, (byte[])emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, (Object[])oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, (long[])oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, (int[])oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, (short[])oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, (char[])oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, (byte[])oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, (double[])oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, (float[])oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, (Object[])twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, (long[])twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, (int[])twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, (short[])twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, (char[])twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, (byte[])twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, (double[])twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, (float[])twoArrayFloat));
    }

    @Test
    void testSameLengthBoolean() {
        boolean[] nullArray = null;
        boolean[] emptyArray = new boolean[]{};
        boolean[] oneArray = new boolean[]{true};
        boolean[] twoArray = new boolean[]{true, false};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])twoArray));
    }

    @Test
    void testSameLengthByte() {
        byte[] nullArray = null;
        byte[] emptyArray = new byte[]{};
        byte[] oneArray = new byte[]{3};
        byte[] twoArray = new byte[]{4, 6};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (byte[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (byte[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (byte[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])twoArray));
    }

    @Test
    void testSameLengthChar() {
        char[] nullArray = null;
        char[] emptyArray = new char[]{};
        char[] oneArray = new char[]{'f'};
        char[] twoArray = new char[]{'d', 't'};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (char[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (char[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (char[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])twoArray));
    }

    @Test
    void testSameLengthDouble() {
        double[] nullArray = null;
        double[] emptyArray = new double[]{};
        double[] oneArray = new double[]{1.3};
        double[] twoArray = new double[]{4.5, 6.3};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (double[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (double[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (double[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])twoArray));
    }

    @Test
    void testSameLengthFloat() {
        float[] nullArray = null;
        float[] emptyArray = new float[]{};
        float[] oneArray = new float[]{2.5f};
        float[] twoArray = new float[]{6.4f, 5.8f};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (float[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (float[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (float[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])twoArray));
    }

    @Test
    void testSameLengthInt() {
        int[] nullArray = null;
        int[] emptyArray = new int[]{};
        int[] oneArray = new int[]{4};
        int[] twoArray = new int[]{5, 7};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (int[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (int[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (int[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])twoArray));
    }

    @Test
    void testSameLengthLong() {
        long[] nullArray = null;
        long[] emptyArray = new long[]{};
        long[] oneArray = new long[]{0L};
        long[] twoArray = new long[]{0L, 76L};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (long[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (long[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (long[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])twoArray));
    }

    @Test
    void testSameLengthShort() {
        short[] nullArray = null;
        short[] emptyArray = new short[]{};
        short[] oneArray = new short[]{4};
        short[] twoArray = new short[]{6, 8};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (short[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (short[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (short[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])twoArray));
    }

    @Test
    void testSameType() {
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.isSameType(null, null));
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.isSameType(null, (Object)new Object[0]));
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.isSameType((Object)new Object[0], null));
        Assertions.assertTrue((boolean)ArrayUtils.isSameType((Object)new Object[0], (Object)new Object[0]));
        Assertions.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new Object[0]));
        Assertions.assertTrue((boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0][0]));
        Assertions.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new String[0][0]));
        Assertions.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0]));
    }

    @Test
    void testShiftAllByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftAllChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftAllDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)4);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)-4);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
    }

    @Test
    void testShiftAllFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)4);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)-4);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
    }

    @Test
    void testShiftAllInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftAllLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)4);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-4);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    void testShiftAllObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)4);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-4);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
    }

    @Test
    void testShiftAllShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftBoolean() {
        ArrayUtils.shift((boolean[])new boolean[0], (int)1);
        boolean[] array = new boolean[]{true, true, false, false};
        ArrayUtils.shift((boolean[])array, (int)1);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)-1);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)5);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)-3);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        Assertions.assertTrue((boolean)array[3]);
    }

    @Test
    void testShiftBooleanArrayNull() {
        boolean[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftByte() {
        ArrayUtils.shift((byte[])null, (int)1);
        ArrayUtils.shift((byte[])new byte[0], (int)1);
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
    }

    @Test
    void testShiftChar() {
        ArrayUtils.shift((char[])null, (int)1);
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
    }

    @Test
    void testShiftDouble() {
        ArrayUtils.shift((double[])null, (int)1);
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)1);
        Assertions.assertEquals((double)4.0, (double)array[0]);
        Assertions.assertEquals((double)1.0, (double)array[1]);
        Assertions.assertEquals((double)2.0, (double)array[2]);
        Assertions.assertEquals((double)3.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)-1);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)5);
        Assertions.assertEquals((double)4.0, (double)array[0]);
        Assertions.assertEquals((double)1.0, (double)array[1]);
        Assertions.assertEquals((double)2.0, (double)array[2]);
        Assertions.assertEquals((double)3.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)-3);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)4.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        Assertions.assertEquals((double)2.0, (double)array[3]);
    }

    @Test
    void testShiftDoubleArrayNull() {
        double[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftFloat() {
        ArrayUtils.shift((float[])null, (int)1);
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)1);
        Assertions.assertEquals((float)4.0f, (float)array[0]);
        Assertions.assertEquals((float)1.0f, (float)array[1]);
        Assertions.assertEquals((float)2.0f, (float)array[2]);
        Assertions.assertEquals((float)3.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)-1);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)5);
        Assertions.assertEquals((float)4.0f, (float)array[0]);
        Assertions.assertEquals((float)1.0f, (float)array[1]);
        Assertions.assertEquals((float)2.0f, (float)array[2]);
        Assertions.assertEquals((float)3.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)-3);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)4.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        Assertions.assertEquals((float)2.0f, (float)array[3]);
    }

    @Test
    void testShiftFloatArrayNull() {
        float[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftInt() {
        ArrayUtils.shift((int[])null, (int)1);
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
    }

    @Test
    void testShiftIntArrayNull() {
        int[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftLong() {
        ArrayUtils.shift((long[])null, (int)1);
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)1);
        Assertions.assertEquals((long)4L, (long)array[0]);
        Assertions.assertEquals((long)1L, (long)array[1]);
        Assertions.assertEquals((long)2L, (long)array[2]);
        Assertions.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-1);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)5);
        Assertions.assertEquals((long)4L, (long)array[0]);
        Assertions.assertEquals((long)1L, (long)array[1]);
        Assertions.assertEquals((long)2L, (long)array[2]);
        Assertions.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-3);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)4L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        Assertions.assertEquals((long)2L, (long)array[3]);
    }

    @Test
    void testShiftLongArrayNull() {
        long[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftObject() {
        ArrayUtils.shift((Object[])null, (int)1);
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)1);
        Assertions.assertEquals((Object)"4", (Object)array[0]);
        Assertions.assertEquals((Object)"1", (Object)array[1]);
        Assertions.assertEquals((Object)"2", (Object)array[2]);
        Assertions.assertEquals((Object)"3", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-1);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)5);
        Assertions.assertEquals((Object)"4", (Object)array[0]);
        Assertions.assertEquals((Object)"1", (Object)array[1]);
        Assertions.assertEquals((Object)"2", (Object)array[2]);
        Assertions.assertEquals((Object)"3", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
    }

    @Test
    void testShiftObjectArrayNull() {
        Object[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeBoolean() {
        ArrayUtils.shift((boolean[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((boolean[])new boolean[0], (int)100, (int)0, (int)0);
        boolean[] array1 = new boolean[]{true};
        ArrayUtils.shift((boolean[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array1);
        boolean[] array2 = new boolean[]{true, false, true};
        ArrayUtils.shift((boolean[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true}, (boolean[])array2);
        boolean[] array = new boolean[]{true, false, false, false, true};
        ArrayUtils.shift((boolean[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((Object)true, (Object)array[0]);
        Assertions.assertEquals((Object)false, (Object)array[1]);
        Assertions.assertEquals((Object)false, (Object)array[2]);
        Assertions.assertEquals((Object)false, (Object)array[3]);
        Assertions.assertEquals((Object)true, (Object)array[4]);
        ArrayUtils.shift((boolean[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((Object)true, (Object)array[0]);
        Assertions.assertEquals((Object)false, (Object)array[1]);
        Assertions.assertEquals((Object)false, (Object)array[2]);
        Assertions.assertEquals((Object)false, (Object)array[3]);
        Assertions.assertEquals((Object)true, (Object)array[4]);
    }

    @Test
    void testShiftRangeByte() {
        ArrayUtils.shift((byte[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((byte[])new byte[0], (int)100, (int)0, (int)0);
        byte[] array1 = new byte[]{1};
        ArrayUtils.shift((byte[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array1);
        byte[] array2 = new byte[]{1, 0, 1};
        ArrayUtils.shift((byte[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 1}, (byte[])array2);
        byte[] array = new byte[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((byte[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((byte[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    void testShiftRangeChar() {
        ArrayUtils.shift((char[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((char[])new char[0], (int)100, (int)0, (int)0);
        char[] array1 = new char[]{'\u0001'};
        ArrayUtils.shift((char[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'\u0001'}, (char[])array1);
        char[] array2 = new char[]{'\u0001', '\u0000', '\u0001'};
        ArrayUtils.shift((char[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'\u0001', '\u0000', '\u0001'}, (char[])array2);
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005'};
        ArrayUtils.shift((char[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((char[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    void testShiftRangeDouble() {
        ArrayUtils.shift((double[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((double[])new double[0], (int)100, (int)0, (int)0);
        double[] array1 = new double[]{1.0};
        ArrayUtils.shift((double[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array1);
        double[] array2 = new double[]{1.0, 0.0, 1.0};
        ArrayUtils.shift((double[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 0.0, 1.0}, (double[])array2);
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        ArrayUtils.shift((double[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)3.0, (double)array[1]);
        Assertions.assertEquals((double)2.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
        Assertions.assertEquals((double)5.0, (double)array[4]);
        ArrayUtils.shift((double[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)4.0, (double)array[2]);
        Assertions.assertEquals((double)3.0, (double)array[3]);
        Assertions.assertEquals((double)5.0, (double)array[4]);
    }

    @Test
    void testShiftRangeFloat() {
        ArrayUtils.shift((float[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((float[])new float[0], (int)100, (int)0, (int)0);
        float[] array1 = new float[]{1.0f};
        ArrayUtils.shift((float[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array1);
        float[] array2 = new float[]{1.0f, 0.0f, 1.0f};
        ArrayUtils.shift((float[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 0.0f, 1.0f}, (float[])array2);
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        ArrayUtils.shift((float[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)3.0f, (float)array[1]);
        Assertions.assertEquals((float)2.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
        Assertions.assertEquals((float)5.0f, (float)array[4]);
        ArrayUtils.shift((float[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)4.0f, (float)array[2]);
        Assertions.assertEquals((float)3.0f, (float)array[3]);
        Assertions.assertEquals((float)5.0f, (float)array[4]);
    }

    @Test
    void testShiftRangeInt() {
        ArrayUtils.shift((int[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((int[])new int[0], (int)100, (int)0, (int)0);
        int[] array1 = new int[]{1};
        ArrayUtils.shift((int[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array1);
        int[] array2 = new int[]{1, 0, 1};
        ArrayUtils.shift((int[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{1, 0, 1}, (int[])array2);
        int[] array = new int[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((int[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((int[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    void testShiftRangeLong() {
        ArrayUtils.shift((long[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((long[])new long[0], (int)100, (int)0, (int)0);
        long[] array1 = new long[]{1L};
        ArrayUtils.shift((long[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array1);
        long[] array2 = new long[]{1L, 0L, 1L};
        ArrayUtils.shift((long[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((long[])new long[]{1L, 0L, 1L}, (long[])array2);
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        ArrayUtils.shift((long[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)3L, (long)array[1]);
        Assertions.assertEquals((long)2L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
        Assertions.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((long[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)4L, (long)array[2]);
        Assertions.assertEquals((long)3L, (long)array[3]);
        Assertions.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    void testShiftRangeNoElemByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftRangeNoElemChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftRangeNoElemDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
    }

    @Test
    void testShiftRangeNoElemFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
    }

    @Test
    void testShiftRangeNoElemInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftRangeNoElemLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    void testShiftRangeNoElemObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
    }

    @Test
    void testShiftRangeNoElemShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    void testShiftRangeNullByte() {
        byte[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullChar() {
        char[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullDouble() {
        double[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullFloat() {
        float[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullInt() {
        int[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullLong() {
        long[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullObject() {
        Object[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeNullShort() {
        short[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShiftRangeObject() {
        Object[] array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.shift((Object[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"3", (Object)array[1]);
        Assertions.assertEquals((Object)"2", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
        Assertions.assertEquals((Object)"5", (Object)array[4]);
        ArrayUtils.shift((Object[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"4", (Object)array[2]);
        Assertions.assertEquals((Object)"3", (Object)array[3]);
        Assertions.assertEquals((Object)"5", (Object)array[4]);
    }

    @Test
    void testShiftRangeShort() {
        ArrayUtils.shift((short[])null, (int)0, (int)0, (int)0);
        ArrayUtils.shift((short[])new short[0], (int)100, (int)0, (int)0);
        short[] array1 = new short[]{1};
        ArrayUtils.shift((short[])array1, (int)-1, (int)0, (int)0);
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array1);
        short[] array2 = new short[]{1, 0, 1};
        ArrayUtils.shift((short[])array2, (int)1, (int)1, (int)0);
        Assertions.assertArrayEquals((short[])new short[]{1, 0, 1}, (short[])array2);
        short[] array = new short[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((short[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((short[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    void testShiftShort() {
        ArrayUtils.shift((short[])null, (int)1);
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new short[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((short[])array, (int)2);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)5, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        Assertions.assertEquals((int)3, (int)array[4]);
    }

    @Test
    void testShiftShortArrayNull() {
        short[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    void testShuffleBoolean() {
        boolean[] array1 = new boolean[]{true, false, true, true, false, false, true, false, false, true, true, false, true, true, false, false, true, false, false, true, true, false, true, true, false, false, true, false, false, true, false, true, true, false, true, true, false, false, true, false, false, false, true, true, false, false, true, false, false, true, false, true, true, false, true, true, false, false, true, false};
        boolean[] array2 = ArrayUtils.clone((boolean[])array1);
        ArrayUtils.shuffle((boolean[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
    }

    @Test
    void testShuffleBooleanRandom() {
        boolean[] array1 = new boolean[]{true, false, true, true, false, false, true, false, false, true, true, false, true, true, false, false, true, false, false, true, true, false, true, true, false, false, true, false, false, true, false, true, true, false, true, true, false, false, true, false, false, false, true, true, false, false, true, false, false, true, false, true, true, false, true, true, false, false, true, false};
        boolean[] array2 = ArrayUtils.clone((boolean[])array1);
        ArrayUtils.shuffle((boolean[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
    }

    @Test
    void testShuffleByte() {
        byte[] array1 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] array2 = ArrayUtils.clone((byte[])array1);
        ArrayUtils.shuffle((byte[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (byte element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array1, (byte)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleByteRandom() {
        byte[] array1 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] array2 = ArrayUtils.clone((byte[])array1);
        ArrayUtils.shuffle((byte[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (byte element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array1, (byte)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleChar() {
        char[] array1 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'};
        char[] array2 = ArrayUtils.clone((char[])array1);
        ArrayUtils.shuffle((char[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (char element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array1, (char)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleCharRandom() {
        char[] array1 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'};
        char[] array2 = ArrayUtils.clone((char[])array1);
        ArrayUtils.shuffle((char[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (char element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array1, (char)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleDouble() {
        double[] array1 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        double[] array2 = ArrayUtils.clone((double[])array1);
        ArrayUtils.shuffle((double[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (double element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array1, (double)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleDoubleRandom() {
        double[] array1 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        double[] array2 = ArrayUtils.clone((double[])array1);
        ArrayUtils.shuffle((double[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (double element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array1, (double)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleFloat() {
        float[] array1 = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        float[] array2 = ArrayUtils.clone((float[])array1);
        ArrayUtils.shuffle((float[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (float element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array1, (float)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleFloatRandom() {
        float[] array1 = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        float[] array2 = ArrayUtils.clone((float[])array1);
        ArrayUtils.shuffle((float[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (float element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array1, (float)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleInt() {
        int[] array1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] array2 = ArrayUtils.clone((int[])array1);
        ArrayUtils.shuffle((int[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (int element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array1, (int)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleIntRandom() {
        int[] array1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] array2 = ArrayUtils.clone((int[])array1);
        ArrayUtils.shuffle((int[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (int element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array1, (int)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleLong() {
        long[] array1 = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L};
        long[] array2 = ArrayUtils.clone((long[])array1);
        ArrayUtils.shuffle((long[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (long element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array1, (long)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleLongRandom() {
        long[] array1 = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L};
        long[] array2 = ArrayUtils.clone((long[])array1);
        ArrayUtils.shuffle((long[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (long element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array1, (long)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleShort() {
        short[] array1 = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        short[] array2 = ArrayUtils.clone((short[])array1);
        ArrayUtils.shuffle((short[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (short element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array1, (short)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleShortRandom() {
        short[] array1 = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        short[] array2 = ArrayUtils.clone((short[])array1);
        ArrayUtils.shuffle((short[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (short element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array1, (short)element), () -> "Element " + element + " not found");
        }
    }

    @Test
    void testShuffleString() {
        Object[] array1 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        Object[] array2 = (String[])ArrayUtils.clone((Object[])array1);
        ArrayUtils.shuffle((Object[])array1);
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (Object element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array1, (Object)element), () -> ArrayUtilsTest.lambda$testShuffleString$29((String)element));
        }
    }

    @Test
    void testShuffleStringRandom() {
        Object[] array1 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        Object[] array2 = (String[])ArrayUtils.clone((Object[])array1);
        ArrayUtils.shuffle((Object[])array1, (Random)ArrayUtilsTest.seededRandom());
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (Object element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array1, (Object)element), () -> ArrayUtilsTest.lambda$testShuffleStringRandom$30((String)element));
        }
    }

    @Test
    void testStartsWith() {
        Assertions.assertTrue((boolean)ArrayUtils.startsWith(null, null));
        Assertions.assertFalse((boolean)ArrayUtils.startsWith((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, null));
        Assertions.assertFalse((boolean)ArrayUtils.startsWith(null, (byte[])ArrayUtils.EMPTY_BYTE_ARRAY));
        Assertions.assertTrue((boolean)ArrayUtils.startsWith((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.EMPTY_BYTE_ARRAY));
        Assertions.assertTrue((boolean)ArrayUtils.startsWith((byte[])new byte[0], (byte[])new byte[0]));
        Assertions.assertTrue((boolean)ArrayUtils.startsWith((byte[])new byte[10], (byte[])new byte[10]));
        Assertions.assertTrue((boolean)ArrayUtils.startsWith((byte[])new byte[10], (byte[])new byte[9]));
        Assertions.assertTrue((boolean)ArrayUtils.startsWith((byte[])new byte[10], (byte[])new byte[1]));
        byte[] sig = "Signature".getBytes(StandardCharsets.US_ASCII);
        byte[] data = new byte[1024];
        Assertions.assertFalse((boolean)ArrayUtils.startsWith((byte[])data, (byte[])sig));
        System.arraycopy(sig, 0, data, 0, sig.length - 1);
        Assertions.assertFalse((boolean)ArrayUtils.startsWith((byte[])data, (byte[])sig));
        System.arraycopy(sig, 0, data, 0, sig.length);
        data[0] = 0;
        Assertions.assertFalse((boolean)ArrayUtils.startsWith((byte[])data, (byte[])sig));
        System.arraycopy(sig, 0, data, 0, sig.length);
        Assertions.assertTrue((boolean)ArrayUtils.startsWith((byte[])data, (byte[])sig));
        Assertions.assertFalse((boolean)ArrayUtils.startsWith((byte[])new byte[1], (byte[])new byte[2]));
    }

    @Test
    void testSubarrayBoolean() {
        boolean[] nullArray = null;
        boolean[] array = new boolean[]{true, true, false, true, false, true};
        boolean[] leftSubarray = new boolean[]{true, true, false, true};
        boolean[] midSubarray = new boolean[]{true, false, true, false};
        boolean[] rightSubarray = new boolean[]{false, true, false, true};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Boolean.TYPE, ArrayUtils.subarray((boolean[])array, (int)2, (int)4).getClass().getComponentType(), (String)"boolean type");
    }

    @Test
    void testSubarrayByte() {
        byte[] nullArray = null;
        byte[] array = new byte[]{10, 11, 12, 13, 14, 15};
        byte[] leftSubarray = new byte[]{10, 11, 12, 13};
        byte[] midSubarray = new byte[]{11, 12, 13, 14};
        byte[] rightSubarray = new byte[]{12, 13, 14, 15};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Byte.TYPE, ArrayUtils.subarray((byte[])array, (int)2, (int)4).getClass().getComponentType(), (String)"byte type");
    }

    @Test
    void testSubarrayDouble() {
        double[] nullArray = null;
        double[] array = new double[]{10.123, 11.234, 12.345, 13.456, 14.567, 15.678};
        double[] leftSubarray = new double[]{10.123, 11.234, 12.345, 13.456};
        double[] midSubarray = new double[]{11.234, 12.345, 13.456, 14.567};
        double[] rightSubarray = new double[]{12.345, 13.456, 14.567, 15.678};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((double[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Double.TYPE, ArrayUtils.subarray((double[])array, (int)2, (int)4).getClass().getComponentType(), (String)"double type");
    }

    @Test
    void testSubarrayFloat() {
        float[] nullArray = null;
        float[] array = new float[]{10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f};
        float[] leftSubarray = new float[]{10.0f, 11.0f, 12.0f, 13.0f};
        float[] midSubarray = new float[]{11.0f, 12.0f, 13.0f, 14.0f};
        float[] rightSubarray = new float[]{12.0f, 13.0f, 14.0f, 15.0f};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((float[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Float.TYPE, ArrayUtils.subarray((float[])array, (int)2, (int)4).getClass().getComponentType(), (String)"float type");
    }

    @Test
    void testSubarrayInt() {
        int[] nullArray = null;
        int[] array = new int[]{10, 11, 12, 13, 14, 15};
        int[] leftSubarray = new int[]{10, 11, 12, 13};
        int[] midSubarray = new int[]{11, 12, 13, 14};
        int[] rightSubarray = new int[]{12, 13, 14, 15};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((int[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Integer.TYPE, ArrayUtils.subarray((int[])array, (int)2, (int)4).getClass().getComponentType(), (String)"int type");
    }

    @Test
    void testSubarrayLong() {
        long[] nullArray = null;
        long[] array = new long[]{999910L, 999911L, 999912L, 999913L, 999914L, 999915L};
        long[] leftSubarray = new long[]{999910L, 999911L, 999912L, 999913L};
        long[] midSubarray = new long[]{999911L, 999912L, 999913L, 999914L};
        long[] rightSubarray = new long[]{999912L, 999913L, 999914L, 999915L};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((long[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Long.TYPE, ArrayUtils.subarray((long[])array, (int)2, (int)4).getClass().getComponentType(), (String)"long type");
    }

    @Test
    void testSubarrayObject() {
        Object[] nullArray = null;
        Object[] objectArray = new Object[]{"a", "b", "c", "d", "e", "f"};
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertEquals((Object)"abcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)objectArray.length)), (String)"0 start, length end");
        Assertions.assertEquals((Object)"bcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)4)), (String)"mid start, mid end");
        Assertions.assertEquals((Object)"bcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)objectArray.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (int)1, (int)2)), (String)"empty array");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)4, (int)2)), (String)"start > end");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)3, (int)3)), (String)"start == end");
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)33, (int)4)), (String)"start overshoot, any end");
        Assertions.assertEquals((Object)"cdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertEquals((Object)"abcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Object[] dateArray = new java.util.Date[]{new Date(new java.util.Date().getTime()), new java.util.Date(), new java.util.Date(), new java.util.Date(), new java.util.Date()};
        Assertions.assertSame(Object.class, ArrayUtils.subarray((Object[])objectArray, (int)2, (int)4).getClass().getComponentType(), (String)"Object type");
        Assertions.assertSame(java.util.Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType(), (String)"java.util.Date type");
        Assertions.assertNotSame(Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType(), (String)"java.sql.Date type");
        Assertions.assertThrows(ClassCastException.class, () -> ArrayUtilsTest.lambda$testSubarrayObject$31((java.util.Date[])dateArray), (String)"Invalid downcast");
    }

    @Test
    void testSubarrayShort() {
        short[] nullArray = null;
        short[] array = new short[]{10, 11, 12, 13, 14, 15};
        short[] leftSubarray = new short[]{10, 11, 12, 13};
        short[] midSubarray = new short[]{11, 12, 13, 14};
        short[] rightSubarray = new short[]{12, 13, 14, 15};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((short[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Short.TYPE, ArrayUtils.subarray((short[])array, (int)2, (int)4).getClass().getComponentType(), (String)"short type");
    }

    @Test
    void testSubarrChar() {
        char[] nullArray = null;
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] leftSubarray = new char[]{'a', 'b', 'c', 'd'};
        char[] midSubarray = new char[]{'b', 'c', 'd', 'e'};
        char[] rightSubarray = new char[]{'c', 'd', 'e', 'f'};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((char[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Character.TYPE, ArrayUtils.subarray((char[])array, (int)2, (int)4).getClass().getComponentType(), (String)"char type");
    }

    @Test
    void testSwapBoolean() {
        boolean[] array = new boolean[]{true, false, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
    }

    @Test
    void testSwapBooleanRange() {
        ArrayUtils.swap((boolean[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((boolean[])new boolean[0], (int)0, (int)2, (int)1);
        boolean[] array3a = new boolean[]{true, false, true};
        boolean[] array3b = (boolean[])array3a.clone();
        ArrayUtils.swap((boolean[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((boolean[])array3a, (boolean[])array3b);
        ArrayUtils.swap((boolean[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((boolean[])array3a, (boolean[])array3b);
        boolean[] array = new boolean[]{false, false, true, true};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2, (int)2);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        array = new boolean[]{false, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)3);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)-1, (int)2, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)-1, (int)2);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
    }

    @Test
    void testSwapByte() {
        byte[] array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
    }

    @Test
    void testSwapByteRange() {
        ArrayUtils.swap((byte[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((byte[])new byte[0], (int)0, (int)2, (int)1);
        byte[] array3a = new byte[]{1, 0, 1};
        byte[] array3b = (byte[])array3a.clone();
        ArrayUtils.swap((byte[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((byte[])array3a, (byte[])array3b);
        ArrayUtils.swap((byte[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((byte[])array3a, (byte[])array3b);
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.swap((byte[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)3);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    void testSwapChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)2);
        Assertions.assertArrayEquals((char[])new char[]{'\u0003', '\u0002', '\u0001'}, (char[])array);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003'}, (char[])array);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)1, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'\u0002', '\u0001', '\u0003'}, (char[])array);
    }

    @Test
    void testSwapCharRange() {
        ArrayUtils.swap((char[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((char[])new char[0], (int)0, (int)2, (int)1);
        char[] array3a = new char[]{'\u0001', '\u0000', '\u0001'};
        char[] array3b = (char[])array3a.clone();
        ArrayUtils.swap((char[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((char[])array3a, (char[])array3b);
        ArrayUtils.swap((char[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((char[])array3a, (char[])array3b);
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.swap((char[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)3);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    void testSwapDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
    }

    @Test
    void testSwapDoubleRange() {
        ArrayUtils.swap((double[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((double[])new double[0], (int)0, (int)2, (int)1);
        double[] array3a = new double[]{1.0, 0.0, 1.0};
        double[] array3b = (double[])array3a.clone();
        ArrayUtils.swap((double[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((double[])array3a, (double[])array3b);
        ArrayUtils.swap((double[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((double[])array3a, (double[])array3b);
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)4.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        Assertions.assertEquals((double)2.0, (double)array[3]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)3);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
    }

    @Test
    void testSwapEmptyBooleanArray() {
        boolean[] array = new boolean[]{};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyByteArray() {
        byte[] array = new byte[]{};
        ArrayUtils.swap((byte[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyCharArray() {
        char[] array = new char[]{};
        ArrayUtils.swap((char[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyDoubleArray() {
        double[] array = new double[]{};
        ArrayUtils.swap((double[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyFloatArray() {
        float[] array = new float[]{};
        ArrayUtils.swap((float[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyIntArray() {
        int[] array = new int[]{};
        ArrayUtils.swap((int[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyLongArray() {
        long[] array = new long[]{};
        ArrayUtils.swap((long[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyObjectArray() {
        Object[] array = new String[]{};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapEmptyShortArray() {
        short[] array = new short[]{};
        ArrayUtils.swap((short[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    void testSwapFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
    }

    @Test
    void testSwapFloatRange() {
        ArrayUtils.swap((float[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((float[])new float[0], (int)0, (int)2, (int)1);
        float[] array3a = new float[]{1.0f, 0.0f, 1.0f};
        float[] array3b = (float[])array3a.clone();
        ArrayUtils.swap((float[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((float[])array3a, (float[])array3b);
        ArrayUtils.swap((float[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((float[])array3a, (float[])array3b);
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)4.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        Assertions.assertEquals((float)2.0f, (float)array[3]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)3);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
    }

    @Test
    void testSwapInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
    }

    @Test
    void testSwapIntExchangedOffsets() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)1, (int)2);
        Assertions.assertArrayEquals((int[])new int[]{2, 3, 1}, (int[])array);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)1, (int)0, (int)2);
        Assertions.assertArrayEquals((int[])new int[]{2, 3, 1}, (int[])array);
    }

    @Test
    void testSwapIntRange() {
        ArrayUtils.swap((int[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((int[])new int[0], (int)0, (int)2, (int)1);
        int[] array3a = new int[]{1, 0, 1};
        int[] array3b = (int[])array3a.clone();
        ArrayUtils.swap((int[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((int[])array3a, (int[])array3b);
        ArrayUtils.swap((int[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((int[])array3a, (int[])array3b);
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.swap((int[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)3, (int)0);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    void testSwapLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
    }

    @Test
    void testSwapLongRange() {
        ArrayUtils.swap((long[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((long[])new long[0], (int)0, (int)2, (int)1);
        long[] array3a = new long[]{1L, 0L, 1L};
        long[] array3b = (long[])array3a.clone();
        ArrayUtils.swap((long[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((long[])array3a, (long[])array3b);
        ArrayUtils.swap((long[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((long[])array3a, (long[])array3b);
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.swap((long[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)4L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        Assertions.assertEquals((long)2L, (long)array[3]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)3);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    void testSwapNullBooleanArray() {
        boolean[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullByteArray() {
        byte[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullCharArray() {
        char[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullDoubleArray() {
        double[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullFloatArray() {
        float[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullIntArray() {
        int[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullLongArray() {
        long[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullObjectArray() {
        Object[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapNullShortArray() {
        short[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    void testSwapObject() {
        Object[] array = new String[]{"1", "2", "3"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
    }

    @Test
    void testSwapObjectRange() {
        ArrayUtils.swap((Object[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((Object[])new Object[0], (int)0, (int)2, (int)1);
        Object[] array3a = new Object[]{1, 0, 1};
        Object[] array3b = (Object[])array3a.clone();
        ArrayUtils.swap((Object[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((Object[])array3a, (Object[])array3b);
        ArrayUtils.swap((Object[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((Object[])array3a, (Object[])array3b);
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.swap((Object[])array, (int)-1, (int)2, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.swap((Object[])array, (int)-3, (int)2, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"5", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        Assertions.assertEquals((Object)"1", (Object)array[4]);
        array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.swap((Object[])array, (int)2, (int)-2, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"5", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        Assertions.assertEquals((Object)"1", (Object)array[4]);
        array = new String[]{};
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
        array = null;
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assertions.assertNull((Object)array);
    }

    @Test
    void testSwapShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
    }

    @Test
    void testSwapShortRange() {
        ArrayUtils.swap((short[])null, (int)0, (int)2, (int)1);
        ArrayUtils.swap((short[])new short[0], (int)0, (int)2, (int)1);
        short[] array3a = new short[]{1, 0, 1};
        short[] array3b = (short[])array3a.clone();
        ArrayUtils.swap((short[])array3b, (int)array3b.length, (int)2, (int)1);
        Assertions.assertArrayEquals((short[])array3a, (short[])array3b);
        ArrayUtils.swap((short[])array3b, (int)0, (int)array3b.length, (int)1);
        Assertions.assertArrayEquals((short[])array3a, (short[])array3b);
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.swap((short[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)3, (int)0);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    void testTextIndexesOfInt() {
        int[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)2));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)3));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((int[])array, (int)99));
    }

    @Test
    void testToMap() {
        Map map = ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"hello", "world"}});
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals((Object)"world", map.get("hello"));
        Assertions.assertNull((Object)ArrayUtils.toMap(null));
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"short"}}));
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, "illegal type"}));
        LangAssertions.assertIllegalArgumentException(() -> ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, null}));
        map = ArrayUtils.toMap((Object[])new Object[]{new Map.Entry<Object, Object>(){

            @Override
            public boolean equals(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getKey() {
                return "foo";
            }

            @Override
            public Object getValue() {
                return "bar";
            }

            @Override
            public int hashCode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        }});
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals(Collections.emptyMap(), (Object)ArrayUtils.toMap((Object[])new Object[0]));
        map = ArrayUtils.toMap((Object[])new Object[][]{{null, null}, {null, null}});
        Assertions.assertEquals(Collections.singletonMap(null, null), (Object)map);
        map = ArrayUtils.toMap((Object[])new Object[][]{{"key", "value2"}, {"key", "value1"}});
        Assertions.assertEquals(Collections.singletonMap("key", "value1"), (Object)map);
    }

    @Test
    void testToObject_boolean() {
        boolean[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object)ArrayUtils.toObject((boolean[])new boolean[0]));
        Assertions.assertArrayEquals((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (Object[])ArrayUtils.toObject((boolean[])new boolean[]{true, false, true}));
    }

    @Test
    void testToObject_byte() {
        byte[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((byte[])new byte[0]));
        Assertions.assertArrayEquals((Object[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (Object[])ArrayUtils.toObject((byte[])new byte[]{-128, 127, 127}));
    }

    @Test
    void testToObject_char() {
        char[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((char[])new char[0]));
        Assertions.assertArrayEquals((Object[])new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('0')}, (Object[])ArrayUtils.toObject((char[])new char[]{'\u0000', '\uffff', '0'}));
    }

    @Test
    void testToObject_double() {
        double[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((double[])new double[0]));
        Assertions.assertArrayEquals((Object[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (Object[])ArrayUtils.toObject((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}));
    }

    @Test
    void testToObject_float() {
        float[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((float[])new float[0]));
        Assertions.assertArrayEquals((Object[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}, (Object[])ArrayUtils.toObject((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}));
    }

    @Test
    void testToObject_int() {
        int[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((int[])new int[0]));
        Assertions.assertArrayEquals((Object[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (Object[])ArrayUtils.toObject((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}));
    }

    @Test
    void testToObject_long() {
        long[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object)ArrayUtils.toObject((long[])new long[0]));
        Assertions.assertArrayEquals((Object[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (Object[])ArrayUtils.toObject((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}));
    }

    @Test
    void testToObject_short() {
        short[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((short[])new short[0]));
        Assertions.assertArrayEquals((Object[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}, (Object[])ArrayUtils.toObject((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}));
    }

    @Test
    void testToPrimitive_boolean() {
        Boolean[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0]));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null}));
    }

    @Test
    void testToPrimitive_boolean_boolean() {
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(null, (boolean)false));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0], (boolean)false));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (boolean)false));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)false));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)true));
    }

    @Test
    void testToPrimitive_byte() {
        Byte[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0]));
        Assertions.assertArrayEquals((byte[])new byte[]{-128, 127, 127}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null}));
    }

    @Test
    void testToPrimitive_byte_byte() {
        Byte[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b, (byte)-128));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0], (byte)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-128, 127, 127}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (byte)-128));
        Assertions.assertArrayEquals((byte[])new byte[]{-128, 127, 127}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null, (byte)127}, (byte)127));
    }

    @Test
    void testToPrimitive_char() {
        Character[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0]));
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\uffff', '0'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('0')}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), null}));
    }

    @Test
    void testToPrimitive_char_char() {
        Character[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b, (char)'\u0000'));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0], (char)'\u0000'));
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\uffff', '0'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('0')}, (char)'\u0000'));
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\uffff', '0'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), null, Character.valueOf('0')}, (char)'\uffff'));
    }

    @Test
    void testToPrimitive_double() {
        Double[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0]));
        Assertions.assertArrayEquals((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null}));
    }

    @Test
    void testToPrimitive_double_double() {
        Double[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (double)Double.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0], (double)1.0));
        Assertions.assertArrayEquals((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double)1.0));
        Assertions.assertArrayEquals((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, null, 9999999.0}, (double)Double.MAX_VALUE));
    }

    @Test
    void testToPrimitive_float() {
        Float[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0]));
        Assertions.assertArrayEquals((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null}));
    }

    @Test
    void testToPrimitive_float_float() {
        Float[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (float)Float.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0], (float)1.0f));
        Assertions.assertArrayEquals((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}, (float)1.0f));
        Assertions.assertArrayEquals((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null, Float.valueOf(9999999.0f)}, (float)Float.MAX_VALUE));
    }

    @Test
    void testToPrimitive_int() {
        Integer[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        Assertions.assertArrayEquals((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int[])ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, null}));
    }

    @Test
    void testToPrimitive_int_int() {
        Long[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (long)Integer.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0], (int)1));
        Assertions.assertArrayEquals((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int[])ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int[])ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, null, 9999999}, (int)Integer.MAX_VALUE));
    }

    @Test
    void testToPrimitive_intNull() {
        Integer[] iArray = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(iArray, (int)Integer.MIN_VALUE));
    }

    @Test
    void testToPrimitive_long() {
        Long[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0]));
        Assertions.assertArrayEquals((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, null}));
    }

    @Test
    void testToPrimitive_long_long() {
        Long[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (long)Long.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0], (long)1L));
        Assertions.assertArrayEquals((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long)1L));
        Assertions.assertArrayEquals((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, null, 9999999L}, (long)Long.MAX_VALUE));
    }

    @Test
    void testToPrimitive_short() {
        Short[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0]));
        Assertions.assertArrayEquals((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}));
        LangAssertions.assertNullPointerException(() -> ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, null}));
    }

    @Test
    void testToPrimitive_short_short() {
        Short[] s = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(s, (short)Short.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0], (short)Short.MIN_VALUE));
        Assertions.assertArrayEquals((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}, (short)Short.MIN_VALUE));
        Assertions.assertArrayEquals((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, null, (short)-27009}, (short)Short.MAX_VALUE));
    }

    @Test
    void testToPrimitiveArray() {
        Assertions.assertNull((Object)ArrayUtils.toPrimitive((Object)null));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{true}));
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('a')}));
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)1}));
        Assertions.assertArrayEquals((int[])new int[0], (int[])ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)2}));
        Assertions.assertArrayEquals((long[])new long[]{2L, 3L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{2L, 3L}));
        Assertions.assertArrayEquals((float[])new float[]{3.14f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(3.14f)}), (float)0.1f);
        Assertions.assertArrayEquals((double[])new double[]{2.718}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{2.718}), (double)0.1);
    }

    @Test
    void testToPrimitiveArrayViaObjectArray() {
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(null));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])((boolean[])ArrayUtils.toPrimitive((Object)new Boolean[]{true})));
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])((char[])ArrayUtils.toPrimitive((Object)new Character[]{Character.valueOf('a')})));
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])((byte[])ArrayUtils.toPrimitive((Object)new Byte[]{(byte)1})));
        Assertions.assertArrayEquals((int[])new int[0], (int[])((int[])ArrayUtils.toPrimitive((Object)new Integer[0])));
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])((short[])ArrayUtils.toPrimitive((Object)new Short[]{(short)2})));
        Assertions.assertArrayEquals((long[])new long[]{2L, 3L}, (long[])((long[])ArrayUtils.toPrimitive((Object)new Long[]{2L, 3L})));
        Assertions.assertArrayEquals((float[])new float[]{3.14f}, (float[])((float[])ArrayUtils.toPrimitive((Object)new Float[]{Float.valueOf(3.14f)})), (float)0.1f);
        Assertions.assertArrayEquals((double[])new double[]{2.718}, (double[])((double[])ArrayUtils.toPrimitive((Object)new Double[]{2.718})), (double)0.1);
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])((String[])ArrayUtils.toPrimitive((Object)new String[]{"a"})));
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString(null));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new Object[0]));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new String[0]));
        Assertions.assertEquals((Object)"{<null>}", (Object)ArrayUtils.toString((Object)new String[]{null}));
        Assertions.assertEquals((Object)"{pink,blue}", (Object)ArrayUtils.toString((Object)new String[]{"pink", "blue"}));
        Assertions.assertEquals((Object)"{<null>,<null>}", (Object)ArrayUtils.toString((Object)new String[]{null, null}));
    }

    @Test
    void testToStringArray_array() {
        Assertions.assertNull((Object)ArrayUtils.toStringArray(null));
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.toStringArray((Object[])new Object[0]));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3", "array", "test"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{1, 2, 3, "array", "test"}));
        Assertions.assertArrayEquals((Object[])new String[]{"null"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{null}));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "null", "3", "null", "test"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{1, null, 3, null, "test"}));
        Assertions.assertArrayEquals((Object[])new String[]{"null", "null", "null", "null", "null"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{null, null, null, null, null}));
    }

    @Test
    void testToStringArray_array_string() {
        Assertions.assertNull((Object)ArrayUtils.toStringArray(null, (String)""));
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.toStringArray((Object[])new Object[0], (String)""));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "MyNull", "test"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{1, null, "test"}, (String)"MyNull"));
        Assertions.assertArrayEquals((Object[])new String[]{"MyNull"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{null}, (String)"MyNull"));
        Assertions.assertArrayEquals((Object[])new String[]{"MyNull", "MyNull"}, (Object[])ArrayUtils.toStringArray((Object[])new Object[]{null, null}, (String)"MyNull"));
    }

    @Test
    void testToStringDefault() {
        Assertions.assertEquals((Object)"<empty>", (Object)ArrayUtils.toString(null, (String)"<empty>"));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new Object[0], (String)"<empty>"));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new String[0], (String)"<empty>"));
        Assertions.assertEquals((Object)"{<null>}", (Object)ArrayUtils.toString((Object)new String[]{null}, (String)"<empty>"));
        Assertions.assertEquals((Object)"{pink,blue}", (Object)ArrayUtils.toString((Object)new String[]{"pink", "blue"}, (String)"<empty>"));
    }

    private static /* synthetic */ void lambda$testSubarrayObject$31(java.util.Date[] dateArray) throws Throwable {
        Date[].class.cast(ArrayUtils.subarray((Object[])dateArray, (int)1, (int)3));
    }

    private static /* synthetic */ String lambda$testShuffleStringRandom$30(String element) {
        return "Element " + element + " not found";
    }

    private static /* synthetic */ String lambda$testShuffleString$29(String element) {
        return "Element " + element + " not found";
    }

    private static final class TestClass {
        private TestClass() {
        }
    }
}

