/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CVSTab
extends PreferencePanel {
    private JPanel cvsPanel;
    private JTextField cvsProgram;
    private JTextField cvsRepository;
    private JCheckBox enableCVS;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public CVSTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.cvsRepository);
        EDialog.makeTextFieldSelectAllOnTab(this.cvsProgram);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.cvsPanel;
    }

    @Override
    public String getName() {
        return "CVS";
    }

    @Override
    public void init() {
        this.cvsRepository.setText(CVS.getCVSRepository());
        this.cvsProgram.setText(CVS.getCVSProgram());
        this.enableCVS.setSelected(CVS.isEnabled());
    }

    @Override
    public void term() {
        boolean b;
        String str = this.cvsRepository.getText();
        if (!str.equals(CVS.getCVSRepository())) {
            CVS.setCVSRepository(str);
        }
        if (!(str = this.cvsProgram.getText()).equals(CVS.getCVSProgram())) {
            CVS.setCVSProgram(str);
        }
        if ((b = this.enableCVS.isSelected()) != CVS.isEnabled()) {
            CVS.setEnabled(b);
            if (b) {
                Iterator<Library> it = Library.getLibraries();
                while (it.hasNext()) {
                    CVSLibrary.addLibrary(it.next());
                }
                Update.updateOpenLibraries(Update.UpdateEnum.STATUS);
            } else {
                Iterator<Library> it = Library.getLibraries();
                while (it.hasNext()) {
                    CVSLibrary.removeLibrary(it.next().getId());
                }
            }
        }
    }

    @Override
    public void reset() {
        if (!CVS.getFactoryCVSRepository().equals(CVS.getCVSRepository())) {
            CVS.setCVSRepository(CVS.getFactoryCVSRepository());
        }
        if (!CVS.getFactoryCVSProgram().equals(CVS.getCVSProgram())) {
            CVS.setCVSProgram(CVS.getFactoryCVSProgram());
        }
        if (CVS.isFactoryEnabled() != CVS.isEnabled()) {
            CVS.setEnabled(CVS.isFactoryEnabled());
        }
    }

    private void initComponents() {
        this.cvsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cvsRepository = new JTextField();
        this.cvsProgram = new JTextField();
        this.enableCVS = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.cvsPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("CVS program: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cvsPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("CVS Repository: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cvsPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.cvsRepository.setColumns(16);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cvsPanel.add((Component)this.cvsRepository, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cvsPanel.add((Component)this.cvsProgram, gridBagConstraints);
        this.enableCVS.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableCVS.setText("Enable CVS");
        this.enableCVS.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(12, 4, 12, 4);
        this.cvsPanel.add((Component)this.enableCVS, gridBagConstraints);
        this.enableCVS.getAccessibleContext().setAccessibleName("EnableCVS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.cvsPanel, gridBagConstraints);
        this.pack();
    }
}

