/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class ConvertProjectsPage
extends WizardPage {
    private IProject[] initialSelection;
    private List<IProject> projects;
    private Label counterLabel;
    private CheckboxTableViewer ctv;
    private List<IProject> resultingSelection;

    public ConvertProjectsPage(List<IProject> projects, List<IProject> initialSelection, String title, String description) {
        super("convertSlingProjects");
        this.setTitle(title);
        this.setDescription(description);
        this.initialSelection = initialSelection.toArray(new IProject[0]);
        this.projects = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Table table = new Table(container, 2082);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        this.ctv = new CheckboxTableViewer(table);
        this.ctv.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.ctv.add(this.projects.toArray());
        this.ctv.setCheckedElements((Object[])this.initialSelection);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public boolean finish() {
        this.resultingSelection = new LinkedList<Object>(Arrays.asList(this.ctv.getCheckedElements()));
        return true;
    }

    public List<IProject> getSelectedProjects() {
        return this.resultingSelection;
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof IProject) {
                return ((IProject)element).getName();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }
}

