/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.PutMessageStatus;

public class FlushDiskWatcher
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final LinkedBlockingQueue<CommitLog.GroupCommitRequest> commitRequests = new LinkedBlockingQueue();

    public String getServiceName() {
        return FlushDiskWatcher.class.getSimpleName();
    }

    public void run() {
        block4: while (!this.isStopped()) {
            CommitLog.GroupCommitRequest request = null;
            try {
                request = this.commitRequests.take();
            }
            catch (InterruptedException e) {
                log.warn("take flush disk commit request, but interrupted, this may caused by shutdown");
                continue;
            }
            while (!request.future().isDone()) {
                long now = System.nanoTime();
                if (now - request.getDeadLine() >= 0L) {
                    request.wakeupCustomer(PutMessageStatus.FLUSH_DISK_TIMEOUT);
                    continue block4;
                }
                long sleepTime = (request.getDeadLine() - now) / 1000000L;
                if ((sleepTime = Math.min(10L, sleepTime)) == 0L) {
                    request.wakeupCustomer(PutMessageStatus.FLUSH_DISK_TIMEOUT);
                    continue block4;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    log.warn("An exception occurred while waiting for flushing disk to complete. this may caused by shutdown");
                    continue block4;
                }
            }
        }
    }

    public void add(CommitLog.GroupCommitRequest request) {
        this.commitRequests.add(request);
    }

    public int queueSize() {
        return this.commitRequests.size();
    }
}

