/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.console;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Scanner;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.utils.Args;
import org.apache.juneau.utils.MessageBundle;

public class HelpCommand
extends ConsoleCommand {
    private final MessageBundle mb = MessageBundle.create(HelpCommand.class, "Messages");

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getSynopsis() {
        return "help [command]";
    }

    @Override
    public String getInfo() {
        return this.mb.getString("info");
    }

    @Override
    public String getDescription() {
        return this.mb.getString("description");
    }

    @Override
    public String getExamples() {
        return this.mb.getString("examples");
    }

    @Override
    public boolean execute(Scanner in, PrintWriter out, Args args) throws Exception {
        Map<String, ConsoleCommand> commands = Microservice.getInstance().getConsoleCommands();
        if (args.size() == 1) {
            out.println(this.mb.getString("ListOfAvailableCommands"));
            for (ConsoleCommand cc : commands.values()) {
                out.append("\t").append(cc.getName()).append(" -- ").append(this.indent(cc.getInfo())).println();
            }
            out.println();
        } else {
            ConsoleCommand cc = commands.get(args.getArg(1));
            if (cc == null) {
                out.println(this.mb.getString("CommandNotFound"));
            } else {
                String info = cc.getInfo();
                String synopsis = cc.getSynopsis();
                String description = cc.getDescription();
                String examples = cc.getExamples();
                out.append(this.mb.getString("NAME")).append("\n\t").append(cc.getName()).append(info == null ? "" : " -- " + this.indent(info)).println();
                if (synopsis != null) {
                    out.append('\n').append(this.mb.getString("SYNOPSIS")).append("\n\t").append(this.indent(synopsis)).println();
                }
                if (description != null) {
                    out.append('\n').append(this.mb.getString("DESCRIPTION")).append("\n\t").append(this.indent(description)).println();
                }
                if (examples != null) {
                    out.append('\n').append(this.mb.getString("EXAMPLES")).append("\n\t").append(this.indent(examples)).println();
                }
            }
        }
        return false;
    }

    private String indent(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("\n", "\n\t");
    }
}

