/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.TypeCategory;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class JsonSchemaGeneratorSession
extends BeanTraverseSession {
    private final JsonSchemaGenerator ctx;
    private final Map<String, ObjectMap> defs;
    private JsonSerializerSession jsSession;

    protected JsonSchemaGeneratorSession(JsonSchemaGenerator ctx, BeanSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
        this.defs = this.isUseBeanDefs() ? new TreeMap<String, ObjectMap>() : null;
    }

    public ObjectMap getSchema(Object o) throws BeanRecursionException, SerializeException {
        return this.getSchema(this.toClassMeta(o), "root", null, false, false, null);
    }

    public ObjectMap getSchema(Type type) throws BeanRecursionException, SerializeException {
        return this.getSchema(this.getClassMeta(type, new Type[0]), "root", null, false, false, null);
    }

    public ObjectMap getSchema(ClassMeta<?> cm) throws BeanRecursionException, SerializeException {
        return this.getSchema(cm, "root", null, false, false, null);
    }

    private ObjectMap getSchema(ClassMeta<?> eType, String attrName, String[] pNames, boolean exampleAdded, boolean descriptionAdded, JsonSchemaBeanPropertyMeta jsbpm) throws BeanRecursionException, SerializeException {
        ClassMeta<?> pojoSwapCM;
        boolean useDef;
        if (this.ctx.isIgnoredType(eType)) {
            return null;
        }
        ObjectMap out = new ObjectMap();
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<?, ?> pojoSwap = eType.getPojoSwap(this);
        ClassMeta<?> aType = this.push(attrName, eType, null);
        ClassMeta<?> sType = eType.getSerializedClassMeta(this);
        String type = null;
        String format = null;
        Object example = null;
        Object description = null;
        boolean bl = useDef = this.isUseBeanDefs() && sType.isBean() && pNames == null;
        if (useDef) {
            exampleAdded = false;
            descriptionAdded = false;
        }
        if (useDef && this.defs.containsKey(this.getBeanDefId(sType))) {
            this.pop();
            return new ObjectMap().append("$ref", this.getBeanDefUri(sType));
        }
        ObjectMap ds = this.getDefaultSchemas().get(sType.getInnerClass().getName());
        if (ds != null && ds.containsKey("type")) {
            this.pop();
            return out.appendAll(ds);
        }
        JsonSchemaClassMeta jscm = null;
        ClassMeta<?> classMeta = pojoSwapCM = pojoSwap == null ? null : this.getClassMeta(pojoSwap.getClass());
        if (pojoSwapCM != null && pojoSwapCM.getAnnotation(Schema.class) != null) {
            jscm = this.getJsonSchemaClassMeta(pojoSwapCM);
        }
        if (jscm == null) {
            jscm = this.getJsonSchemaClassMeta(sType);
        }
        TypeCategory tc = null;
        if (sType.isNumber()) {
            tc = TypeCategory.NUMBER;
            if (sType.isDecimal()) {
                type = "number";
                if (sType.isFloat()) {
                    format = "float";
                } else if (sType.isDouble()) {
                    format = "double";
                }
            } else {
                type = "integer";
                if (sType.isShort()) {
                    format = "int16";
                } else if (sType.isInteger()) {
                    format = "int32";
                } else if (sType.isLong()) {
                    format = "int64";
                }
            }
        } else if (sType.isBoolean()) {
            tc = TypeCategory.BOOLEAN;
            type = "boolean";
        } else if (sType.isMap()) {
            tc = TypeCategory.MAP;
            type = "object";
        } else if (sType.isBean()) {
            tc = TypeCategory.BEAN;
            type = "object";
        } else if (sType.isCollection()) {
            tc = TypeCategory.COLLECTION;
            type = "array";
        } else if (sType.isArray()) {
            tc = TypeCategory.ARRAY;
            type = "array";
        } else if (sType.isEnum()) {
            tc = TypeCategory.ENUM;
            type = "string";
        } else if (sType.isCharSequence() || sType.isChar()) {
            tc = TypeCategory.STRING;
            type = "string";
        } else if (sType.isUri()) {
            tc = TypeCategory.STRING;
            type = "string";
            format = "uri";
        } else {
            tc = TypeCategory.STRING;
            type = "string";
        }
        if (jsbpm != null) {
            out.appendAll(jsbpm.getSchema());
        }
        out.appendAll(jscm.getSchema());
        out.appendIf(false, true, true, "type", type);
        out.appendIf(false, true, true, "format", format);
        if (aType != null) {
            ObjectMap om;
            example = this.getExample(sType, tc, exampleAdded);
            description = this.getDescription(sType, tc, descriptionAdded);
            exampleAdded |= example != null;
            descriptionAdded |= description != null;
            if (tc == TypeCategory.BEAN) {
                ObjectMap properties = new ObjectMap();
                BeanMeta<?> bm = this.getBeanMeta(sType.getInnerClass());
                if (pNames != null) {
                    bm = new BeanMetaFiltered(bm, pNames);
                }
                for (BeanPropertyMeta p : bm.getPropertyMetas()) {
                    if (!p.canRead()) continue;
                    properties.put(p.getName(), this.getSchema(p.getClassMeta(), p.getName(), p.getProperties(), exampleAdded, descriptionAdded, this.getJsonSchemaBeanPropertyMeta(p)));
                }
                out.put("properties", properties);
            } else if (tc == TypeCategory.COLLECTION) {
                ClassMeta<?> et = sType.getElementType();
                if (sType.isCollection() && sType.getInfo().isChildOf(Set.class)) {
                    out.put("uniqueItems", true);
                }
                out.put("items", this.getSchema(et, "items", pNames, exampleAdded, descriptionAdded, null));
            } else if (tc == TypeCategory.ARRAY) {
                ClassMeta<?> et = sType.getElementType();
                if (sType.isCollection() && sType.getInfo().isChildOf(Set.class)) {
                    out.put("uniqueItems", true);
                }
                out.put("items", this.getSchema(et, "items", pNames, exampleAdded, descriptionAdded, null));
            } else if (tc == TypeCategory.ENUM) {
                out.put("enum", this.getEnums(sType));
            } else if (tc == TypeCategory.MAP && !(om = this.getSchema(sType.getValueType(), "additionalProperties", null, exampleAdded, descriptionAdded, null)).isEmpty()) {
                out.put("additionalProperties", om);
            }
        }
        out.appendAll(jscm.getSchema());
        out.appendIf(false, true, true, "description", description);
        out.appendIf(false, true, true, "x-example", example);
        if (ds != null) {
            out.appendAll(ds);
        }
        if (useDef) {
            this.defs.put(this.getBeanDefId(sType), out);
            out = new ObjectMap().append("$ref", this.getBeanDefUri(sType));
        }
        this.pop();
        return out;
    }

    private List<String> getEnums(ClassMeta<?> cm) {
        ArrayList<String> l = new ArrayList<String>();
        for (Enum<?> e : ObjectUtils.getEnumConstants(cm.getInnerClass())) {
            l.add(cm.toString(e));
        }
        return l;
    }

    private Object getExample(ClassMeta<?> sType, TypeCategory t, boolean exampleAdded) throws SerializeException {
        Object example;
        boolean canAdd;
        boolean bl = canAdd = this.isAllowNestedExamples() || !exampleAdded;
        if (canAdd && (this.getAddExamplesTo().contains((Object)t) || this.getAddExamplesTo().contains((Object)TypeCategory.ANY)) && (example = sType.getExample(this)) != null) {
            try {
                return JsonParser.DEFAULT.parse(this.toJson(example), Object.class);
            }
            catch (ParseException e) {
                throw new SerializeException(e);
            }
        }
        return null;
    }

    private String toJson(Object o) throws SerializeException {
        if (this.jsSession == null) {
            this.jsSession = this.ctx.getJsonSerializer().createSession(null);
        }
        return this.jsSession.serializeToString(o);
    }

    private Object getDescription(ClassMeta<?> sType, TypeCategory t, boolean descriptionAdded) {
        boolean canAdd;
        boolean bl = canAdd = this.isAllowNestedDescriptions() || !descriptionAdded;
        if (canAdd && (this.getAddDescriptionsTo().contains((Object)t) || this.getAddDescriptionsTo().contains((Object)TypeCategory.ANY))) {
            return sType.toString();
        }
        return null;
    }

    public String getBeanDefId(ClassMeta<?> cm) {
        return this.getBeanDefMapper().getId(cm);
    }

    public URI getBeanDefUri(ClassMeta<?> cm) {
        return this.getBeanDefMapper().getURI(cm);
    }

    public URI getBeanDefUri(String id) {
        return this.getBeanDefMapper().getURI(id);
    }

    public Map<String, ObjectMap> getBeanDefs() {
        return this.defs;
    }

    public JsonSchemaGeneratorSession addBeanDef(String id, ObjectMap def) {
        if (this.defs != null) {
            this.defs.put(id, def);
        }
        return this;
    }

    protected final Set<TypeCategory> getAddDescriptionsTo() {
        return this.ctx.getAddDescriptionsTo();
    }

    protected final Set<TypeCategory> getAddExamplesTo() {
        return this.ctx.getAddExamplesTo();
    }

    protected final boolean isAllowNestedDescriptions() {
        return this.ctx.isAllowNestedDescriptions();
    }

    protected final boolean isAllowNestedExamples() {
        return this.ctx.isAllowNestedExamples();
    }

    protected final BeanDefMapper getBeanDefMapper() {
        return this.ctx.getBeanDefMapper();
    }

    protected final Map<String, ObjectMap> getDefaultSchemas() {
        return this.ctx.getDefaultSchemas();
    }

    protected final Set<Pattern> getIgnoreTypes() {
        return this.ctx.getIgnoreTypes();
    }

    protected final boolean isUseBeanDefs() {
        return this.ctx.isUseBeanDefs();
    }

    public JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonSchemaClassMeta(cm);
    }

    public JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getJsonSchemaBeanPropertyMeta(bpm);
    }

    private ClassMeta<?> toClassMeta(Object o) {
        if (o instanceof Type) {
            return this.getClassMeta((Type)o, new Type[0]);
        }
        return this.getClassMetaForObject(o);
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("JsonSchemaGeneratorSession", new DefaultFilteringObjectMap());
    }
}

