/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionMap;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;

public interface BeanMap<T>
extends Map<String, Object> {
    @NonNull
    public Class<T> getBeanType();

    @NonNull
    public static <B> BeanMap<B> of(@NonNull B bean2) {
        ArgumentUtils.requireNonNull("bean", bean2);
        BeanIntrospection<?> introspection = BeanIntrospector.SHARED.getIntrospection(bean2.getClass());
        return new BeanIntrospectionMap(introspection, bean2);
    }
}

