/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.ShortConverter;

public class IntegerConverter
implements BytesConverter<Integer> {
    public static final BytesConverter<Integer> INSTANCE = new IntegerConverter();
    private static final int BYTES = 4;

    static int getInt(byte[] bytes) {
        if (bytes.length < 4) {
            return ShortConverter.getShort(bytes);
        }
        if (bytes.length > 4) {
            throw new IllegalArgumentException("byte[] is too large for a single int value: " + bytes.length);
        }
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    static byte[] getBytes(int k) {
        if (k >= Short.MIN_VALUE && k <= Short.MAX_VALUE) {
            return ShortConverter.getBytes((short)k);
        }
        return new byte[]{(byte)(k >> 24), (byte)(k >> 16), (byte)(k >> 8), (byte)k};
    }

    @Override
    public Integer fromBytes(byte[] bytes) {
        return IntegerConverter.getInt(bytes);
    }

    @Override
    public byte[] toBytes(Integer value) {
        return IntegerConverter.getBytes(value);
    }
}

