/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class CallerContext {
    public static final Charset SIGNATURE_ENCODING = StandardCharsets.UTF_8;
    public static final String CLIENT_IP_STR = "clientIp";
    public static final String CLIENT_PORT_STR = "clientPort";
    public static final String REAL_USER_STR = "realUser";
    private final String context;
    private final byte[] signature;

    private CallerContext(Builder builder) {
        this.context = builder.getContext();
        this.signature = builder.getSignature();
    }

    public String getContext() {
        return this.context;
    }

    public byte[] getSignature() {
        return this.signature == null ? null : Arrays.copyOf(this.signature, this.signature.length);
    }

    @InterfaceAudience.Private
    public boolean isContextValid() {
        return this.context != null && !this.context.isEmpty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.context).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CallerContext rhs = (CallerContext)obj;
        return new EqualsBuilder().append(this.context, rhs.context).append(this.signature, rhs.signature).isEquals();
    }

    public String toString() {
        if (!this.isContextValid()) {
            return "";
        }
        String str = this.context;
        if (this.signature != null) {
            str = str + ":";
            str = str + new String(this.signature, SIGNATURE_ENCODING);
        }
        return str;
    }

    public static CallerContext getCurrent() {
        return CurrentCallerContextHolder.CALLER_CONTEXT.get();
    }

    public static void setCurrent(CallerContext callerContext) {
        CurrentCallerContextHolder.CALLER_CONTEXT.set(callerContext);
    }

    private static final class CurrentCallerContextHolder {
        static final ThreadLocal<CallerContext> CALLER_CONTEXT = new InheritableThreadLocal<CallerContext>();

        private CurrentCallerContextHolder() {
        }
    }

    public static final class Builder {
        public static final String KEY_VALUE_SEPARATOR = ":";
        private static final Set<String> ILLEGAL_SEPARATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("\t", "\n", "=")));
        private final String fieldSeparator;
        private final StringBuilder sb = new StringBuilder();
        private byte[] signature;

        public Builder(String context) {
            this(context, ",");
        }

        public Builder(String context, Configuration conf) {
            if (this.isValid(context)) {
                this.sb.append(context);
            }
            this.fieldSeparator = conf.get("hadoop.caller.context.separator", ",");
            this.checkFieldSeparator(this.fieldSeparator);
        }

        public Builder(String context, String separator) {
            if (this.isValid(context)) {
                this.sb.append(context);
            }
            this.fieldSeparator = separator;
            this.checkFieldSeparator(this.fieldSeparator);
        }

        private void checkFieldSeparator(String separator) {
            if (ILLEGAL_SEPARATORS.contains(separator)) {
                throw new IllegalArgumentException("Illegal field separator: " + separator);
            }
        }

        private boolean isValid(String field) {
            return field != null && field.length() > 0;
        }

        public Builder setSignature(byte[] signature) {
            if (signature != null && signature.length > 0) {
                this.signature = Arrays.copyOf(signature, signature.length);
            }
            return this;
        }

        public String getContext() {
            return this.sb.length() > 0 ? this.sb.toString() : null;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public Builder append(String field) {
            if (this.isValid(field)) {
                if (this.sb.length() > 0) {
                    this.sb.append(this.fieldSeparator);
                }
                this.sb.append(field);
            }
            return this;
        }

        public Builder append(String key, String value) {
            if (this.isValid(key) && this.isValid(value)) {
                if (this.sb.length() > 0) {
                    this.sb.append(this.fieldSeparator);
                }
                this.sb.append(key).append(KEY_VALUE_SEPARATOR).append(value);
            }
            return this;
        }

        public Builder appendIfAbsent(String key, String value) {
            if (this.sb.toString().contains(key + KEY_VALUE_SEPARATOR)) {
                return this;
            }
            if (this.isValid(key) && this.isValid(value)) {
                if (this.sb.length() > 0) {
                    this.sb.append(this.fieldSeparator);
                }
                this.sb.append(key).append(KEY_VALUE_SEPARATOR).append(value);
            }
            return this;
        }

        public CallerContext build() {
            return new CallerContext(this);
        }
    }
}

