/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.util.InternalException;

class CurrentTemporal
extends Const {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Temporal> _type;

    public CurrentTemporal(Class<? extends Temporal> type) {
        this._type = type;
    }

    @Override
    public Class<? extends Temporal> getType() {
        return this._type;
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        if (LocalDateTime.class.isAssignableFrom(this._type)) {
            return LocalDateTime.ofInstant(res.getTimestamp(this, null).toInstant(), ZoneId.systemDefault());
        }
        if (LocalTime.class.isAssignableFrom(this._type)) {
            return res.getTime(this, null).toLocalTime();
        }
        if (LocalDate.class.isAssignableFrom(this._type)) {
            return res.getDate(this, null).toLocalDate();
        }
        throw new InternalException();
    }

    @Override
    public Object getValue(Object[] params) {
        if (LocalDateTime.class.isAssignableFrom(this._type)) {
            return LocalDateTime.now();
        }
        if (LocalDate.class.isAssignableFrom(this._type)) {
            return LocalDate.now();
        }
        if (LocalTime.class.isAssignableFrom(this._type)) {
            return LocalTime.now();
        }
        return null;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        if (LocalDateTime.class.isAssignableFrom(this._type)) {
            sql2.append(ctx.store.getDBDictionary().currentTimestampFunction);
        } else if (LocalTime.class.isAssignableFrom(this._type)) {
            sql2.append(ctx.store.getDBDictionary().currentTimeFunction);
        } else if (LocalDate.class.isAssignableFrom(this._type)) {
            sql2.append(ctx.store.getDBDictionary().currentDateFunction);
        } else {
            throw new InternalException();
        }
    }
}

