/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.filter;

import java.util.HashSet;
import java.util.Set;
import relocated_for_contentpackage.javax.jcr.Item;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.DumpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ItemFilter;

public class NtFileItemFilter
implements ItemFilter {
    private static final Set<String> fileNames = new HashSet<String>();
    private static final Set<String> resNames;

    @Override
    public boolean matches(Item item, int depth) throws RepositoryException {
        if (item.isNode()) {
            Node node = (Node)item;
            if (depth == 0) {
                return node.isNodeType("nt:file");
            }
            if (depth == 1) {
                return item.getName().equals("jcr:content");
            }
            return false;
        }
        if (depth == 1) {
            return fileNames.contains(item.getName());
        }
        if (depth == 2 && item.getParent().getName().equals("jcr:content")) {
            return resNames.contains(item.getName());
        }
        return false;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", this.getClass().getSimpleName());
    }

    static {
        fileNames.add("jcr:primaryType");
        fileNames.add("jcr:mixinTypes");
        fileNames.add("jcr:uuid");
        fileNames.add("jcr:created");
        fileNames.add("jcr:createdBy");
        resNames = new HashSet<String>();
        resNames.add("jcr:encoding");
        resNames.add("jcr:mimeType");
        resNames.add("jcr:primaryType");
        resNames.add("jcr:mixinTypes");
        resNames.add("jcr:uuid");
        resNames.add("jcr:lastModified");
        resNames.add("jcr:data");
    }
}

