/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.auth;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.AclInfo;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class CopyAclsSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "copyAcl";
    }

    @Override
    public String commandDesc() {
        return "Copy acl to cluster.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("f", "fromBroker", true, "the source broker that the acls copy from");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "toBroker", true, "the target broker that the acls copy to");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("s", "subjects", true, "the subject list of acl to copy.");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            if (commandLine.hasOption("f") && commandLine.hasOption("t")) {
                String sourceBroker = StringUtils.trim((String)commandLine.getOptionValue("f"));
                String targetBroker = StringUtils.trim((String)commandLine.getOptionValue("t"));
                String subjects = StringUtils.trim((String)commandLine.getOptionValue('s'));
                defaultMQAdminExt.start();
                List<Object> aclInfos = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)subjects)) {
                    for (String subject : StringUtils.split((String)subjects, (String)",")) {
                        AclInfo aclInfo = defaultMQAdminExt.getAcl(sourceBroker, subject);
                        if (aclInfo == null) continue;
                        aclInfos.add(aclInfo);
                    }
                } else {
                    aclInfos = defaultMQAdminExt.listAcl(sourceBroker, null, null);
                }
                if (CollectionUtils.isEmpty(aclInfos)) {
                    return;
                }
                for (AclInfo aclInfo : aclInfos) {
                    if (defaultMQAdminExt.getAcl(targetBroker, aclInfo.getSubject()) == null) {
                        defaultMQAdminExt.createAcl(targetBroker, aclInfo);
                    } else {
                        defaultMQAdminExt.updateAcl(targetBroker, aclInfo);
                    }
                    System.out.printf("copy acl of %s from %s to %s success.%n", aclInfo.getSubject(), sourceBroker, targetBroker);
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

