/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.management;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.CredentialRecord;
import org.springframework.security.web.webauthn.api.ImmutableCredentialRecord;
import org.springframework.security.web.webauthn.api.ImmutablePublicKeyCose;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class JdbcUserCredentialRepository
implements UserCredentialRepository {
    private RowMapper<CredentialRecord> credentialRecordRowMapper = new CredentialRecordRowMapper(ResultSet::getBytes);
    private Function<CredentialRecord, List<SqlParameterValue>> credentialRecordParametersMapper = new CredentialRecordParametersMapper();
    private SetBytes setBytes = PreparedStatement::setBytes;
    private final JdbcOperations jdbcOperations;
    private static final String TABLE_NAME = "user_credentials";
    private static final String COLUMN_NAMES = "credential_id, user_entity_user_id, public_key, signature_count, uv_initialized, backup_eligible, authenticator_transports, public_key_credential_type, backup_state, attestation_object, attestation_client_data_json, created, last_used, label ";
    private static final String SAVE_CREDENTIAL_RECORD_SQL = "INSERT INTO user_credentials (credential_id, user_entity_user_id, public_key, signature_count, uv_initialized, backup_eligible, authenticator_transports, public_key_credential_type, backup_state, attestation_object, attestation_client_data_json, created, last_used, label ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ID_FILTER = "credential_id = ? ";
    private static final String USER_ID_FILTER = "user_entity_user_id = ? ";
    private static final String FIND_CREDENTIAL_RECORD_BY_ID_SQL = "SELECT credential_id, user_entity_user_id, public_key, signature_count, uv_initialized, backup_eligible, authenticator_transports, public_key_credential_type, backup_state, attestation_object, attestation_client_data_json, created, last_used, label  FROM user_credentials WHERE credential_id = ? ";
    private static final String FIND_CREDENTIAL_RECORD_BY_USER_ID_SQL = "SELECT credential_id, user_entity_user_id, public_key, signature_count, uv_initialized, backup_eligible, authenticator_transports, public_key_credential_type, backup_state, attestation_object, attestation_client_data_json, created, last_used, label  FROM user_credentials WHERE user_entity_user_id = ? ";
    private static final String DELETE_CREDENTIAL_RECORD_SQL = "DELETE FROM user_credentials WHERE credential_id = ? ";
    private static final String UPDATE_CREDENTIAL_RECORD_SQL = "UPDATE user_credentials SET user_entity_user_id = ?, public_key = ?, signature_count = ?, uv_initialized = ?, backup_eligible = ? ,authenticator_transports = ?, public_key_credential_type = ?, backup_state = ?, attestation_object = ?, attestation_client_data_json = ?, created = ?, last_used = ?, label = ? WHERE credential_id = ? ";

    public JdbcUserCredentialRepository(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public void delete(Bytes credentialId) {
        Assert.notNull((Object)credentialId, (String)"credentialId cannot be null");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)credentialId.toBase64UrlString())};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        this.jdbcOperations.update(DELETE_CREDENTIAL_RECORD_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    public void save(CredentialRecord record) {
        Assert.notNull((Object)record, (String)"record cannot be null");
        int rows = this.updateCredentialRecord(record);
        if (rows == 0) {
            this.insertCredentialRecord(record);
        }
    }

    private void insertCredentialRecord(CredentialRecord record) {
        List<SqlParameterValue> parameters = this.credentialRecordParametersMapper.apply(record);
        BlobArgumentPreparedStatementSetter pss = new BlobArgumentPreparedStatementSetter(this.setBytes, parameters.toArray());
        this.jdbcOperations.update(SAVE_CREDENTIAL_RECORD_SQL, (PreparedStatementSetter)pss);
    }

    private int updateCredentialRecord(CredentialRecord record) {
        List<SqlParameterValue> parameters = this.credentialRecordParametersMapper.apply(record);
        SqlParameterValue credentialId = parameters.remove(0);
        parameters.add(credentialId);
        BlobArgumentPreparedStatementSetter pss = new BlobArgumentPreparedStatementSetter(this.setBytes, parameters.toArray());
        return this.jdbcOperations.update(UPDATE_CREDENTIAL_RECORD_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    public CredentialRecord findByCredentialId(Bytes credentialId) {
        Assert.notNull((Object)credentialId, (String)"credentialId cannot be null");
        List result = this.jdbcOperations.query(FIND_CREDENTIAL_RECORD_BY_ID_SQL, this.credentialRecordRowMapper, new Object[]{credentialId.toBase64UrlString()});
        return !result.isEmpty() ? (CredentialRecord)result.get(0) : null;
    }

    @Override
    public List<CredentialRecord> findByUserId(Bytes userId) {
        Assert.notNull((Object)userId, (String)"userId cannot be null");
        return this.jdbcOperations.query(FIND_CREDENTIAL_RECORD_BY_USER_ID_SQL, this.credentialRecordRowMapper, new Object[]{userId.toBase64UrlString()});
    }

    @Deprecated(since="6.5", forRemoval=true)
    public void setLobHandler(LobHandler lobHandler) {
        Assert.notNull((Object)lobHandler, (String)"lobHandler cannot be null");
        this.setBytes = (ps, index, bytes) -> {
            try (LobCreator creator = lobHandler.getLobCreator();){
                creator.setBlobAsBytes(ps, index, bytes);
            }
        };
        this.credentialRecordRowMapper = new CredentialRecordRowMapper((arg_0, arg_1) -> ((LobHandler)lobHandler).getBlobAsBytes(arg_0, arg_1));
    }

    private static class CredentialRecordRowMapper
    implements RowMapper<CredentialRecord> {
        private final GetBytes getBytes;

        CredentialRecordRowMapper(GetBytes getBytes) {
            this.getBytes = getBytes;
        }

        public CredentialRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
            Bytes credentialId = Bytes.fromBase64(new String(rs.getString("credential_id").getBytes()));
            Bytes userEntityUserId = Bytes.fromBase64(new String(rs.getString("user_entity_user_id").getBytes()));
            ImmutablePublicKeyCose publicKey = new ImmutablePublicKeyCose(this.getBytes.getBytes(rs, "public_key"));
            long signatureCount = rs.getLong("signature_count");
            boolean uvInitialized = rs.getBoolean("uv_initialized");
            boolean backupEligible = rs.getBoolean("backup_eligible");
            PublicKeyCredentialType credentialType = PublicKeyCredentialType.valueOf(rs.getString("public_key_credential_type"));
            boolean backupState = rs.getBoolean("backup_state");
            Bytes attestationObject = null;
            byte[] rawAttestationObject = this.getBytes.getBytes(rs, "attestation_object");
            if (rawAttestationObject != null) {
                attestationObject = new Bytes(rawAttestationObject);
            }
            Bytes attestationClientDataJson = null;
            byte[] rawAttestationClientDataJson = this.getBytes.getBytes(rs, "attestation_client_data_json");
            if (rawAttestationClientDataJson != null) {
                attestationClientDataJson = new Bytes(rawAttestationClientDataJson);
            }
            Instant created = this.fromTimestamp(rs.getTimestamp("created"));
            Instant lastUsed = this.fromTimestamp(rs.getTimestamp("last_used"));
            String label = rs.getString("label");
            String[] transports = rs.getString("authenticator_transports").split(",");
            HashSet<AuthenticatorTransport> authenticatorTransports = new HashSet<AuthenticatorTransport>();
            for (String transport : transports) {
                authenticatorTransports.add(AuthenticatorTransport.valueOf(transport));
            }
            return ImmutableCredentialRecord.builder().credentialId(credentialId).userEntityUserId(userEntityUserId).publicKey(publicKey).signatureCount(signatureCount).uvInitialized(uvInitialized).backupEligible(backupEligible).credentialType(credentialType).backupState(backupState).attestationObject(attestationObject).attestationClientDataJSON(attestationClientDataJson).created(created).label(label).lastUsed(lastUsed).transports(authenticatorTransports).build();
        }

        private Instant fromTimestamp(Timestamp timestamp) {
            if (timestamp == null) {
                return null;
            }
            return timestamp.toInstant();
        }
    }

    private static interface GetBytes {
        public byte[] getBytes(ResultSet var1, String var2) throws SQLException;
    }

    private static class CredentialRecordParametersMapper
    implements Function<CredentialRecord, List<SqlParameterValue>> {
        private CredentialRecordParametersMapper() {
        }

        @Override
        public List<SqlParameterValue> apply(CredentialRecord record) {
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            ArrayList<String> transports = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(record.getTransports())) {
                for (AuthenticatorTransport transport : record.getTransports()) {
                    transports.add(transport.getValue());
                }
            }
            parameters.add(new SqlParameterValue(12, (Object)record.getCredentialId().toBase64UrlString()));
            parameters.add(new SqlParameterValue(12, (Object)record.getUserEntityUserId().toBase64UrlString()));
            parameters.add(new SqlParameterValue(2004, (Object)record.getPublicKey().getBytes()));
            parameters.add(new SqlParameterValue(-5, (Object)record.getSignatureCount()));
            parameters.add(new SqlParameterValue(16, (Object)record.isUvInitialized()));
            parameters.add(new SqlParameterValue(16, (Object)record.isBackupEligible()));
            parameters.add(new SqlParameterValue(12, (Object)(!CollectionUtils.isEmpty(record.getTransports()) ? String.join((CharSequence)",", transports) : "")));
            parameters.add(new SqlParameterValue(12, record.getCredentialType() != null ? record.getCredentialType().getValue() : null));
            parameters.add(new SqlParameterValue(16, (Object)record.isBackupState()));
            parameters.add(new SqlParameterValue(2004, record.getAttestationObject() != null ? record.getAttestationObject().getBytes() : null));
            parameters.add(new SqlParameterValue(2004, record.getAttestationClientDataJSON() != null ? record.getAttestationClientDataJSON().getBytes() : null));
            parameters.add(new SqlParameterValue(93, (Object)this.fromInstant(record.getCreated())));
            parameters.add(new SqlParameterValue(93, (Object)this.fromInstant(record.getLastUsed())));
            parameters.add(new SqlParameterValue(12, (Object)record.getLabel()));
            return parameters;
        }

        private Timestamp fromInstant(Instant instant) {
            if (instant == null) {
                return null;
            }
            return Timestamp.from(instant);
        }
    }

    private static interface SetBytes {
        public void setBytes(PreparedStatement var1, int var2, byte[] var3) throws SQLException;
    }

    private static final class BlobArgumentPreparedStatementSetter
    extends ArgumentPreparedStatementSetter {
        private final SetBytes setBytes;

        private BlobArgumentPreparedStatementSetter(SetBytes setBytes, Object[] args) {
            super(args);
            this.setBytes = setBytes;
        }

        protected void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
            SqlParameterValue paramValue;
            if (argValue instanceof SqlParameterValue && (paramValue = (SqlParameterValue)argValue).getSqlType() == 2004) {
                if (paramValue.getValue() != null) {
                    Assert.isInstanceOf(byte[].class, (Object)paramValue.getValue(), (String)"Value of blob parameter must be byte[]");
                }
                byte[] valueBytes = (byte[])paramValue.getValue();
                this.setBytes.setBytes(ps, parameterPosition, valueBytes);
                return;
            }
            super.doSetValue(ps, parameterPosition, argValue);
        }
    }
}

