/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class ReflectionMap<V> {
    final List<ClassEntry<V>> classEntries;
    final List<MethodEntry<V>> methodEntries;
    final List<FieldEntry<V>> fieldEntries;
    final List<ConstructorEntry<V>> constructorEntries;

    public static <V> Builder<V> create(Class<V> c) {
        return new Builder();
    }

    private static boolean argMatches(String pattern, Class<?> type) {
        int patternDims = 0;
        String patternBase = pattern;
        while (patternBase.endsWith("[]")) {
            ++patternDims;
            patternBase = patternBase.substring(0, patternBase.length() - 2);
        }
        int typeDims = 0;
        Class<?> typeBase = type;
        while (typeBase.isArray()) {
            ++typeDims;
            typeBase = typeBase.getComponentType();
        }
        if (patternDims != typeDims) {
            return false;
        }
        if (patternDims == 0) {
            return Utils.eq(pattern, type.getSimpleName()) || Utils.eq(pattern, type.getName());
        }
        return Utils.eq(patternBase, typeBase.getSimpleName()) || Utils.eq(patternBase, typeBase.getName());
    }

    private static boolean argsMatch(String[] names, Class<?>[] args) {
        if (names == null) {
            return true;
        }
        if (names.length != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (ReflectionMap.argMatches(names[i], args[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean classMatches(String simpleName, String fullName, Class<?> c) {
        String cSimple = Utils.cns(c);
        String cFull = Utils.cn(c);
        if (Utils.eq(simpleName, cSimple) || Utils.eq(fullName, cFull) || "*".equals(simpleName)) {
            return true;
        }
        if (cFull.indexOf(36) != -1) {
            Package p = c.getPackage();
            if (Utils.nn(p)) {
                cFull = cFull.substring(p.getName().length() + 1);
            }
            if (Utils.eq(simpleName, cFull)) {
                return true;
            }
            int i = cFull.indexOf(36);
            while (i != -1) {
                if (Utils.eq(simpleName, cFull = cFull.substring(i + 1))) {
                    return true;
                }
                i = cFull.indexOf(36);
            }
        }
        return false;
    }

    private static String simpleClassName(String name) {
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return null;
    }

    private static void splitNames(String key, Consumer<String> consumer) {
        if (key.indexOf(44) == -1) {
            consumer.accept(key);
        } else {
            int m = 0;
            boolean escaped = false;
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == '(') {
                    escaped = true;
                    continue;
                }
                if (c == ')') {
                    escaped = false;
                    continue;
                }
                if (c != ',' || escaped) continue;
                consumer.accept(key.substring(m, i).trim());
                m = i + 1;
            }
            consumer.accept(key.substring(m).trim());
        }
    }

    private static String stripGenerics(String type) {
        if (type.indexOf(60) == -1) {
            return type;
        }
        StringBuilder sb = new StringBuilder(type.length());
        int depth = 0;
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '<') {
                ++depth;
                continue;
            }
            if (c == '>') {
                --depth;
                continue;
            }
            if (depth != 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    protected ReflectionMap(Builder<V> b) {
        this.classEntries = CollectionUtils.u(CollectionUtils.copyOf(b.classEntries));
        this.methodEntries = CollectionUtils.u(CollectionUtils.copyOf(b.methodEntries));
        this.fieldEntries = CollectionUtils.u(CollectionUtils.copyOf(b.fieldEntries));
        this.constructorEntries = CollectionUtils.u(CollectionUtils.copyOf(b.constructorEntries));
    }

    public Stream<V> find(Class<?> c) {
        return this.classEntries.stream().filter(x -> x.matches(c)).map(x -> x.value);
    }

    public Stream<V> find(Constructor<?> c) {
        return this.constructorEntries.stream().filter(x -> x.matches(c)).map(x -> x.value);
    }

    public Stream<V> find(Field f) {
        return this.fieldEntries.stream().filter(x -> x.matches(f)).map(x -> x.value);
    }

    public Stream<V> find(Method m) {
        return this.methodEntries.stream().filter(x -> x.matches(m)).map(x -> x.value);
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("classEntries", this.classEntries).a("methodEntries", this.methodEntries).a("fieldEntries", this.fieldEntries).a("constructorEntries", this.constructorEntries);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    public static class Builder<V> {
        final List<ClassEntry<V>> classEntries = CollectionUtils.list(new ClassEntry[0]);
        final List<MethodEntry<V>> methodEntries = CollectionUtils.list(new MethodEntry[0]);
        final List<FieldEntry<V>> fieldEntries = CollectionUtils.list(new FieldEntry[0]);
        final List<ConstructorEntry<V>> constructorEntries = CollectionUtils.list(new ConstructorEntry[0]);

        protected Builder() {
        }

        public Builder<V> append(String key, V value) {
            if (Utils.e(key)) {
                throw ThrowableUtils.rex("Invalid reflection signature: [{0}]", key);
            }
            try {
                ReflectionMap.splitNames(key, k -> {
                    if (k.endsWith(")")) {
                        int i = k.substring(0, k.indexOf(40)).lastIndexOf(46);
                        if (i == -1 || Character.isUpperCase(k.charAt(i + 1))) {
                            this.constructorEntries.add(new ConstructorEntry<Object>((String)k, value));
                        } else {
                            this.methodEntries.add(new MethodEntry<Object>((String)k, value));
                        }
                    } else {
                        int i = k.lastIndexOf(46);
                        if (i == -1) {
                            this.classEntries.add(new ClassEntry<Object>((String)k, value));
                        } else if (Character.isUpperCase(k.charAt(i + 1))) {
                            this.classEntries.add(new ClassEntry<Object>((String)k, value));
                            this.fieldEntries.add(new FieldEntry<Object>((String)k, value));
                        } else {
                            this.methodEntries.add(new MethodEntry<Object>((String)k, value));
                            this.fieldEntries.add(new FieldEntry<Object>((String)k, value));
                        }
                    }
                });
            }
            catch (IndexOutOfBoundsException e) {
                throw ThrowableUtils.rex("Invalid reflection signature: [{0}]", key);
            }
            return this;
        }

        public ReflectionMap<V> build() {
            return new ReflectionMap(this);
        }
    }

    private static class MethodEntry<V> {
        String simpleClassName;
        String fullClassName;
        String methodName;
        String[] args;
        V value;

        MethodEntry(String name, V value) {
            int i = name.indexOf(40);
            String[] stringArray = this.args = i == -1 ? null : StringUtils.splitMethodArgs(name.substring(i + 1, name.length() - 1));
            if (Utils.nn(this.args)) {
                for (int j = 0; j < this.args.length; ++j) {
                    this.args[j] = ReflectionMap.stripGenerics(this.args[j]);
                }
            }
            name = i == -1 ? name : name.substring(0, i);
            i = name.lastIndexOf(46);
            String s1 = name.substring(0, i).trim();
            String s2 = name.substring(i + 1).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.methodName = s2;
            this.value = value;
        }

        public boolean matches(Method m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && Utils.eq(m.getName(), this.methodName) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        protected FluentMap<String, Object> properties() {
            return CollectionUtils.filteredBeanPropertyMap().a("args", Utils.opt(this.args).map(x -> "[" + StringUtils.toCdl(x) + "]").orElse(null)).a("fullClassName", this.fullClassName).a("methodName", this.methodName).a("simpleClassName", this.simpleClassName).a("value", this.value);
        }

        public String toString() {
            return Utils.r(this.properties());
        }
    }

    private static class FieldEntry<V> {
        String simpleClassName;
        String fullClassName;
        String fieldName;
        V value;

        FieldEntry(String name, V value) {
            int i = name.lastIndexOf(46);
            String s1 = name.substring(0, i);
            String s2 = name.substring(i + 1);
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.fieldName = s2;
            this.value = value;
        }

        public boolean matches(Field f) {
            if (f == null) {
                return false;
            }
            Class<?> c = f.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && Utils.eq(f.getName(), this.fieldName);
        }

        protected FluentMap<String, Object> properties() {
            return CollectionUtils.filteredBeanPropertyMap().a("fieldName", this.fieldName).a("fullClassName", this.fullClassName).a("simpleClassName", this.simpleClassName).a("value", this.value);
        }

        public String toString() {
            return Utils.r(this.properties());
        }
    }

    private static class ConstructorEntry<V> {
        String simpleClassName;
        String fullClassName;
        String[] args;
        V value;

        ConstructorEntry(String name, V value) {
            int i = name.indexOf(40);
            this.args = StringUtils.splitMethodArgs(name.substring(i + 1, name.length() - 1));
            for (int j = 0; j < this.args.length; ++j) {
                this.args[j] = ReflectionMap.stripGenerics(this.args[j]);
            }
            name = name.substring(0, i).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(name);
            this.fullClassName = name;
            this.value = value;
        }

        public boolean matches(Constructor<?> m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        protected FluentMap<String, Object> properties() {
            return CollectionUtils.filteredBeanPropertyMap().a("args", this.args).a("fullClassName", this.fullClassName).a("simpleClassName", this.simpleClassName).a("value", this.value);
        }

        public String toString() {
            return Utils.r(this.properties());
        }
    }

    private static class ClassEntry<V> {
        final String simpleName;
        final String fullName;
        final V value;

        ClassEntry(String name, V value) {
            this.simpleName = ReflectionMap.simpleClassName(name);
            this.fullName = name;
            this.value = value;
        }

        public boolean matches(Class<?> c) {
            if (c == null) {
                return false;
            }
            return ReflectionMap.classMatches(this.simpleName, this.fullName, c);
        }

        protected FluentMap<String, Object> properties() {
            return CollectionUtils.filteredBeanPropertyMap().a("fullName", this.fullName).a("simpleName", this.simpleName).a("value", this.value);
        }

        public String toString() {
            return Utils.r(this.properties());
        }
    }
}

