/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.juneau.commons.collections.FilteredMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class Maps<K, V> {
    private Map<K, V> map;
    private boolean unmodifiable = false;
    private boolean sparse = false;
    private boolean concurrent = false;
    private boolean ordered = false;
    private Comparator<K> comparator;
    private BiPredicate<K, V> filter;
    private Class<K> keyType;
    private Class<V> valueType;
    private Function<Object, K> keyFunction;
    private Function<Object, V> valueFunction;

    public static <K, V> Maps<K, V> create(Class<K> keyType, Class<V> valueType) {
        return new Maps<K, V>(AssertionUtils.assertArgNotNull("keyType", keyType), AssertionUtils.assertArgNotNull("valueType", valueType));
    }

    public static <K, V> Maps<K, V> create() {
        return new Maps<Object, Object>(Object.class, Object.class);
    }

    public Maps(Class<K> keyType, Class<V> valueType) {
        this.keyType = AssertionUtils.assertArgNotNull("keyType", keyType);
        this.valueType = AssertionUtils.assertArgNotNull("valueType", valueType);
    }

    public Maps<K, V> add(K key, V value) {
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        this.map.put(key, value);
        return this;
    }

    public Maps<K, V> addAll(Map<K, V> value) {
        if (Utils.nn(value)) {
            if (this.map == null) {
                this.map = new LinkedHashMap();
            }
            this.map.putAll(value);
        }
        return this;
    }

    public Maps<K, V> addAny(Object ... values) {
        for (Object o : values) {
            if (!Utils.nn(o)) continue;
            if (o instanceof Map) {
                Map o2 = (Map)o;
                o2.forEach((k, v) -> {
                    K key = this.convertKey(k);
                    V value = this.convertValue(v);
                    this.add(key, value);
                });
                continue;
            }
            throw ThrowableUtils.rex("Object of type {0} could not be converted to type {1}", Utils.cn(o), "Map");
        }
        return this;
    }

    public Maps<K, V> addPairs(Object ... pairs) {
        AssertionUtils.assertArgNotNull("pairs", pairs);
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.illegalArg("Odd number of parameters passed into Maps.addPairs(...)", new Object[0]);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.add(pairs[i], pairs[i + 1]);
        }
        return this;
    }

    public Map<K, V> build() {
        if (this.sparse && Utils.e(this.map)) {
            return null;
        }
        Map<K, V> map2 = null;
        if (this.ordered) {
            map2 = new LinkedHashMap();
            if (this.concurrent) {
                map2 = Collections.synchronizedMap(map2);
            }
        } else if (Utils.nn(this.comparator)) {
            map2 = this.concurrent ? new ConcurrentSkipListMap(this.comparator) : new TreeMap(this.comparator);
        } else {
            Map map = map2 = this.concurrent ? new ConcurrentHashMap() : new HashMap();
        }
        if (Utils.nn(this.filter) || Utils.nn(this.keyFunction) || Utils.nn(this.valueFunction)) {
            FilteredMap.Builder map3b = FilteredMap.create(this.keyType, this.valueType);
            if (Utils.nn(this.filter)) {
                map3b.filter(this.filter);
            }
            if (Utils.nn(this.keyFunction)) {
                map3b.keyFunction(this.keyFunction);
            }
            if (Utils.nn(this.valueFunction)) {
                map3b.valueFunction(this.valueFunction);
            }
            map2 = map3b.inner(map2).build();
        }
        if (Utils.nn(this.map)) {
            map2.putAll(this.map);
        }
        if (this.unmodifiable) {
            map2 = Collections.unmodifiableMap(map2);
        }
        return map2;
    }

    public FluentMap<K, V> buildFluent() {
        Map<K, V> result = this.build();
        return result == null ? null : new FluentMap<K, V>(result);
    }

    public FilteredMap<K, V> buildFiltered() {
        Map<K, V> m = this.build();
        if (m == null) {
            return null;
        }
        if (m instanceof FilteredMap) {
            FilteredMap m2 = (FilteredMap)m;
            return m2;
        }
        return FilteredMap.create(this.keyType, this.valueType).inner(m).build();
    }

    public Maps<K, V> keyFunction(Function<Object, K> keyFunction) {
        this.keyFunction = AssertionUtils.assertArgNotNull("keyFunction", keyFunction);
        return this;
    }

    public Maps<K, V> valueFunction(Function<Object, V> valueFunction) {
        this.valueFunction = AssertionUtils.assertArgNotNull("valueFunction", valueFunction);
        return this;
    }

    public Maps<K, V> functions(Function<Object, K> keyFunction, Function<Object, V> valueFunction) {
        this.keyFunction = AssertionUtils.assertArgNotNull("keyFunction", keyFunction);
        this.valueFunction = AssertionUtils.assertArgNotNull("valueFunction", valueFunction);
        return this;
    }

    public Maps<K, V> filtered() {
        return this.filtered((k, v) -> {
            Collection v3;
            Map v2;
            Number v32;
            Boolean v22;
            return !(v == null || v instanceof Boolean && (v22 = (Boolean)v).equals(false) || v instanceof Number && (v32 = (Number)v).intValue() == -1 || Utils.isArray(v) && Array.getLength(v) == 0 || v instanceof Map && (v2 = (Map)v).isEmpty() || v instanceof Collection && (v3 = (Collection)v).isEmpty());
        });
    }

    public Maps<K, V> filtered(BiPredicate<K, V> filter) {
        BiPredicate<K, V> newFilter = AssertionUtils.assertArgNotNull("filter", filter);
        this.filter = this.filter == null ? newFilter : this.filter.and(newFilter);
        return this;
    }

    public Maps<K, V> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    public Maps<K, V> sorted(Comparator<K> comparator) {
        this.comparator = AssertionUtils.assertArgNotNull("comparator", comparator);
        this.ordered = false;
        return this;
    }

    public Maps<K, V> sparse() {
        this.sparse = true;
        return this;
    }

    public Maps<K, V> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public Maps<K, V> concurrent() {
        this.concurrent = true;
        return this;
    }

    public Maps<K, V> concurrent(boolean value) {
        this.concurrent = value;
        return this;
    }

    public Maps<K, V> ordered() {
        return this.ordered(true);
    }

    public Maps<K, V> ordered(boolean value) {
        this.ordered = value;
        if (this.ordered) {
            this.comparator = null;
        }
        return this;
    }

    private K convertKey(Object o) {
        if (this.keyType.isInstance(o)) {
            return (K)o;
        }
        if (Utils.nn(this.keyFunction)) {
            return this.keyFunction.apply(o);
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to key type {1}", Utils.cn(o), Utils.cn(this.keyType));
    }

    private V convertValue(Object o) {
        if (this.valueType.isInstance(o)) {
            return (V)o;
        }
        if (Utils.nn(this.valueFunction)) {
            return this.valueFunction.apply(o);
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to value type {1}", Utils.cn(o), Utils.cn(this.valueType));
    }
}

