/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.syntax.TripleCollector;

public class QuadAccSink
implements TripleCollector,
Closeable {
    protected Node graphNode = Quad.defaultGraphNodeGenerated;
    private final Sink<Quad> sink;

    public QuadAccSink(Sink<Quad> sink) {
        this.sink = sink;
    }

    protected void check(Triple triple) {
    }

    protected void check(Quad quad) {
    }

    public void setGraph(Node n) {
        this.graphNode = n;
    }

    public Node getGraph() {
        return this.graphNode;
    }

    public void addQuad(Quad quad) {
        this.check(quad);
        this.sink.send((Object)quad);
    }

    @Override
    public void addTriple(Triple triple) {
        this.check(triple);
        this.sink.send((Object)Quad.create(this.graphNode, triple));
    }

    @Override
    public void addTriplePath(TriplePath tPath) {
        throw new UnsupportedOperationException("Can't add paths to quads");
    }

    public void close() {
        this.sink.close();
    }
}

