/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.ContextSupport;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BlockingIterable<T>
implements Iterable<T> {
    private final Multi<? extends T> upstream;
    private final Supplier<Queue<T>> supplier;
    private final int batchSize;
    private final Supplier<Context> contextSupplier;

    public BlockingIterable(Multi<? extends T> upstream, int batchSize, Supplier<Queue<T>> queueSupplier, Supplier<Context> contextSupplier) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
        this.batchSize = ParameterValidation.positive(batchSize, "batchSize");
        this.supplier = ParameterValidation.nonNull(queueSupplier, "queueSupplier");
        this.contextSupplier = ParameterValidation.nonNull(contextSupplier, "contextSupplier");
    }

    @Override
    public Iterator<T> iterator() {
        SubscriberIterator<T> iterator = this.create();
        Flow.Subscriber<? extends T> actual = Infrastructure.onMultiSubscription(this.upstream, iterator);
        this.upstream.subscribe(actual);
        return iterator;
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream().spliterator();
    }

    public Stream<T> stream() {
        SubscriberIterator<T> iterator = this.create();
        Spliterator<T> sp = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream stream = (Stream)StreamSupport.stream(sp, false).onClose(iterator::terminate);
        Flow.Subscriber<? extends T> actual = Infrastructure.onMultiSubscription(this.upstream, iterator);
        Infrastructure.getDefaultExecutor().execute(() -> this.upstream.subscribe(actual));
        return stream;
    }

    private SubscriberIterator<T> create() {
        Queue<T> queue = null;
        try {
            queue = this.supplier.get();
        }
        catch (Throwable e) {
            BlockingIterable.propagateFailure(e);
        }
        if (queue == null) {
            throw new IllegalStateException("The supplier returned `null`");
        }
        Context context = null;
        try {
            context = this.contextSupplier.get();
        }
        catch (Throwable e) {
            BlockingIterable.propagateFailure(e);
        }
        if (context == null) {
            throw new IllegalStateException("The supplier returned `null`");
        }
        return new SubscriberIterator<T>(queue, this.batchSize, context);
    }

    private static void propagateFailure(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    private static final class SubscriberIterator<T>
    implements Flow.Subscriber<T>,
    Iterator<T>,
    ContextSupport {
        private final Queue<T> queue;
        private final int batchSize;
        private final int limit;
        private final Lock lock;
        private final Condition condition;
        private final Context context;
        long produced;
        AtomicReference<Flow.Subscription> subscription = new AtomicReference();
        AtomicBoolean done = new AtomicBoolean();
        Throwable failure;

        SubscriberIterator(Queue<T> queue, int batchSize, Context context) {
            this.queue = queue;
            this.batchSize = batchSize;
            this.limit = batchSize;
            this.context = context;
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            block5: while (true) {
                boolean actualDone = this.done.get();
                boolean empty = this.queue.isEmpty();
                if (actualDone) {
                    Throwable err = this.failure;
                    if (err != null) {
                        BlockingIterable.propagateFailure(err);
                    } else if (empty) {
                        return false;
                    }
                }
                if (!empty) return true;
                if (!Infrastructure.canCallerThreadBeBlocked()) {
                    throw new IllegalStateException("The current thread cannot be blocked: " + Thread.currentThread().getName());
                }
                this.lock.lock();
                try {
                    while (true) {
                        if (this.done.get() || !this.queue.isEmpty()) continue block5;
                        this.condition.await();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.terminateAndFire();
                    BlockingIterable.propagateFailure(e);
                    continue;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                long numberOfProducedItems;
                T v = this.queue.poll();
                if (v == null) {
                    this.terminate();
                    BlockingIterable.propagateFailure(new IllegalArgumentException("`null` is not an accepted value"));
                }
                if ((numberOfProducedItems = this.produced + 1L) == (long)this.limit) {
                    this.produced = 0L;
                    this.subscription.get().request(numberOfProducedItems);
                } else {
                    this.produced = numberOfProducedItems;
                }
                return v;
            }
            throw new NoSuchElementException();
        }

        void fire() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void terminateAndFire() {
            this.terminate();
            this.fire();
        }

        private void terminate() {
            Flow.Subscription s = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (s != null) {
                s.cancel();
            }
        }

        @Override
        public Context context() {
            return this.context;
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.subscription.compareAndSet(null, s)) {
                s.request(this.batchSize);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.subscription.getAndSet(EmptyUniSubscription.CANCELLED).cancel();
                this.onError(new BackPressureFailure("Buffer is full, cannot deliver the item"));
            } else {
                this.fire();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.failure = t;
            this.done.set(true);
            this.fire();
        }

        @Override
        public void onComplete() {
            this.done.set(true);
            this.fire();
        }
    }
}

