/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantSpecificOidcIdentityProvider;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.websockets.next.runtime.spi.security.WebSocketIdentityUpdateRequest;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class WebSocketIdentityUpdateProvider
implements IdentityProvider<WebSocketIdentityUpdateRequest> {
    @Inject
    DefaultTenantConfigResolver resolver;
    @Inject
    BlockingSecurityExecutor blockingExecutor;

    WebSocketIdentityUpdateProvider() {
    }

    public Class<WebSocketIdentityUpdateRequest> getRequestType() {
        return WebSocketIdentityUpdateRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(WebSocketIdentityUpdateRequest request, AuthenticationRequestContext authenticationRequestContext) {
        return this.authenticate(request.getCredential().getToken(), HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request)).onItem().transformToUni(newIdentity -> {
            String sub;
            TokenIntrospection introspection;
            Principal patt0$temp = newIdentity.getPrincipal();
            if (patt0$temp instanceof JsonWebToken) {
                JsonWebToken newJwt = (JsonWebToken)patt0$temp;
                Principal patt1$temp = request.getCurrentSecurityIdentity().getPrincipal();
                if (patt1$temp instanceof JsonWebToken) {
                    JsonWebToken previousJwt = (JsonWebToken)patt1$temp;
                    String currentSubject = newJwt.getSubject();
                    String previousSubject = previousJwt.getSubject();
                    if (currentSubject == null || !currentSubject.equals(previousSubject)) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("JWT token claim 'sub' value '%s' is different to the previous claim value '%s'".formatted(currentSubject, previousSubject)));
                    }
                    return Uni.createFrom().item(newIdentity);
                }
            }
            if ((introspection = (TokenIntrospection)((Object)((Object)OidcUtils.getAttribute(newIdentity, "introspection")))) != null && (sub = introspection.getString("sub")) != null && !sub.isEmpty()) {
                TokenIntrospection previousIntrospection = (TokenIntrospection)((Object)((Object)OidcUtils.getAttribute(request.getCurrentSecurityIdentity(), "introspection")));
                if (previousIntrospection == null || !sub.equals(previousIntrospection.getString("sub"))) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Token introspection result claim 'sub' value '%s' is different to the previous claim value '%s'".formatted(sub, previousIntrospection == null ? null : previousIntrospection.getString("sub"))));
                }
                return Uni.createFrom().item(newIdentity);
            }
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Cannot verify that updated identity represents same subject as the 'sub' claim is not available"));
        });
    }

    private Uni<SecurityIdentity> authenticate(String accessToken, RoutingContext routingContext) {
        OidcTenantConfig tenantConfig = (OidcTenantConfig)routingContext.get(OidcTenantConfig.class.getName());
        if (tenantConfig == null) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Cannot update SecurityIdentity because OIDC tenant wasn't resolved for current WebSocket connection"));
        }
        String tenantId = tenantConfig.tenantId().get();
        TenantSpecificOidcIdentityProvider identityProvider = new TenantSpecificOidcIdentityProvider(tenantId, this.resolver, this.blockingExecutor);
        AccessTokenCredential credential = new AccessTokenCredential(accessToken);
        return identityProvider.authenticate(credential);
    }
}

