/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.enterprise.inject.Instance;
import jakarta.ws.rs.core.SecurityContext;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.credentials.ImmutableCredential;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.IcebergTableLikeEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.TransactionWorkspaceMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntitiesResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.service.catalog.AccessDelegationMode;
import org.apache.polaris.service.catalog.SupportsNotifications;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.catalog.iceberg.CatalogHandlerUtils;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalog;
import org.apache.polaris.service.catalog.iceberg.SupportsCredentialDelegation;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.http.IcebergHttpUtil;
import org.apache.polaris.service.http.IfNoneMatch;
import org.apache.polaris.service.types.NotificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogHandler
extends CatalogHandler
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergCatalogHandler.class);
    private final PolarisMetaStoreManager metaStoreManager;
    private final CallContextCatalogFactory catalogFactory;
    private final ReservedProperties reservedProperties;
    private final CatalogHandlerUtils catalogHandlerUtils;
    private final PolarisEventListener polarisEventListener;
    protected Catalog baseCatalog = null;
    protected SupportsNamespaces namespaceCatalog = null;
    protected ViewCatalog viewCatalog = null;
    public static final String SNAPSHOTS_ALL = "all";
    public static final String SNAPSHOTS_REFS = "refs";

    public IcebergCatalogHandler(PolarisDiagnostics diagnostics, CallContext callContext, ResolutionManifestFactory resolutionManifestFactory, PolarisMetaStoreManager metaStoreManager, UserSecretsManager userSecretsManager, SecurityContext securityContext, CallContextCatalogFactory catalogFactory, String catalogName, PolarisAuthorizer authorizer, ReservedProperties reservedProperties, CatalogHandlerUtils catalogHandlerUtils, Instance<ExternalCatalogFactory> externalCatalogFactories, PolarisEventListener polarisEventListener) {
        super(diagnostics, callContext, resolutionManifestFactory, securityContext, catalogName, authorizer, userSecretsManager, externalCatalogFactories);
        this.metaStoreManager = metaStoreManager;
        this.catalogFactory = catalogFactory;
        this.reservedProperties = reservedProperties;
        this.catalogHandlerUtils = catalogHandlerUtils;
        this.polarisEventListener = polarisEventListener;
    }

    private CatalogEntity getResolvedCatalogEntity() {
        CatalogEntity catalogEntity = this.resolutionManifest.getResolvedCatalogEntity();
        this.diagnostics.checkNotNull((Object)catalogEntity, "No catalog available");
        return catalogEntity;
    }

    public static boolean isCreate(UpdateTableRequest request) {
        boolean isCreate = request.requirements().stream().anyMatch(UpdateRequirement.AssertTableDoesNotExist.class::isInstance);
        if (isCreate) {
            List invalidRequirements = request.requirements().stream().filter(req -> !(req instanceof UpdateRequirement.AssertTableDoesNotExist)).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)invalidRequirements.isEmpty(), (String)"Invalid create requirements: %s", invalidRequirements);
        }
        return isCreate;
    }

    private boolean shouldDecodeToken() {
        return (Boolean)this.realmConfig.getConfig(FeatureConfiguration.LIST_PAGINATION_ENABLED, this.getResolvedCatalogEntity());
    }

    public ListNamespacesResponse listNamespaces(Namespace parent, String pageToken, Integer pageSize) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_NAMESPACES;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof IcebergCatalog) {
            IcebergCatalog polarisCatalog = (IcebergCatalog)catalog;
            PageToken pageRequest = PageToken.build((String)pageToken, (Integer)pageSize, this::shouldDecodeToken);
            Page<Namespace> results = polarisCatalog.listNamespaces(parent, pageRequest);
            return ListNamespacesResponse.builder().addAll((Collection)results.items()).nextPageToken(results.encodedResponseToken()).build();
        }
        return this.catalogHandlerUtils.listNamespaces(this.namespaceCatalog, parent, pageToken, pageSize);
    }

    @Override
    protected void initializeCatalog() {
        CatalogEntity resolvedCatalogEntity = this.getResolvedCatalogEntity();
        ConnectionConfigInfoDpo connectionConfigInfoDpo = resolvedCatalogEntity.getConnectionConfigInfoDpo();
        if (connectionConfigInfoDpo != null) {
            LOGGER.atInfo().addKeyValue("remoteUrl", (Object)connectionConfigInfoDpo.getUri()).log("Initializing federated catalog");
            FeatureConfiguration.enforceFeatureEnabledOrThrow((RealmConfig)this.realmConfig, (FeatureConfiguration)FeatureConfiguration.ENABLE_CATALOG_FEDERATION);
            ConnectionType connectionType = ConnectionType.fromCode((int)connectionConfigInfoDpo.getConnectionTypeCode());
            Instance externalCatalogFactory = this.externalCatalogFactories.select(new Annotation[]{Identifier.Literal.of((String)connectionType.getFactoryIdentifier())});
            if (!externalCatalogFactory.isResolvable()) {
                throw new UnsupportedOperationException("External catalog factory for type '" + String.valueOf(connectionType) + "' is unavailable.");
            }
            Catalog federatedCatalog = ((ExternalCatalogFactory)externalCatalogFactory.get()).createCatalog(connectionConfigInfoDpo, this.getUserSecretsManager());
            this.baseCatalog = federatedCatalog;
        } else {
            LOGGER.atInfo().log("Initializing non-federated catalog");
            this.baseCatalog = this.catalogFactory.createCallContextCatalog(this.callContext, this.polarisPrincipal, this.securityContext, this.resolutionManifest);
        }
        this.namespaceCatalog = this.baseCatalog instanceof SupportsNamespaces ? (SupportsNamespaces)this.baseCatalog : null;
        this.viewCatalog = this.baseCatalog instanceof ViewCatalog ? (ViewCatalog)this.baseCatalog : null;
    }

    public ListNamespacesResponse listNamespaces(Namespace parent) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_NAMESPACES;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        return this.catalogHandlerUtils.listNamespaces(this.namespaceCatalog, parent);
    }

    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_NAMESPACE;
        Namespace namespace = request.namespace();
        if (namespace.isEmpty()) {
            throw new AlreadyExistsException("Cannot create root namespace, as it already exists implicitly.", new Object[0]);
        }
        this.authorizeCreateNamespaceUnderNamespaceOperationOrThrow(op, namespace);
        if (this.namespaceCatalog instanceof IcebergCatalog) {
            this.namespaceCatalog.createNamespace(namespace, this.reservedProperties.removeReservedProperties(request.properties()));
            Map<String, String> filteredProperties = this.reservedProperties.removeReservedProperties(this.resolutionManifest.getPassthroughResolvedPath((Object)namespace).getRawLeafEntity().getPropertiesAsMap());
            return CreateNamespaceResponse.builder().withNamespace(namespace).setProperties(filteredProperties).build();
        }
        return this.catalogHandlerUtils.createNamespace(this.namespaceCatalog, request);
    }

    public GetNamespaceResponse loadNamespaceMetadata(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_NAMESPACE_METADATA;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.loadNamespace(this.namespaceCatalog, namespace);
    }

    public void namespaceExists(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.NAMESPACE_EXISTS;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        this.catalogHandlerUtils.loadNamespace(this.namespaceCatalog, namespace);
    }

    public void dropNamespace(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_NAMESPACE;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        this.catalogHandlerUtils.dropNamespace(this.namespaceCatalog, namespace);
    }

    public UpdateNamespacePropertiesResponse updateNamespaceProperties(Namespace namespace, UpdateNamespacePropertiesRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_NAMESPACE_PROPERTIES;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.updateNamespaceProperties(this.namespaceCatalog, namespace, request);
    }

    public ListTablesResponse listTables(Namespace namespace, String pageToken, Integer pageSize) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_TABLES;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof IcebergCatalog) {
            IcebergCatalog polarisCatalog = (IcebergCatalog)catalog;
            PageToken pageRequest = PageToken.build((String)pageToken, (Integer)pageSize, this::shouldDecodeToken);
            Page<TableIdentifier> results = polarisCatalog.listTables(namespace, pageRequest);
            return ListTablesResponse.builder().addAll((Collection)results.items()).nextPageToken(results.encodedResponseToken()).build();
        }
        return this.catalogHandlerUtils.listTables(this.baseCatalog, namespace, pageToken, pageSize);
    }

    public ListTablesResponse listTables(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_TABLES;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.listTables(this.baseCatalog, namespace);
    }

    public LoadTableResponse createTableDirect(Namespace namespace, CreateTableRequest request) {
        return this.createTableDirect(namespace, request, EnumSet.noneOf(AccessDelegationMode.class), Optional.empty());
    }

    public LoadTableResponse createTableDirectWithWriteDelegation(Namespace namespace, CreateTableRequest request, Optional<String> refreshCredentialsEndpoint) {
        return this.createTableDirect(namespace, request, EnumSet.of(AccessDelegationMode.VENDED_CREDENTIALS), refreshCredentialsEndpoint);
    }

    public void authorizeCreateTableDirect(Namespace namespace, CreateTableRequest request, EnumSet<AccessDelegationMode> delegationModes) {
        if (delegationModes.isEmpty()) {
            TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)request.name());
            this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(PolarisAuthorizableOperation.CREATE_TABLE_DIRECT, identifier);
        } else {
            this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(PolarisAuthorizableOperation.CREATE_TABLE_DIRECT_WITH_WRITE_DELEGATION, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        }
    }

    public LoadTableResponse createTableDirect(Namespace namespace, CreateTableRequest request, EnumSet<AccessDelegationMode> delegationModes, Optional<String> refreshCredentialsEndpoint) {
        this.authorizeCreateTableDirect(namespace, request, delegationModes);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot create table on static-facade external catalogs.", new Object[0]);
        }
        request.validate();
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)request.name());
        if (this.baseCatalog.tableExists(tableIdentifier)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{tableIdentifier});
        }
        HashMap properties = Maps.newHashMap();
        properties.put("created-at", OffsetDateTime.now(ZoneOffset.UTC).toString());
        properties.putAll(this.reservedProperties.removeReservedProperties(request.properties()));
        Table table = this.baseCatalog.buildTable(tableIdentifier, request.schema()).withLocation(request.location()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties((Map)properties).create();
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            TableMetadata tableMetadata = baseTable.operations().current();
            return this.buildLoadTableResponseWithDelegationCredentials(tableIdentifier, tableMetadata, delegationModes, Set.of(PolarisStorageActions.READ, PolarisStorageActions.WRITE, PolarisStorageActions.LIST), refreshCredentialsEndpoint).build();
        }
        if (table instanceof BaseMetadataTable) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{tableIdentifier.toString()});
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    private TableMetadata stageTableCreateHelper(Namespace namespace, CreateTableRequest request) {
        request.validate();
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        if (this.baseCatalog.tableExists(ident)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{ident});
        }
        HashMap properties = Maps.newHashMap();
        properties.put("created-at", OffsetDateTime.now(ZoneOffset.UTC).toString());
        properties.putAll(this.reservedProperties.removeReservedProperties(request.properties()));
        String location = request.location() != null ? (this.baseCatalog instanceof IcebergCatalog ? ((IcebergCatalog)this.baseCatalog).transformTableLikeLocation(ident, request.location()) : request.location()) : this.baseCatalog.buildTable(ident, request.schema()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties((Map)properties).createTransaction().table().location();
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)request.schema(), (PartitionSpec)(request.spec() != null ? request.spec() : PartitionSpec.unpartitioned()), (SortOrder)(request.writeOrder() != null ? request.writeOrder() : SortOrder.unsorted()), (String)location, (Map)properties);
        return metadata;
    }

    public LoadTableResponse createTableStaged(Namespace namespace, CreateTableRequest request) {
        return this.createTableStaged(namespace, request, EnumSet.noneOf(AccessDelegationMode.class), Optional.empty());
    }

    public LoadTableResponse createTableStagedWithWriteDelegation(Namespace namespace, CreateTableRequest request, Optional<String> refreshCredentialsEndpoint) {
        return this.createTableStaged(namespace, request, EnumSet.of(AccessDelegationMode.VENDED_CREDENTIALS), refreshCredentialsEndpoint);
    }

    private void authorizeCreateTableStaged(Namespace namespace, CreateTableRequest request, EnumSet<AccessDelegationMode> delegationModes) {
        if (delegationModes.isEmpty()) {
            this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(PolarisAuthorizableOperation.CREATE_TABLE_STAGED, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        } else {
            this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(PolarisAuthorizableOperation.CREATE_TABLE_STAGED_WITH_WRITE_DELEGATION, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        }
    }

    public LoadTableResponse createTableStaged(Namespace namespace, CreateTableRequest request, EnumSet<AccessDelegationMode> delegationModes, Optional<String> refreshCredentialsEndpoint) {
        this.authorizeCreateTableStaged(namespace, request, delegationModes);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot create table on static-facade external catalogs.", new Object[0]);
        }
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        TableMetadata metadata = this.stageTableCreateHelper(namespace, request);
        return this.buildLoadTableResponseWithDelegationCredentials(ident, metadata, delegationModes, Set.of(PolarisStorageActions.ALL), refreshCredentialsEndpoint).build();
    }

    public LoadTableResponse registerTable(Namespace namespace, RegisterTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REGISTER_TABLE;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        return this.catalogHandlerUtils.registerTable(this.baseCatalog, namespace, request);
    }

    public boolean sendNotification(TableIdentifier identifier, NotificationRequest request) {
        SupportsNotifications notificationCatalog;
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.SEND_NOTIFICATIONS;
        List<TableIdentifier> extraPassthroughTableLikes = List.of(identifier);
        ArrayList<Namespace> extraPassthroughNamespaces = new ArrayList<Namespace>();
        extraPassthroughNamespaces.add(Namespace.empty());
        for (int i = 1; i <= identifier.namespace().length(); ++i) {
            Namespace nsLevel = Namespace.of((String[])((String[])Arrays.stream(identifier.namespace().levels()).limit(i).toArray(String[]::new)));
            extraPassthroughNamespaces.add(nsLevel);
        }
        this.authorizeBasicNamespaceOperationOrThrow(op, Namespace.empty(), extraPassthroughNamespaces, extraPassthroughTableLikes, null);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.getCatalogType().equals((Object)Catalog.TypeEnum.INTERNAL)) {
            LOGGER.atWarn().addKeyValue("catalog", (Object)catalog).addKeyValue("notification", (Object)request).log("Attempted notification on internal catalog");
            throw new BadRequestException("Cannot update internal catalog via notifications", new Object[0]);
        }
        Catalog catalog2 = this.baseCatalog;
        return catalog2 instanceof SupportsNotifications && (notificationCatalog = (SupportsNotifications)catalog2).sendNotification(identifier, request);
    }

    @Nullable
    private IcebergTableLikeEntity getTableEntity(TableIdentifier tableIdentifier) {
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)tableIdentifier);
        PolarisEntity rawLeafEntity = target.getRawLeafEntity();
        if (rawLeafEntity.getType() == PolarisEntityType.TABLE_LIKE) {
            return IcebergTableLikeEntity.of((PolarisBaseEntity)rawLeafEntity);
        }
        return null;
    }

    public LoadTableResponse loadTable(TableIdentifier tableIdentifier, String snapshots) {
        return this.loadTableIfStale(tableIdentifier, null, snapshots).get();
    }

    public Optional<LoadTableResponse> loadTableIfStale(TableIdentifier tableIdentifier, IfNoneMatch ifNoneMatch, String snapshots) {
        return this.loadTable(tableIdentifier, snapshots, ifNoneMatch, EnumSet.noneOf(AccessDelegationMode.class), Optional.empty());
    }

    public LoadTableResponse loadTableWithAccessDelegation(TableIdentifier tableIdentifier, String snapshots, Optional<String> refreshCredentialsEndpoint) {
        return this.loadTableWithAccessDelegationIfStale(tableIdentifier, null, snapshots, refreshCredentialsEndpoint).get();
    }

    public Optional<LoadTableResponse> loadTableWithAccessDelegationIfStale(TableIdentifier tableIdentifier, IfNoneMatch ifNoneMatch, String snapshots, Optional<String> refreshCredentialsEndpoint) {
        return this.loadTable(tableIdentifier, snapshots, ifNoneMatch, EnumSet.of(AccessDelegationMode.VENDED_CREDENTIALS), refreshCredentialsEndpoint);
    }

    private Set<PolarisStorageActions> authorizeLoadTable(TableIdentifier tableIdentifier, EnumSet<AccessDelegationMode> delegationModes) {
        if (delegationModes.isEmpty()) {
            this.authorizeBasicTableLikeOperationOrThrow(PolarisAuthorizableOperation.LOAD_TABLE, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
            return Set.of();
        }
        PolarisAuthorizableOperation read = PolarisAuthorizableOperation.LOAD_TABLE_WITH_READ_DELEGATION;
        PolarisAuthorizableOperation write = PolarisAuthorizableOperation.LOAD_TABLE_WITH_WRITE_DELEGATION;
        HashSet<PolarisStorageActions> actionsRequested = new HashSet<PolarisStorageActions>(Set.of(PolarisStorageActions.READ, PolarisStorageActions.LIST));
        try {
            this.authorizeBasicTableLikeOperationOrThrow(write, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
            actionsRequested.add(PolarisStorageActions.WRITE);
        }
        catch (ForbiddenException e) {
            this.authorizeBasicTableLikeOperationOrThrow(read, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        }
        CatalogEntity catalogEntity = this.getResolvedCatalogEntity();
        LOGGER.info("Catalog type: {}", (Object)catalogEntity.getCatalogType());
        LOGGER.info("allow external catalog credential vending: {}", this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING, catalogEntity));
        if (catalogEntity.getCatalogType().equals((Object)Catalog.TypeEnum.EXTERNAL) && !((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING, catalogEntity)).booleanValue()) {
            throw new ForbiddenException("Access Delegation is not enabled for this catalog. Please consult applicable documentation for the catalog config property '%s' to enable this feature", new Object[]{FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING.catalogConfig()});
        }
        return actionsRequested;
    }

    public Optional<LoadTableResponse> loadTable(TableIdentifier tableIdentifier, String snapshots, IfNoneMatch ifNoneMatch, EnumSet<AccessDelegationMode> delegationModes, Optional<String> refreshCredentialsEndpoint) {
        Table table;
        Set<PolarisStorageActions> actionsRequested = this.authorizeLoadTable(tableIdentifier, delegationModes);
        if (ifNoneMatch != null) {
            IcebergTableLikeEntity tableEntity = this.getTableEntity(tableIdentifier);
            if (tableEntity == null || tableEntity.getMetadataLocation() == null) {
                LOGGER.atWarn().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("tableEntity", (Object)tableEntity).log("Failed to getMetadataLocation to generate ETag when loading table");
            } else {
                String tableETag = IcebergHttpUtil.generateETagForMetadataFileLocation(tableEntity.getMetadataLocation());
                if (ifNoneMatch.anyMatch(tableETag)) {
                    return Optional.empty();
                }
            }
        }
        if ((table = this.baseCatalog.loadTable(tableIdentifier)) instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            TableMetadata tableMetadata = baseTable.operations().current();
            LoadTableResponse response = this.buildLoadTableResponseWithDelegationCredentials(tableIdentifier, tableMetadata, delegationModes, actionsRequested, refreshCredentialsEndpoint).build();
            return Optional.of(this.filterResponseToSnapshots(response, snapshots));
        }
        if (table instanceof BaseMetadataTable) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{tableIdentifier.toString()});
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    private LoadTableResponse.Builder buildLoadTableResponseWithDelegationCredentials(TableIdentifier tableIdentifier, TableMetadata tableMetadata, EnumSet<AccessDelegationMode> delegationModes, Set<PolarisStorageActions> actions, Optional<String> refreshCredentialsEndpoint) {
        LoadTableResponse.Builder responseBuilder = LoadTableResponse.builder().withTableMetadata(tableMetadata);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof SupportsCredentialDelegation) {
            SupportsCredentialDelegation credentialDelegation = (SupportsCredentialDelegation)catalog;
            LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("tableLocation", (Object)tableMetadata.location()).log("Fetching client credentials for table");
            AccessConfig accessConfig = credentialDelegation.getAccessConfig(tableIdentifier, tableMetadata, actions, refreshCredentialsEndpoint);
            Map credentialConfig = accessConfig.credentials();
            if (delegationModes.contains((Object)AccessDelegationMode.VENDED_CREDENTIALS)) {
                if (!credentialConfig.isEmpty()) {
                    responseBuilder.addAllConfig(credentialConfig);
                    responseBuilder.addCredential((Credential)ImmutableCredential.builder().prefix(tableMetadata.location()).config(credentialConfig).build());
                } else {
                    Boolean skipCredIndirection = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.SKIP_CREDENTIAL_SUBSCOPING_INDIRECTION);
                    Preconditions.checkArgument((!accessConfig.supportsCredentialVending() || skipCredIndirection != false ? 1 : 0) != 0, (String)"Credential vending was requested for table %s, but no credentials are available", (Object)tableIdentifier);
                }
            }
            responseBuilder.addAllConfig(accessConfig.extraProperties());
        }
        return responseBuilder;
    }

    private UpdateTableRequest applyUpdateFilters(UpdateTableRequest request) {
        TableIdentifier identifier = request.identifier();
        List requirements = request.requirements();
        List<MetadataUpdate> updates = request.updates().stream().map(update -> {
            if (this.baseCatalog instanceof IcebergCatalog && update instanceof MetadataUpdate.SetLocation) {
                MetadataUpdate.SetLocation setLocation = (MetadataUpdate.SetLocation)update;
                String requestedLocation = setLocation.location();
                String filteredLocation = ((IcebergCatalog)this.baseCatalog).transformTableLikeLocation(identifier, requestedLocation);
                return new MetadataUpdate.SetLocation(filteredLocation);
            }
            return update;
        }).toList();
        return UpdateTableRequest.create((TableIdentifier)identifier, (List)requirements, updates);
    }

    public LoadTableResponse updateTable(TableIdentifier tableIdentifier, UpdateTableRequest request) {
        this.ensureResolutionManifestForTable(tableIdentifier);
        EnumSet<PolarisAuthorizableOperation> authorizableOperations = this.getUpdateTableAuthorizableOperations(request);
        this.authorizeBasicTableLikeOperationsOrThrow(authorizableOperations, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot update table on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.updateTable(this.baseCatalog, tableIdentifier, this.applyUpdateFilters(request));
    }

    public LoadTableResponse updateTableForStagedCreate(TableIdentifier tableIdentifier, UpdateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_TABLE_FOR_STAGED_CREATE;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, tableIdentifier);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot update table on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.updateTable(this.baseCatalog, tableIdentifier, this.applyUpdateFilters(request));
    }

    public void dropTableWithoutPurge(TableIdentifier tableIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_TABLE_WITHOUT_PURGE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        this.catalogHandlerUtils.dropTable(this.baseCatalog, tableIdentifier);
    }

    public void dropTableWithPurge(TableIdentifier tableIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_TABLE_WITH_PURGE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot drop table on static-facade external catalogs.", new Object[0]);
        }
        this.catalogHandlerUtils.purgeTable(this.baseCatalog, tableIdentifier);
    }

    public void tableExists(TableIdentifier tableIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.TABLE_EXISTS;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        this.catalogHandlerUtils.loadTable(this.baseCatalog, tableIdentifier);
    }

    public void renameTable(RenameTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.RENAME_TABLE;
        this.authorizeRenameTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, request.source(), request.destination());
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot rename table on static-facade external catalogs.", new Object[0]);
        }
        this.catalogHandlerUtils.renameTable(this.baseCatalog, request);
    }

    public void commitTransaction(CommitTransactionRequest commitTransactionRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.COMMIT_TRANSACTION;
        this.authorizeCollectionOfTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, commitTransactionRequest.tableChanges().stream().map(UpdateTableRequest::identifier).toList());
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot update table on static-facade external catalogs.", new Object[0]);
        }
        if (!(this.baseCatalog instanceof IcebergCatalog)) {
            throw new BadRequestException("Unsupported operation: commitTransaction with baseCatalog type: %s", new Object[]{this.baseCatalog.getClass().getName()});
        }
        TransactionWorkspaceMetaStoreManager transactionMetaStoreManager = new TransactionWorkspaceMetaStoreManager(this.diagnostics, this.metaStoreManager);
        ((IcebergCatalog)this.baseCatalog).setMetaStoreManager((PolarisMetaStoreManager)transactionMetaStoreManager);
        commitTransactionRequest.tableChanges().stream().forEach(change -> {
            Table table = this.baseCatalog.loadTable(change.identifier());
            if (!(table instanceof BaseTable)) {
                throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
            }
            BaseTable baseTable = (BaseTable)table;
            if (IcebergCatalogHandler.isCreate(change)) {
                throw new BadRequestException("Unsupported operation: commitTranaction with updateForStagedCreate: %s", new Object[]{change});
            }
            TableOperations tableOps = baseTable.operations();
            TableMetadata currentMetadata = tableOps.current();
            change.requirements().forEach(requirement -> requirement.validate(currentMetadata));
            TableMetadata.Builder metadataBuilder = TableMetadata.buildFrom((TableMetadata)currentMetadata);
            change.updates().stream().forEach(singleUpdate -> {
                if (singleUpdate instanceof MetadataUpdate.SetLocation) {
                    MetadataUpdate.SetLocation setLocation = (MetadataUpdate.SetLocation)singleUpdate;
                    if (!currentMetadata.location().equals(setLocation.location()) && !((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_NAMESPACE_LOCATION_OVERLAP)).booleanValue()) {
                        throw new BadRequestException("Unsupported operation: commitTransaction containing SetLocation for table '%s' and new location '%s'", new Object[]{change.identifier(), ((MetadataUpdate.SetLocation)singleUpdate).location()});
                    }
                }
                singleUpdate.applyTo(metadataBuilder);
            });
            TableMetadata updatedMetadata = metadataBuilder.build();
            if (!updatedMetadata.changes().isEmpty()) {
                tableOps.commit(currentMetadata, updatedMetadata);
            }
        });
        List pendingUpdates = transactionMetaStoreManager.getPendingUpdates();
        EntitiesResult result = this.metaStoreManager.updateEntitiesPropertiesIfNotChanged(this.callContext.getPolarisCallContext(), pendingUpdates);
        if (!result.isSuccess()) {
            throw new CommitFailedException("Transaction commit failed with status: %s, extraInfo: %s", new Object[]{result.getReturnStatus(), result.getExtraInformation()});
        }
    }

    public ListTablesResponse listViews(Namespace namespace, String pageToken, Integer pageSize) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_VIEWS;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof IcebergCatalog) {
            IcebergCatalog polarisCatalog = (IcebergCatalog)catalog;
            PageToken pageRequest = PageToken.build((String)pageToken, (Integer)pageSize, this::shouldDecodeToken);
            Page<TableIdentifier> results = polarisCatalog.listViews(namespace, pageRequest);
            return ListTablesResponse.builder().addAll((Collection)results.items()).nextPageToken(results.encodedResponseToken()).build();
        }
        catalog = this.baseCatalog;
        if (catalog instanceof ViewCatalog) {
            ViewCatalog viewCatalog = (ViewCatalog)catalog;
            return this.catalogHandlerUtils.listViews(viewCatalog, namespace, pageToken, pageSize);
        }
        throw new BadRequestException("Unsupported operation: listViews with baseCatalog type: %s", new Object[]{this.baseCatalog.getClass().getName()});
    }

    public ListTablesResponse listViews(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_VIEWS;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.listViews(this.viewCatalog, namespace);
    }

    public LoadViewResponse createView(Namespace namespace, CreateViewRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_VIEW;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot create view on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.createView(this.viewCatalog, namespace, request);
    }

    public LoadViewResponse loadView(TableIdentifier viewIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_VIEW;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        return this.catalogHandlerUtils.loadView(this.viewCatalog, viewIdentifier);
    }

    public LoadViewResponse replaceView(TableIdentifier viewIdentifier, UpdateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REPLACE_VIEW;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot replace view on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.updateView(this.viewCatalog, viewIdentifier, this.applyUpdateFilters(request));
    }

    public void dropView(TableIdentifier viewIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_VIEW;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        this.catalogHandlerUtils.dropView(this.viewCatalog, viewIdentifier);
    }

    public void viewExists(TableIdentifier viewIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.VIEW_EXISTS;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        this.catalogHandlerUtils.loadView(this.viewCatalog, viewIdentifier);
    }

    public void renameView(RenameTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.RENAME_VIEW;
        this.authorizeRenameTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, request.source(), request.destination());
        CatalogEntity catalog = this.getResolvedCatalogEntity();
        if (catalog.isStaticFacade()) {
            throw new BadRequestException("Cannot rename view on static-facade external catalogs.", new Object[0]);
        }
        this.catalogHandlerUtils.renameView(this.viewCatalog, request);
    }

    @Nonnull
    private LoadTableResponse filterResponseToSnapshots(LoadTableResponse loadTableResponse, String snapshots) {
        if (snapshots == null || snapshots.equalsIgnoreCase(SNAPSHOTS_ALL)) {
            return loadTableResponse;
        }
        if (snapshots.equalsIgnoreCase(SNAPSHOTS_REFS)) {
            TableMetadata metadata = loadTableResponse.tableMetadata();
            Set referencedSnapshotIds = metadata.refs().values().stream().map(SnapshotRef::snapshotId).collect(Collectors.toSet());
            TableMetadata filteredMetadata = metadata.removeSnapshotsIf(s -> !referencedSnapshotIds.contains(s.snapshotId()));
            return LoadTableResponse.builder().withTableMetadata(filteredMetadata).addAllConfig(loadTableResponse.config()).addAllCredentials(loadTableResponse.credentials()).build();
        }
        throw new IllegalArgumentException("Unrecognized snapshots: " + snapshots);
    }

    private EnumSet<PolarisAuthorizableOperation> getUpdateTableAuthorizableOperations(UpdateTableRequest request) {
        boolean useFineGrainedOperations = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ENABLE_FINE_GRAINED_UPDATE_TABLE_PRIVILEGES, this.getResolvedCatalogEntity());
        if (useFineGrainedOperations) {
            EnumSet actions = request.updates().stream().map(update -> {
                MetadataUpdate metadataUpdate = update;
                Objects.requireNonNull(metadataUpdate);
                MetadataUpdate selector0$temp = metadataUpdate;
                int index$1 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetadataUpdate.AssignUUID.class, MetadataUpdate.UpgradeFormatVersion.class, MetadataUpdate.AddSchema.class, MetadataUpdate.SetCurrentSchema.class, MetadataUpdate.AddPartitionSpec.class, MetadataUpdate.AddSortOrder.class, MetadataUpdate.SetDefaultSortOrder.class, MetadataUpdate.AddSnapshot.class, MetadataUpdate.SetSnapshotRef.class, MetadataUpdate.RemoveSnapshots.class, MetadataUpdate.RemoveSnapshotRef.class, MetadataUpdate.SetLocation.class, MetadataUpdate.SetProperties.class, MetadataUpdate.RemoveProperties.class, MetadataUpdate.SetStatistics.class, MetadataUpdate.RemoveStatistics.class, MetadataUpdate.RemovePartitionSpecs.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        MetadataUpdate.AssignUUID assignUuid = (MetadataUpdate.AssignUUID)selector0$temp;
                        yield PolarisAuthorizableOperation.ASSIGN_TABLE_UUID;
                    }
                    case 1 -> {
                        MetadataUpdate.UpgradeFormatVersion upgradeFormat = (MetadataUpdate.UpgradeFormatVersion)selector0$temp;
                        yield PolarisAuthorizableOperation.UPGRADE_TABLE_FORMAT_VERSION;
                    }
                    case 2 -> {
                        MetadataUpdate.AddSchema addSchema = (MetadataUpdate.AddSchema)selector0$temp;
                        yield PolarisAuthorizableOperation.ADD_TABLE_SCHEMA;
                    }
                    case 3 -> {
                        MetadataUpdate.SetCurrentSchema setCurrentSchema = (MetadataUpdate.SetCurrentSchema)selector0$temp;
                        yield PolarisAuthorizableOperation.SET_TABLE_CURRENT_SCHEMA;
                    }
                    case 4 -> {
                        MetadataUpdate.AddPartitionSpec addPartitionSpec = (MetadataUpdate.AddPartitionSpec)selector0$temp;
                        yield PolarisAuthorizableOperation.ADD_TABLE_PARTITION_SPEC;
                    }
                    case 5 -> {
                        MetadataUpdate.AddSortOrder addSortOrder = (MetadataUpdate.AddSortOrder)selector0$temp;
                        yield PolarisAuthorizableOperation.ADD_TABLE_SORT_ORDER;
                    }
                    case 6 -> {
                        MetadataUpdate.SetDefaultSortOrder setDefaultSortOrder = (MetadataUpdate.SetDefaultSortOrder)selector0$temp;
                        yield PolarisAuthorizableOperation.SET_TABLE_DEFAULT_SORT_ORDER;
                    }
                    case 7 -> {
                        MetadataUpdate.AddSnapshot addSnapshot = (MetadataUpdate.AddSnapshot)selector0$temp;
                        yield PolarisAuthorizableOperation.ADD_TABLE_SNAPSHOT;
                    }
                    case 8 -> {
                        MetadataUpdate.SetSnapshotRef setSnapshotRef = (MetadataUpdate.SetSnapshotRef)selector0$temp;
                        yield PolarisAuthorizableOperation.SET_TABLE_SNAPSHOT_REF;
                    }
                    case 9 -> {
                        MetadataUpdate.RemoveSnapshots removeSnapshots = (MetadataUpdate.RemoveSnapshots)selector0$temp;
                        yield PolarisAuthorizableOperation.REMOVE_TABLE_SNAPSHOTS;
                    }
                    case 10 -> {
                        MetadataUpdate.RemoveSnapshotRef removeSnapshotRef = (MetadataUpdate.RemoveSnapshotRef)selector0$temp;
                        yield PolarisAuthorizableOperation.REMOVE_TABLE_SNAPSHOT_REF;
                    }
                    case 11 -> {
                        MetadataUpdate.SetLocation setLocation = (MetadataUpdate.SetLocation)selector0$temp;
                        yield PolarisAuthorizableOperation.SET_TABLE_LOCATION;
                    }
                    case 12 -> {
                        MetadataUpdate.SetProperties setProperties = (MetadataUpdate.SetProperties)selector0$temp;
                        yield PolarisAuthorizableOperation.SET_TABLE_PROPERTIES;
                    }
                    case 13 -> {
                        MetadataUpdate.RemoveProperties removeProperties = (MetadataUpdate.RemoveProperties)selector0$temp;
                        yield PolarisAuthorizableOperation.REMOVE_TABLE_PROPERTIES;
                    }
                    case 14 -> {
                        MetadataUpdate.SetStatistics setStatistics = (MetadataUpdate.SetStatistics)selector0$temp;
                        yield PolarisAuthorizableOperation.SET_TABLE_STATISTICS;
                    }
                    case 15 -> {
                        MetadataUpdate.RemoveStatistics removeStatistics = (MetadataUpdate.RemoveStatistics)selector0$temp;
                        yield PolarisAuthorizableOperation.REMOVE_TABLE_STATISTICS;
                    }
                    case 16 -> {
                        MetadataUpdate.RemovePartitionSpecs removePartitionSpecs = (MetadataUpdate.RemovePartitionSpecs)selector0$temp;
                        yield PolarisAuthorizableOperation.REMOVE_TABLE_PARTITION_SPECS;
                    }
                    default -> PolarisAuthorizableOperation.UPDATE_TABLE;
                };
            }).collect(() -> EnumSet.noneOf(PolarisAuthorizableOperation.class), AbstractCollection::add, AbstractCollection::addAll);
            if (actions.isEmpty()) {
                actions.add(PolarisAuthorizableOperation.UPDATE_TABLE);
            }
            return actions;
        }
        return EnumSet.of(PolarisAuthorizableOperation.UPDATE_TABLE);
    }

    @Override
    public void close() throws Exception {
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof Closeable) {
            Closeable closeable = (Closeable)catalog;
            closeable.close();
        }
    }
}

