/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.auth.AuthenticationConfiguration;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;
import org.apache.polaris.service.auth.internal.broker.KeyProvider;
import org.apache.polaris.service.auth.internal.broker.LocalRSAKeyProvider;
import org.apache.polaris.service.auth.internal.broker.PemUtils;
import org.apache.polaris.service.auth.internal.broker.RSAKeyPairJWTBroker;
import org.apache.polaris.service.auth.internal.broker.TokenBroker;
import org.apache.polaris.service.auth.internal.broker.TokenBrokerFactory;

@ApplicationScoped
@Identifier(value="rsa-key-pair")
public class RSAKeyPairJWTBrokerFactory
implements TokenBrokerFactory {
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final ConcurrentMap<String, RSAKeyPairJWTBroker> tokenBrokers = new ConcurrentHashMap<String, RSAKeyPairJWTBroker>();

    @Inject
    public RSAKeyPairJWTBrokerFactory(MetaStoreManagerFactory metaStoreManagerFactory, AuthenticationConfiguration authenticationConfiguration) {
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    @Override
    public TokenBroker apply(RealmContext realmContext) {
        return this.tokenBrokers.computeIfAbsent(realmContext.getRealmIdentifier(), k -> this.createTokenBroker(realmContext));
    }

    private RSAKeyPairJWTBroker createTokenBroker(RealmContext realmContext) {
        AuthenticationRealmConfiguration config = this.authenticationConfiguration.forRealm(realmContext);
        Duration maxTokenGeneration = config.tokenBroker().maxTokenGeneration();
        KeyProvider keyProvider = config.tokenBroker().rsaKeyPair().map(this::fileSystemKeyPair).orElseGet(this::generateEphemeralKeyPair);
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
        return new RSAKeyPairJWTBroker(metaStoreManager, (int)maxTokenGeneration.toSeconds(), keyProvider);
    }

    private KeyProvider fileSystemKeyPair(AuthenticationRealmConfiguration.TokenBrokerConfiguration.RSAKeyPairConfiguration config) {
        return LocalRSAKeyProvider.fromFiles(config.publicKeyFile(), config.privateKeyFile());
    }

    private KeyProvider generateEphemeralKeyPair() {
        try {
            return new LocalRSAKeyProvider(PemUtils.generateKeyPair());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

