/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.bifromq.mqtt.handler.ProxyProtocolHandler;

public class ProxyProtocolDetector
extends ByteToMessageDecoder {
    private static final byte[] PPV1_SIG = "PROXY ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] PPV2_SIG = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final int LEN = Math.max(PPV2_SIG.length + 4, PPV1_SIG.length);
    private boolean finished = false;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        super.channelRead(ctx, msg);
        if (this.finished) {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int readable = in.readableBytes();
        int readerIndex = in.readerIndex();
        if (readable < LEN) {
            return;
        }
        boolean isV2 = true;
        for (int i = 0; i < PPV2_SIG.length; ++i) {
            if (in.getByte(readerIndex + i) == PPV2_SIG[i]) continue;
            isV2 = false;
            break;
        }
        if (isV2) {
            byte verCmd = in.getByte(readerIndex + 12);
            if ((verCmd & 0xF0) == 32) {
                ByteBuf buf = in.readRetainedSlice(readable);
                out.add(buf);
                this.finished = true;
                return;
            }
        } else {
            boolean isV1 = true;
            for (int i = 0; i < PPV1_SIG.length; ++i) {
                if (in.getByte(readerIndex + i) == PPV1_SIG[i]) continue;
                isV1 = false;
                break;
            }
            if (isV1) {
                ByteBuf buf = in.readRetainedSlice(readable);
                out.add(buf);
                this.finished = true;
                return;
            }
        }
        ctx.pipeline().remove(HAProxyMessageDecoder.class);
        ctx.pipeline().remove(ProxyProtocolHandler.class);
        ByteBuf buf = in.readRetainedSlice(readable);
        out.add(buf);
        this.finished = true;
    }
}

