/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.server;

import com.google.common.collect.Sets;
import io.grpc.stub.StreamObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.baserpc.server.AckStream;
import org.apache.bifromq.sessiondict.rpc.proto.Quit;
import org.apache.bifromq.sessiondict.rpc.proto.ServerRedirection;
import org.apache.bifromq.sessiondict.rpc.proto.Session;
import org.apache.bifromq.sessiondict.server.ISessionRegister;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionRegister
extends AckStream<Session, Quit>
implements ISessionRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionRegister.class);
    private final Set<ClientInfo> sessionOwners = Sets.newConcurrentHashSet();
    private final ISessionRegister.IRegistrationListener regListener;
    private final Disposable disposable;

    SessionRegister(ISessionRegister.IRegistrationListener listener, StreamObserver<Quit> responseObserver) {
        super(responseObserver);
        this.regListener = listener;
        this.disposable = this.ack().doFinally(() -> {
            log.debug("SessionRegister@{} closed: sessions={}", (Object)this.hashCode(), (Object)this.sessionOwners.size());
            this.sessionOwners.forEach(sessionOwner -> this.regListener.on((ClientInfo)sessionOwner, false, this));
        }).subscribe(session -> {
            ClientInfo owner = session.getOwner();
            String tenantId = owner.getTenantId();
            assert (this.tenantId.equals(tenantId));
            if (session.getKeep()) {
                if (this.sessionOwners.add(owner)) {
                    listener.on(owner, true, this);
                }
            } else if (this.sessionOwners.remove(owner)) {
                listener.on(owner, false, this);
            }
        });
        log.debug("SessionRegister@{} created", (Object)this.hashCode());
    }

    @Override
    public void kick(String tenantId, ClientInfo sessionOwner, ClientInfo kicker, ServerRedirection serverRedirection) {
        if (this.sessionOwners.remove(sessionOwner)) {
            this.send(Quit.newBuilder().setReqId(System.nanoTime()).setOwner(sessionOwner).setKiller(kicker).setServerRedirection(serverRedirection).build());
            this.regListener.on(sessionOwner, false, this);
        }
    }

    public void close() {
        super.close();
        this.disposable.dispose();
    }
}

