/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RandomUtils {
    public static <T> List<T> uniqueRandomPickAtMost(List<T> list, int max, Predicate<T> predicate) {
        int n = list.size();
        if (n <= max) {
            return list.stream().filter(predicate).collect(Collectors.toList());
        }
        HashMap<Integer, Integer> hash = new HashMap<Integer, Integer>(2 * max);
        int[] offsets = new int[max];
        for (int i = 0; i < max; ++i) {
            int j = i + ThreadLocalRandom.current().nextInt(n - i);
            int n2 = offsets[i] = hash.containsKey(j) ? (Integer)hash.remove(j) : j;
            if (j <= i) continue;
            hash.put(j, hash.containsKey(i) ? (Integer)hash.remove(i) : i);
        }
        ArrayList<T> randSelected = new ArrayList<T>();
        for (int i : offsets) {
            T peer = list.get(i);
            if (!predicate.test(peer)) continue;
            randSelected.add(peer);
        }
        return randSelected;
    }
}

