/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import java.net.URI;
import java.util.EnumMap;
import lombok.Generated;
import org.apache.bifromq.demo.plugin.WebHookBasedSettingProvider;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DemoSettingProvider
implements ISettingProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DemoSettingProvider.class);
    private static final String PLUGIN_RESOURCE_THROTTLER_URL = "plugin.settingprovider.url";
    private final EnumMap<Setting, Object> initialValues = new EnumMap(Setting.class);
    private final ISettingProvider delegate;

    public DemoSettingProvider() {
        Object delegate1;
        String webhookUrl = System.getProperty(PLUGIN_RESOURCE_THROTTLER_URL);
        for (Setting setting : Setting.values()) {
            this.initialValues.put(setting, setting.current("DevOnly"));
        }
        if (webhookUrl == null) {
            log.info("No webhook url specified, fallback to dev only setting provider.");
            delegate1 = new ISettingProvider(){

                public <R> R provide(Setting setting, String tenantId) {
                    return (R)DemoSettingProvider.this.initialValues.get(setting);
                }
            };
        } else {
            try {
                URI webhookURI = URI.create(webhookUrl);
                delegate1 = new WebHookBasedSettingProvider(webhookURI);
                log.info("DemoSettingProvider's webhook URL: {}", (Object)webhookUrl);
            }
            catch (Throwable e) {
                delegate1 = new ISettingProvider(){

                    public <R> R provide(Setting setting, String tenantId) {
                        return (R)DemoSettingProvider.this.initialValues.get(setting);
                    }
                };
            }
        }
        this.delegate = delegate1;
    }

    public <R> R provide(Setting setting, String tenantId) {
        return (R)this.delegate.provide(setting, tenantId);
    }
}

