/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.PrimaryQualifier;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

final class DefaultRuntimeBeanDefinition<T>
extends AbstractBeanContextConditional
implements RuntimeBeanDefinition<T> {
    private static final AtomicInteger REF_COUNT = new AtomicInteger(0);
    private final Argument<T> beanType;
    private final Supplier<T> supplier;
    private final AnnotationMetadata annotationMetadata;
    private final String beanName;
    private final Qualifier<T> qualifier;
    private final boolean isSingleton;
    private final Class<? extends Annotation> scope;
    private final Class<?>[] exposedTypes;

    DefaultRuntimeBeanDefinition(@NonNull Argument<T> beanType, @NonNull Supplier<T> supplier, @Nullable Qualifier<T> qualifier, @Nullable AnnotationMetadata annotationMetadata, boolean isSingleton, @Nullable Class<? extends Annotation> scope, Class<?>[] exposedTypes) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Objects.requireNonNull(supplier, "Bean supplier cannot be null");
        this.beanType = beanType;
        this.supplier = supplier;
        this.beanName = DefaultRuntimeBeanDefinition.generateBeanName(beanType.getType());
        this.qualifier = qualifier;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.isSingleton = isSingleton;
        this.scope = scope;
        this.exposedTypes = exposedTypes;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    @NonNull
    public Set<Class<?>> getExposedTypes() {
        return ArrayUtils.isNotEmpty((Object[])this.exposedTypes) ? CollectionUtils.setOf((Object[])this.exposedTypes) : RuntimeBeanDefinition.super.getExposedTypes();
    }

    @Override
    public Optional<Class<? extends Annotation>> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    public Optional<String> getScopeName() {
        return this.getScope().map(Class::getName);
    }

    @Override
    @NonNull
    public Argument<T> asArgument() {
        return this.beanType;
    }

    @Override
    public boolean isPrimary() {
        return this.qualifier == PrimaryQualifier.INSTANCE || RuntimeBeanDefinition.super.isPrimary();
    }

    @Override
    public Qualifier<T> getDeclaredQualifier() {
        return this.qualifier != null ? this.qualifier : RuntimeBeanDefinition.super.getDeclaredQualifier();
    }

    @Override
    public Qualifier<T> resolveDynamicQualifier() {
        return this.qualifier;
    }

    static String generateBeanName(@NonNull Class<?> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return beanType.getName() + "$DynamicDefinition" + REF_COUNT.incrementAndGet();
    }

    @Override
    public String getBeanDefinitionName() {
        return this.beanName;
    }

    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public BeanDefinition<T> load() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType.getType();
    }

    @Override
    @NonNull
    public List<Argument<?>> getTypeArguments() {
        return Arrays.asList(this.beanType.getTypeParameters());
    }

    @Override
    @NonNull
    public Class<?>[] getTypeParameters() {
        return (Class[])this.getTypeArguments().stream().map(TypeInformation::getType).toArray(Class[]::new);
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public T build(BeanResolutionContext resolutionContext, BeanContext context, BeanDefinition<T> definition) throws BeanInstantiationException {
        return this.supplier.get();
    }

    static final class RuntimeBeanBuilder<B>
    implements RuntimeBeanDefinition.Builder<B> {
        private final Argument<B> beanType;
        private final Supplier<B> supplier;
        private Qualifier<B> qualifier;
        private boolean singleton;
        private AnnotationMetadata annotationMetadata;
        private Class<? extends Annotation> scope;
        private Class<?>[] exposedTypes = ReflectionUtils.EMPTY_CLASS_ARRAY;

        RuntimeBeanBuilder(Argument<B> beanType, Supplier<B> supplier) {
            this.beanType = Objects.requireNonNull(beanType, "Bean type cannot be null");
            this.supplier = Objects.requireNonNull(supplier, "Bean supplier cannot be null");
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> qualifier(Qualifier<B> qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> scope(Class<? extends Annotation> scope) {
            this.scope = scope;
            if (scope != null && scope.getSimpleName().equals("Singleton")) {
                this.singleton = true;
            }
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> singleton(boolean isSingleton) {
            this.singleton = true;
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> exposedTypes(Class<?> ... types) {
            for (Class<?> type : types) {
                if (type.isAssignableFrom(this.beanType.getType())) continue;
                throw new IllegalArgumentException("Bean type doesn't implement: " + type.getName());
            }
            this.exposedTypes = types;
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> annotationMetadata(AnnotationMetadata annotationMetadata) {
            this.annotationMetadata = annotationMetadata;
            return this;
        }

        @Override
        @NonNull
        public RuntimeBeanDefinition<B> build() {
            return new DefaultRuntimeBeanDefinition<B>(this.beanType, this.supplier, this.qualifier, this.annotationMetadata, this.singleton, this.scope, this.exposedTypes);
        }
    }
}

