/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.metastorage.dsl.ConditionType;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.SimpleConditionBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class SimpleConditionDeserializer
implements MessageDeserializer<SimpleCondition> {
    private final SimpleConditionBuilder msg;

    SimpleConditionDeserializer(MetaStorageMessagesFactory messageFactory) {
        this.msg = messageFactory.simpleCondition();
    }

    public Class<SimpleCondition> klass() {
        return SimpleCondition.class;
    }

    public SimpleCondition getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.key(tmp);
                reader.incrementState();
            }
            case 1: {
                int shiftedId = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                ConditionType tmp = shiftedId == 0 ? null : ConditionType.fromId(shiftedId - 1);
                this.msg.type(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SimpleCondition.class);
    }
}

