/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.logger;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.flink.agents.api.logger.EventLogger;
import org.apache.flink.agents.api.logger.EventLoggerConfig;

public final class EventLoggerFactory {
    private static final Map<String, Function<EventLoggerConfig, EventLogger>> FACTORIES = new ConcurrentHashMap<String, Function<EventLoggerConfig, EventLogger>>();

    private EventLoggerFactory() {
    }

    public static EventLogger createLogger(EventLoggerConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("EventLoggerConfig cannot be null");
        }
        String loggerType = config.getLoggerType();
        if (loggerType == null || loggerType.trim().isEmpty()) {
            throw new IllegalArgumentException("Logger type cannot be null or empty");
        }
        Function<EventLoggerConfig, EventLogger> factory = FACTORIES.get(loggerType);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("No factory registered for logger type: '%s'. Available types: %s. Use EventLoggerFactory.registerFactory() to register custom loggers.", loggerType, FACTORIES.keySet()));
        }
        try {
            return factory.apply(config);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create EventLogger for logger type: " + loggerType, e);
        }
    }

    public static void registerFactory(String loggerType, Function<EventLoggerConfig, EventLogger> factory) {
        if (loggerType == null || loggerType.trim().isEmpty()) {
            throw new IllegalArgumentException("Logger type cannot be null or empty");
        }
        Objects.requireNonNull(factory, "Factory function cannot be null");
        FACTORIES.put(loggerType.trim(), factory);
    }

    private static void registerBuiltInFactories() {
        EventLoggerFactory.registerFileEventLoggerFactory();
    }

    private static void registerFileEventLoggerFactory() {
        try {
            Class<?> fileLoggerClass = Class.forName("org.apache.flink.agents.runtime.eventlog.FileEventLogger");
            EventLoggerFactory.registerFactory("file", config -> {
                try {
                    return (EventLogger)fileLoggerClass.getConstructor(EventLoggerConfig.class).newInstance(config);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create FileEventLogger", e);
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static {
        EventLoggerFactory.registerBuiltInFactories();
    }
}

