/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.felix.http.base.internal.handler.FilterConfigImpl;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.PreprocessorInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.servlet.whiteboard.Preprocessor;

public class PreprocessorHandler
implements Comparable<PreprocessorHandler> {
    private final PreprocessorInfo info;
    private final ServletContext context;
    private final BundleContext bundleContext;
    private volatile Preprocessor preprocessor;

    public PreprocessorHandler(BundleContext bundleContext, ServletContext context, PreprocessorInfo info) {
        this.bundleContext = bundleContext;
        this.context = context;
        this.info = info;
    }

    @Override
    public int compareTo(PreprocessorHandler other) {
        return this.info.compareTo(other.info);
    }

    public ServletContext getContext() {
        return this.context;
    }

    public PreprocessorInfo getPreprocessorInfo() {
        return this.info;
    }

    public int init() {
        this.preprocessor = (Preprocessor)this.getPreprocessorInfo().getService(this.bundleContext);
        if (this.preprocessor == null) {
            return 5;
        }
        try {
            this.preprocessor.init(new FilterConfigImpl(this.preprocessor.getClass().getName(), this.getContext(), this.getPreprocessorInfo().getInitParameters()));
        }
        catch (Exception e) {
            SystemLogger.LOGGER.error(SystemLogger.formatMessage(this.getPreprocessorInfo().getServiceReference(), "Error during calling init() on preprocessor ".concat(this.info.getClassName(this.preprocessor))), (Throwable)e);
            this.getPreprocessorInfo().ungetService(this.bundleContext, this.preprocessor);
            this.preprocessor = null;
            return 4;
        }
        return -1;
    }

    public boolean destroy() {
        if (this.preprocessor == null) {
            return false;
        }
        try {
            this.preprocessor.destroy();
        }
        catch (Exception ignore) {
            SystemLogger.LOGGER.error(SystemLogger.formatMessage(this.getPreprocessorInfo().getServiceReference(), "Error during calling destroy() on preprocessor ".concat(this.info.getClassName(this.preprocessor))), (Throwable)ignore);
        }
        this.getPreprocessorInfo().ungetService(this.bundleContext, this.preprocessor);
        this.preprocessor = null;
        return true;
    }

    public void handle(@NotNull ServletRequest req, @NotNull ServletResponse res, @NotNull FilterChain chain) throws ServletException, IOException {
        Preprocessor local = this.preprocessor;
        if (local == null) {
            throw new ServletException("Preprocessor has been unregistered");
        }
        local.doFilter(req, res, chain);
    }

    public boolean dispose() {
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.info.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PreprocessorHandler other = (PreprocessorHandler)obj;
        return this.info.equals(other.info);
    }
}

