/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.commands;

import java.util.List;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckExecutor;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.CompositeResult;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={HealthCheckExecCommand.class}, property={"osgi.command.scope=hc", "osgi.command.function=exec"})
public class HealthCheckExecCommand {
    @Reference
    HealthCheckExecutor healthCheckExecutor;
    @Reference
    ResultTxtVerboseSerializer resultTxtVerboseSerializer;

    public String exec(String ... params) {
        boolean isDebug = false;
        boolean combineWithOr = true;
        boolean isName = false;
        HealthCheckSelector selector = HealthCheckSelector.empty();
        for (String param : params) {
            if (param.startsWith("-")) {
                if ("-v".equals(param)) {
                    isDebug = true;
                    continue;
                }
                if ("-a".equals(param)) {
                    combineWithOr = false;
                    continue;
                }
                if ("-n".equals(param)) {
                    isName = true;
                    continue;
                }
                if ("-h".equals(param)) {
                    return this.getHelpText();
                }
                System.out.println("unrecognized option: " + param);
                continue;
            }
            selector = isName ? selector.withNames(param.split(",")) : selector.withTags(param.split(","));
        }
        boolean defaultTagUsed = selector.tags() == null && selector.names() == null;
        HealthCheckExecutionOptions options = new HealthCheckExecutionOptions();
        options.setCombineTagsWithOr(combineWithOr);
        List executionResult = this.healthCheckExecutor.execute(selector, options);
        String result = this.resultTxtVerboseSerializer.serialize(new CompositeResult((ResultLog)new FormattingResultLog(), executionResult), (List<HealthCheckExecutionResult>)executionResult, isDebug);
        return (defaultTagUsed ? "Configured default tag used for execution\n" : "") + result;
    }

    private String getHelpText() {
        return "Usage:\n  hc:exec [-v] [-a] [tag1,tag2] [-n \"Name 1,Name 2\"]\n  -v verbose/debug\n  -a combine tags with 'and' logic\n  -n name(s) to be executed";
    }
}

