/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.memoryleaktests;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.MappedPropertyDescriptor;
import org.apache.commons.beanutils2.MethodUtils;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.WrapDynaBean;
import org.apache.commons.beanutils2.WrapDynaClass;
import org.apache.commons.beanutils2.converters.IntegerConverter;
import org.apache.commons.beanutils2.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils2.locale.LocaleConvertUtils;
import org.apache.commons.beanutils2.locale.LocaleConverter;
import org.apache.commons.beanutils2.locale.converters.IntegerLocaleConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class MemoryLeakTest {
    private static URLClassLoader newClassLoader() throws MalformedURLException {
        String dataFilePath = MemoryLeakTest.class.getResource("pojotests").getFile();
        String location = "file://" + dataFilePath.substring(0, dataFilePath.length() - "org.apache.commons.beanutils2.memoryleaktests.pojotests".length());
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < location.length(); ++i) {
            if (location.charAt(i) == '\\') {
                newString.append("/");
                continue;
            }
            newString.append(location.charAt(i));
        }
        String classLocation = newString.toString();
        URLClassLoader theLoader = URLClassLoader.newInstance(new URL[]{new URL(classLocation)}, null);
        return theLoader;
    }

    private void clearAllBeanUtilsCaches() {
        BeanUtilsBean.getInstance().getPropertyUtils().clearDescriptors();
        LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getPropertyUtils().clearDescriptors();
        MethodUtils.clearCache();
        WrapDynaClass.clear();
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean());
        LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)new LocaleBeanUtilsBean());
    }

    private void forceGarbageCollection() throws Exception {
        SoftReference<Object> ref = new SoftReference<Object>(new Object());
        int count = 0;
        while (ref.get() != null && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (ref.get() != null) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
                System.out.println("Count(1) " + count + " : " + this.getMemoryStats());
            }
            catch (OutOfMemoryError i) {
                // empty catch block
            }
            System.gc();
            list.clear();
            list = null;
            System.gc();
            System.out.println("After GC2: " + this.getMemoryStats() + " Count " + count);
            Thread.sleep(1000L);
        }
        boolean isNotNull = ref.get() != null;
        System.out.println("Count " + count + " " + isNotNull);
        String message = "Your JVM is not releasing SoftReference, try running the test with less memory (-Xmx)";
        Assumptions.assumeFalse((boolean)isNotNull, (String)"Your JVM is not releasing SoftReference, try running the test with less memory (-Xmx)");
    }

    private String getMemoryStats() {
        DecimalFormat fmt = new DecimalFormat("#,##0");
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory() / 1024L;
        long total = runtime.totalMemory() / 1024L;
        long used = total - free;
        return "MEMORY - Total: " + fmt.format(total) + "k Used: " + fmt.format(used) + "k Free: " + fmt.format(free) + "k";
    }

    private void profilerLeakReport(String test, String className) {
    }

    @Test
    public void testConvertUtilsBean_converters_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.CustomInteger";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.CustomInteger");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        ConvertUtils.register((Converter)new IntegerConverter(), beanClass);
        Assertions.assertEquals((Object)"12345", (Object)ConvertUtils.convert(bean, String.class));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("ConvertUtilsBean converters", "org.apache.commons.beanutils2.memoryleaktests.pojotests.CustomInteger");
        }
        Assertions.assertNull(someRef.get(), (String)"ConvertUtilsBean is holding a reference to the classLoader");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testLocaleConvertUtilsBean_converters_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.CustomInteger";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.CustomInteger");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        LocaleConvertUtils.register((LocaleConverter)((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(Locale.US)).setLocalizedPattern(false)).get(), beanClass, (Locale)Locale.US);
        Assertions.assertEquals((Object)new Integer(12345), (Object)LocaleConvertUtils.convert((String)bean.toString(), Integer.class, (Locale)Locale.US, (String)"#,###"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("LocaleConvertUtilsBean converters", "org.apache.commons.beanutils2.memoryleaktests.pojotests.CustomInteger");
        }
        Assertions.assertNull(someRef.get(), (String)"LocaleConvertUtilsBean is holding a reference to the classLoader");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testMappedPropertyDescriptor_MappedMethodReference1() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo");
        Object bean = beanClass.newInstance();
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotNull(bean, (String)"Bean is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        MappedPropertyDescriptor descriptor = new MappedPropertyDescriptor("mappedProperty", beanClass);
        Assertions.assertNotNull((Object)descriptor.getMappedReadMethod(), (String)"1-Read Method null");
        Assertions.assertNotNull((Object)descriptor.getMappedWriteMethod(), (String)"1-Write Method null");
        Assertions.assertEquals((Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName(), (String)"1-Read Method name");
        Assertions.assertEquals((Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName(), (String)"1-Read Write name");
        this.forceGarbageCollection();
        Assertions.assertNotNull((Object)descriptor.getMappedReadMethod(), (String)"1-Read Method null");
        Assertions.assertNotNull((Object)descriptor.getMappedWriteMethod(), (String)"1-Write Method null");
        Assertions.assertEquals((Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName(), (String)"1-Read Method name");
        Assertions.assertEquals((Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName(), (String)"1-Read Write name");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testMappedPropertyDescriptor_MappedMethodReference2() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo");
        Object bean = beanClass.newInstance();
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotNull(bean, (String)"Bean is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        MappedPropertyDescriptor descriptor = new MappedPropertyDescriptor("mappedProperty", beanClass);
        Assertions.assertNotNull((Object)descriptor.getMappedReadMethod(), (String)"1-Read Method null");
        Assertions.assertNotNull((Object)descriptor.getMappedWriteMethod(), (String)"1-Write Method null");
        Assertions.assertEquals((Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName(), (String)"1-Read Method name");
        Assertions.assertEquals((Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName(), (String)"1-Read Write name");
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        Assertions.assertNotNull((Object)descriptor.getMappedReadMethod(), (String)"1-Read Method null");
        Assertions.assertNotNull((Object)descriptor.getMappedWriteMethod(), (String)"1-Write Method null");
        Assertions.assertEquals((Object)"getMappedProperty", (Object)descriptor.getMappedReadMethod().getName(), (String)"1-Read Method name");
        Assertions.assertEquals((Object)"setMappedProperty", (Object)descriptor.getMappedWriteMethod().getName(), (String)"1-Read Write name");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testMethodUtils_cache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        Assertions.assertEquals((Object)"initialValue", (Object)MethodUtils.invokeExactMethod(bean, (String)"getName", (Object[])new Object[0]));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("MethodUtils cache", "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo");
        }
        Assertions.assertNull(someRef.get(), (String)"MethodUtils is holding a reference to the classLoader");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testPropertyUtilsBean_descriptorsCache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        Assertions.assertEquals((Object)"initialValue", (Object)PropertyUtils.getProperty(bean, (String)"name"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("PropertyUtilsBean descriptorsCache", "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo");
        }
        Assertions.assertNull(someRef.get(), (String)"PropertyUtilsBean is holding a reference to the classLoader");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testPropertyUtilsBean_mappedDescriptorsCache_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo");
        Object bean = beanClass.newInstance();
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        Assertions.assertEquals((Object)"Second Value", (Object)PropertyUtils.getProperty(bean, (String)"mappedProperty(Second Key)"));
        PropertyUtils.setProperty(bean, (String)"mappedProperty(Second Key)", (Object)"New Second Value");
        Assertions.assertEquals((Object)"New Second Value", (Object)PropertyUtils.getProperty(bean, (String)"mappedProperty(Second Key)"));
        loader = null;
        beanClass = null;
        bean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("PropertyUtilsBean mappedDescriptorsCache", "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomeMappedPojo");
        }
        Assertions.assertNull(someRef.get(), (String)"PropertyUtilsBean is holding a reference to the classLoader");
        this.clearAllBeanUtilsCaches();
    }

    @Test
    public void testWrapDynaClass_dynaClasses_memoryLeak() throws Exception {
        this.clearAllBeanUtilsCaches();
        String className = "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo";
        URLClassLoader loader = MemoryLeakTest.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo");
        Object bean = beanClass.newInstance();
        WrapDynaBean wrapDynaBean = new WrapDynaBean(bean);
        WeakReference<URLClassLoader> someRef = new WeakReference<URLClassLoader>(loader);
        Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
        Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
        Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
        Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
        Assertions.assertEquals((Object)"initialValue", (Object)wrapDynaBean.get("name"));
        loader = null;
        beanClass = null;
        bean = null;
        wrapDynaBean = null;
        this.forceGarbageCollection();
        if (someRef.get() != null) {
            this.profilerLeakReport("WrapDynaClass dynaClasses", "org.apache.commons.beanutils2.memoryleaktests.pojotests.SomePojo");
        }
        Assertions.assertNull(someRef.get(), (String)"WrapDynaClass is holding a reference to the classLoader");
        this.clearAllBeanUtilsCaches();
    }
}

