/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.pam;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.AbstractAuthenticationStrategy;
import org.apache.shiro.subject.PrincipalCollection;

public class AtLeastOneSuccessfulStrategy
extends AbstractAuthenticationStrategy {
    private static boolean isEmpty(PrincipalCollection pc) {
        return pc == null || pc.isEmpty();
    }

    @Override
    public AuthenticationInfo afterAllAttempts(AuthenticationToken token, AuthenticationInfo aggregate) throws AuthenticationException {
        if (aggregate == null || AtLeastOneSuccessfulStrategy.isEmpty(aggregate.getPrincipals())) {
            throw new AuthenticationException("Authentication token of type [" + String.valueOf(token.getClass()) + "] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.");
        }
        return aggregate;
    }
}

