/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config;

import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.slf4j.Logger;

public class InitializationService {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(InitializationService.class);

    protected InitializationService() {
    }

    public static synchronized void initialize() throws InitializationException {
        LOG.info("Initializing OpenSAML using the Java Services API");
        ServiceLoader<Initializer> serviceLoader = InitializationService.getServiceLoader();
        for (Initializer initializer : serviceLoader) {
            LOG.debug("Initializing module initializer implementation: {}", (Object)initializer.getClass().getName());
            try {
                initializer.init();
            }
            catch (InitializationException e) {
                LOG.error("Error initializing module: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }

    @Nonnull
    private static ServiceLoader<Initializer> getServiceLoader() {
        return ServiceLoader.load(Initializer.class);
    }
}

