/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.system.ReferenceQueueConsumer;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

final class CloseableReference
extends WeakReference<AuthorityCodes>
implements Disposable {
    private final EPSGDataAccess factory;
    private final Statement[] statements;
    boolean published;

    CloseableReference(AuthorityCodes ref, EPSGDataAccess factory, Statement[] statements) {
        super(ref, ReferenceQueueConsumer.QUEUE);
        this.statements = statements;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws SQLException {
        SQLException exception = null;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int i = this.statements.length;
            while (--i >= 0) {
                Statement s = this.statements[i];
                this.statements[i] = null;
                if (s == null) continue;
                try {
                    s.close();
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (SQLException exception) {
            Logging.unexpectedException((Logger)EPSGDataAccess.LOGGER, AuthorityCodes.class, (String)"close", (Throwable)exception);
        }
    }
}

