/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.subscription;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.SubscriptionGroupAttributes;
import org.apache.rocketmq.common.attribute.AttributeUtil;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class SubscriptionGroupManager
extends ConfigManager {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected ConcurrentMap<String, SubscriptionGroupConfig> subscriptionGroupTable = new ConcurrentHashMap<String, SubscriptionGroupConfig>(1024);
    private ConcurrentMap<String, ConcurrentMap<String, Integer>> forbiddenTable = new ConcurrentHashMap<String, ConcurrentMap<String, Integer>>(4);
    protected final DataVersion dataVersion = new DataVersion();
    protected transient BrokerController brokerController;

    public SubscriptionGroupManager() {
        this.init();
    }

    public SubscriptionGroupManager(BrokerController brokerController) {
        this(brokerController, true);
    }

    public SubscriptionGroupManager(BrokerController brokerController, boolean init) {
        this.brokerController = brokerController;
        if (init) {
            this.init();
        }
    }

    protected void init() {
        SubscriptionGroupConfig subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("TOOLS_CONSUMER");
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("FILTERSRV_CONSUMER");
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("SELF_TEST_C_GROUP");
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONS-HTTP-PROXY");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_PULL");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_PERMISSION");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_OWNER");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_RMQ_SYS_TRANS");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.putSubscriptionGroupConfig(subscriptionGroupConfig);
    }

    public SubscriptionGroupConfig putSubscriptionGroupConfig(SubscriptionGroupConfig subscriptionGroupConfig) {
        return this.subscriptionGroupTable.put(subscriptionGroupConfig.getGroupName(), subscriptionGroupConfig);
    }

    protected SubscriptionGroupConfig putSubscriptionGroupConfigIfAbsent(SubscriptionGroupConfig subscriptionGroupConfig) {
        return this.subscriptionGroupTable.putIfAbsent(subscriptionGroupConfig.getGroupName(), subscriptionGroupConfig);
    }

    protected SubscriptionGroupConfig getSubscriptionGroupConfig(String groupName) {
        return (SubscriptionGroupConfig)this.subscriptionGroupTable.get(groupName);
    }

    protected SubscriptionGroupConfig removeSubscriptionGroupConfig(String groupName) {
        return (SubscriptionGroupConfig)this.subscriptionGroupTable.remove(groupName);
    }

    public void updateSubscriptionGroupConfig(SubscriptionGroupConfig config) {
        this.updateSubscriptionGroupConfigWithoutPersist(config);
        this.persist();
    }

    public void updateSubscriptionGroupConfigWithoutPersist(SubscriptionGroupConfig config) {
        Map<String, String> newAttributes = this.request(config);
        Map<String, String> currentAttributes = this.current(config.getGroupName());
        Map finalAttributes = AttributeUtil.alterCurrentAttributes((this.subscriptionGroupTable.get(config.getGroupName()) == null ? 1 : 0) != 0, (Map)SubscriptionGroupAttributes.ALL, (ImmutableMap)ImmutableMap.copyOf(currentAttributes), (ImmutableMap)ImmutableMap.copyOf(newAttributes));
        config.setAttributes(finalAttributes);
        SubscriptionGroupConfig old = this.putSubscriptionGroupConfig(config);
        if (old != null) {
            log.info("update subscription group config, old: {} new: {}", (Object)old, (Object)config);
        } else {
            log.info("create new subscription group, {}", (Object)config);
        }
        this.updateDataVersion();
    }

    public void updateSubscriptionGroupConfigList(List<SubscriptionGroupConfig> configList) {
        if (null == configList || configList.isEmpty()) {
            return;
        }
        configList.forEach(this::updateSubscriptionGroupConfigWithoutPersist);
        this.persist();
    }

    public void updateForbidden(String group, String topic, int forbiddenIndex, boolean setOrClear) {
        if (setOrClear) {
            this.setForbidden(group, topic, forbiddenIndex);
        } else {
            this.clearForbidden(group, topic, forbiddenIndex);
        }
    }

    public void setForbidden(String group, String topic, int forbiddenIndex) {
        int topicForbidden = this.getForbidden(group, topic);
        this.updateForbiddenValue(group, topic, topicForbidden |= 1 << forbiddenIndex);
    }

    public void clearForbidden(String group, String topic, int forbiddenIndex) {
        int topicForbidden = this.getForbidden(group, topic);
        this.updateForbiddenValue(group, topic, topicForbidden &= ~(1 << forbiddenIndex));
    }

    public boolean getForbidden(String group, String topic, int forbiddenIndex) {
        int bitForbidden;
        int topicForbidden = this.getForbidden(group, topic);
        return (topicForbidden & (bitForbidden = 1 << forbiddenIndex)) == bitForbidden;
    }

    public int getForbidden(String group, String topic) {
        ConcurrentMap topicForbiddens = (ConcurrentMap)this.forbiddenTable.get(group);
        if (topicForbiddens == null) {
            return 0;
        }
        Integer topicForbidden = (Integer)topicForbiddens.get(topic);
        if (topicForbidden == null || topicForbidden < 0) {
            topicForbidden = 0;
        }
        return topicForbidden;
    }

    protected void updateForbiddenValue(String group, String topic, Integer forbidden) {
        Integer old;
        if (forbidden == null || forbidden <= 0) {
            this.forbiddenTable.remove(group);
            log.info("clear group forbidden, {}@{} ", (Object)group, (Object)topic);
            return;
        }
        ConcurrentMap topicsPermMap = (ConcurrentMap)this.forbiddenTable.get(group);
        if (topicsPermMap == null) {
            this.forbiddenTable.putIfAbsent(group, new ConcurrentHashMap());
            topicsPermMap = (ConcurrentMap)this.forbiddenTable.get(group);
        }
        if ((old = topicsPermMap.put(topic, forbidden)) != null) {
            log.info("set group forbidden, {}@{} old: {} new: {}", new Object[]{group, topic, old, forbidden});
        } else {
            log.info("set group forbidden, {}@{} old: {} new: {}", new Object[]{group, topic, 0, forbidden});
        }
        this.updateDataVersion();
        this.persist();
    }

    public void disableConsume(String groupName) {
        SubscriptionGroupConfig old = this.getSubscriptionGroupConfig(groupName);
        if (old != null) {
            old.setConsumeEnable(false);
            this.updateDataVersion();
        }
    }

    public SubscriptionGroupConfig findSubscriptionGroupConfig(String group) {
        SubscriptionGroupConfig subscriptionGroupConfig = this.getSubscriptionGroupConfig(group);
        if (null == subscriptionGroupConfig && (this.brokerController.getBrokerConfig().isAutoCreateSubscriptionGroup() || MixAll.isSysConsumerGroupAndEnableCreate((String)group, (boolean)this.brokerController.getBrokerConfig().isEnableCreateSysGroup()))) {
            TopicValidator.ValidateResult result = TopicValidator.validateGroup((String)group);
            if (!result.isValid()) {
                return null;
            }
            subscriptionGroupConfig = new SubscriptionGroupConfig();
            subscriptionGroupConfig.setGroupName(group);
            SubscriptionGroupConfig preConfig = this.putSubscriptionGroupConfigIfAbsent(subscriptionGroupConfig);
            if (null == preConfig) {
                log.info("auto create a subscription group, {}", (Object)subscriptionGroupConfig.toString());
            }
            this.updateDataVersion();
            this.persist();
        }
        return subscriptionGroupConfig;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getSubscriptionGroupPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        SubscriptionGroupManager obj;
        if (jsonString != null && (obj = (SubscriptionGroupManager)((Object)RemotingSerializable.fromJson((String)jsonString, SubscriptionGroupManager.class))) != null) {
            this.subscriptionGroupTable.putAll(obj.subscriptionGroupTable);
            if (obj.forbiddenTable != null) {
                this.forbiddenTable.putAll(obj.forbiddenTable);
            }
            this.dataVersion.assignNewOne(obj.dataVersion);
            this.printLoadDataWhenFirstBoot(obj);
        }
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    private void printLoadDataWhenFirstBoot(SubscriptionGroupManager sgm) {
        for (Map.Entry next : sgm.getSubscriptionGroupTable().entrySet()) {
            log.info("load exist subscription group, {}", (Object)((SubscriptionGroupConfig)next.getValue()).toString());
        }
    }

    public ConcurrentMap<String, SubscriptionGroupConfig> getSubscriptionGroupTable() {
        return this.subscriptionGroupTable;
    }

    public ConcurrentHashMap<String, SubscriptionGroupConfig> subGroupTable(String dataVersion, int groupSeq, int maxGroupNum) {
        int beginIndex = groupSeq;
        if (StringUtils.isBlank((CharSequence)dataVersion) || !Objects.equals(DataVersion.fromJson((String)dataVersion, DataVersion.class), this.dataVersion)) {
            beginIndex = 0;
            log.info("get sub subscription group table from {} due to {}", (Object)beginIndex, (Object)(StringUtils.isBlank((CharSequence)dataVersion) ? "DataVersion Empty" : "DataVersion Changed"));
        }
        ConcurrentHashMap<String, SubscriptionGroupConfig> subGroupTable = new ConcurrentHashMap<String, SubscriptionGroupConfig>();
        if (beginIndex < this.subscriptionGroupTable.size()) {
            int endIndex = Math.min(beginIndex + maxGroupNum, this.subscriptionGroupTable.size());
            ImmutableSortedMap sortedMap = ImmutableSortedMap.copyOf(this.subscriptionGroupTable);
            subGroupTable.putAll((Map<String, SubscriptionGroupConfig>)sortedMap.subMap(sortedMap.keySet().asList().get(beginIndex), true, sortedMap.keySet().asList().get(endIndex - 1), true));
        }
        return subGroupTable;
    }

    public ConcurrentMap<String, ConcurrentMap<String, Integer>> getForbiddenTable() {
        return this.forbiddenTable;
    }

    public ConcurrentMap<String, ConcurrentMap<String, Integer>> subForbiddenTable(Set<String> groupSet) {
        if (MapUtils.isEmpty(this.forbiddenTable) || CollectionUtils.isEmpty(groupSet)) {
            return Maps.newConcurrentMap();
        }
        return this.forbiddenTable.entrySet().stream().filter(e -> groupSet.contains(e.getKey())).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setForbiddenTable(ConcurrentMap<String, ConcurrentMap<String, Integer>> forbiddenTable) {
        this.forbiddenTable = forbiddenTable;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public boolean loadDataVersion() {
        String fileName = null;
        try {
            SubscriptionGroupManager obj;
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String((String)fileName);
            if (jsonString != null && (obj = (SubscriptionGroupManager)((Object)RemotingSerializable.fromJson((String)jsonString, SubscriptionGroupManager.class))) != null) {
                this.dataVersion.assignNewOne(obj.dataVersion);
                this.printLoadDataWhenFirstBoot(obj);
                log.info("load subGroup dataVersion success,{},{}", (Object)fileName, (Object)obj.dataVersion);
            }
            return true;
        }
        catch (Exception e) {
            log.error("load subGroup dataVersion failed" + fileName, (Throwable)e);
            return false;
        }
    }

    public void deleteSubscriptionGroupConfig(String groupName) {
        SubscriptionGroupConfig old = this.removeSubscriptionGroupConfig(groupName);
        this.forbiddenTable.remove(groupName);
        if (old != null) {
            log.info("delete subscription group OK, subscription group:{}", (Object)old);
            this.updateDataVersion();
            this.persist();
        } else {
            log.warn("delete subscription group failed, subscription groupName: {} not exist", (Object)groupName);
        }
    }

    public void setSubscriptionGroupTable(ConcurrentMap<String, SubscriptionGroupConfig> subscriptionGroupTable) {
        this.subscriptionGroupTable = subscriptionGroupTable;
    }

    public boolean containsSubscriptionGroup(String group) {
        if (StringUtils.isBlank((CharSequence)group)) {
            return false;
        }
        return this.subscriptionGroupTable.containsKey(group);
    }

    private Map<String, String> request(SubscriptionGroupConfig subscriptionGroupConfig) {
        return subscriptionGroupConfig.getAttributes() == null ? new HashMap() : subscriptionGroupConfig.getAttributes();
    }

    private Map<String, String> current(String groupName) {
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)this.subscriptionGroupTable.get(groupName);
        if (subscriptionGroupConfig == null) {
            return new HashMap<String, String>();
        }
        Map attributes = subscriptionGroupConfig.getAttributes();
        if (attributes == null) {
            return new HashMap<String, String>();
        }
        return attributes;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion.assignNewOne(dataVersion);
    }

    public void updateDataVersion() {
        long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
        this.dataVersion.nextVersion(stateMachineVersion);
    }
}

