/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceRecordImpl;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;
import org.apache.qpid.server.util.BaseAction;
import org.slf4j.Logger;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

public abstract class AbstractJDBCPreferenceStore
implements PreferenceStore {
    private static final String PREFERENCES_VERSION_TABLE_NAME = "PREFERENCES_VERSION";
    private static final String PREFERENCES_TABLE_NAME = "PREFERENCES";
    private static final String CREATE_PREFERENCES_VERSION_TABLE = "CREATE TABLE %s ( version VARCHAR(20) NOT NULL )";
    private static final String INSERT_INTO_PREFERENCES_VERSION = "INSERT INTO %s ( version ) VALUES ( ? )";
    private static final String SELECT_FROM_PREFERENCES_VERSION = "SELECT version FROM %s";
    private static final String INSERT_INTO_PREFERENCES = "INSERT INTO %s ( id, attributes ) VALUES ( ?, ? )";
    private static final String DELETE_FROM_PREFERENCES = "DELETE FROM %s where id = ?";
    private static final String SELECT_FROM_PREFERENCES = "SELECT id, attributes FROM %s";
    private static final String FIND_PREFERENCE = "SELECT attributes FROM %s WHERE id = ?";
    private static final String UPDATE_PREFERENCES = "UPDATE %s SET attributes = ? WHERE id = ?";
    private final AtomicReference<StoreState> _storeState = new AtomicReference<StoreState>(StoreState.CLOSED);
    private final ReentrantReadWriteLock _useOrCloseRWLock = new ReentrantReadWriteLock(true);
    private String _tableNamePrefix = "";

    protected void setTableNamePrefix(String tableNamePrefix) {
        this._tableNamePrefix = tableNamePrefix == null ? "" : tableNamePrefix;
    }

    public Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
        if (!this._storeState.compareAndSet(StoreState.CLOSED, StoreState.OPENING)) {
            throw new IllegalStateException(String.format("PreferenceStore cannot be opened when in state '%s'", new Object[]{this._storeState.get()}));
        }
        try {
            Collection records;
            this._storeState.set(StoreState.OPENED);
            try (Connection connection = this.getConnection();){
                this.createVersionTable(connection);
                this.createPreferencesTable(connection);
                ModelVersion preferencesVersion = this.getPreferencesVersion(connection);
                ModelVersion brokerModelVersion = ModelVersion.fromString((String)"9.1");
                if (brokerModelVersion.lessThan(preferencesVersion)) {
                    throw new StoreException(String.format("Cannot downgrade preference store from '%s' to '%s'", preferencesVersion, brokerModelVersion));
                }
                records = this.getPreferenceRecords(connection);
                if (preferencesVersion.lessThan(brokerModelVersion)) {
                    HashSet<UUID> ids = new HashSet<UUID>();
                    for (PreferenceRecord record : records) {
                        ids.add(record.getId());
                    }
                    records = updater.updatePreferences(preferencesVersion.toString(), records);
                    this.removeAndAdd(ids, records, (BaseAction<Connection, SQLException>)((BaseAction)transactedConnection -> this.updateVersion((Connection)transactedConnection, brokerModelVersion.toString())));
                }
            }
            return records;
        }
        catch (SQLException e) {
            this._storeState.set(StoreState.ERRORED);
            this.close();
            throw new StoreException((Throwable)e);
        }
    }

    public void updateOrCreate(Collection<PreferenceRecord> preferenceRecords) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            this.performSafeTransaction((BaseAction<Connection, Exception>)((BaseAction)connection -> this.updateOrCreateInternal((Connection)connection, preferenceRecords)));
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    public void replace(Collection<UUID> preferenceRecordsToRemove, Collection<PreferenceRecord> preferenceRecordsToAdd) {
        this.removeAndAdd(preferenceRecordsToRemove, preferenceRecordsToAdd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndAdd(Collection<UUID> preferenceRecordsToRemove, Collection<PreferenceRecord> preferenceRecordsToAdd, BaseAction<Connection, SQLException> preCommitAction) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            this.performSafeTransaction((BaseAction<Connection, Exception>)((BaseAction)connection -> {
                for (UUID id : preferenceRecordsToRemove) {
                    PreparedStatement deleteStatement = connection.prepareStatement(String.format(DELETE_FROM_PREFERENCES, this.getPreferencesTableName()));
                    try {
                        deleteStatement.setString(1, id.toString());
                        int deletedCount = deleteStatement.executeUpdate();
                        if (deletedCount != 1) continue;
                        this.getLogger().debug(String.format("Failed to delete preference with id %s : no such record", id));
                    }
                    finally {
                        if (deleteStatement == null) continue;
                        deleteStatement.close();
                    }
                }
                this.updateOrCreateInternal((Connection)connection, preferenceRecordsToAdd);
                if (preCommitAction != null) {
                    preCommitAction.performAction(connection);
                }
            }));
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    public void onDelete() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            this.close();
            this.doDelete();
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    public void close() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            while (true) {
                StoreState storeState;
                if ((storeState = this.getStoreState()).equals((Object)StoreState.OPENED) || storeState.equals((Object)StoreState.ERRORED)) {
                    if (!this._storeState.compareAndSet(storeState, StoreState.CLOSING)) continue;
                    break;
                }
                if (!storeState.equals((Object)StoreState.CLOSED) && !storeState.equals((Object)StoreState.CLOSING)) continue;
                return;
            }
            this.doClose();
            this._storeState.set(StoreState.CLOSED);
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    protected void dropTables(Connection connection) throws SQLException {
        try (Statement dropTableStatement = connection.createStatement();){
            dropTableStatement.execute(String.format("DROP TABLE %s", this.getPreferencesTableName()));
            dropTableStatement.execute(String.format("DROP TABLE %s", this.getPreferencesVersionTableName()));
        }
        catch (SQLException e) {
            this.getLogger().warn("Failed to drop preferences table", (Throwable)e);
        }
    }

    protected abstract void doDelete();

    protected abstract void doClose();

    protected abstract Logger getLogger();

    protected abstract Connection getConnection() throws SQLException;

    protected abstract String getSqlBlobType();

    protected abstract String getBlobAsString(ResultSet var1, int var2) throws SQLException;

    StoreState getStoreState() {
        return this._storeState.get();
    }

    private void updateOrCreateInternal(Connection conn, Collection<PreferenceRecord> preferenceRecords) throws SQLException, JacksonException {
        for (PreferenceRecord record : preferenceRecords) {
            PreparedStatement stmt = conn.prepareStatement(String.format(FIND_PREFERENCE, this.getPreferencesTableName()));
            try {
                stmt.setString(1, record.getId().toString());
                ResultSet rs = stmt.executeQuery();
                try {
                    if (rs.next()) {
                        PreparedStatement updateStatement = conn.prepareStatement(String.format(UPDATE_PREFERENCES, this.getPreferencesTableName()));
                        try {
                            this.setAttributesAsBlob(updateStatement, 1, record.getAttributes());
                            updateStatement.setString(2, record.getId().toString());
                            updateStatement.execute();
                            continue;
                        }
                        finally {
                            if (updateStatement != null) {
                                updateStatement.close();
                            }
                            continue;
                        }
                    }
                    PreparedStatement insertStatement = conn.prepareStatement(String.format(INSERT_INTO_PREFERENCES, this.getPreferencesTableName()));
                    try {
                        insertStatement.setString(1, record.getId().toString());
                        this.setAttributesAsBlob(insertStatement, 2, record.getAttributes());
                        insertStatement.execute();
                    }
                    finally {
                        if (insertStatement == null) continue;
                        insertStatement.close();
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
    }

    private void performSafeTransaction(BaseAction<Connection, Exception> transactedAction) {
        Connection connection = null;
        try {
            connection = this.getTransactedConnection();
            transactedAction.performAction((Object)connection);
            connection.commit();
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this.getLogger().error("Failed to rollback transaction", (Throwable)e1);
            }
            throw new StoreException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().warn("Failed to close JDBC connection", (Throwable)e);
            }
        }
    }

    private Connection getTransactedConnection() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        return connection;
    }

    private void setAttributesAsBlob(PreparedStatement preparedSqlStatement, int parameterIndex, Map<String, Object> attributes) throws JacksonException, SQLException {
        ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
        if (attributes != null) {
            byte[] attributesAsBytes = objectMapper.writeValueAsBytes(attributes);
            ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
            preparedSqlStatement.setBinaryStream(parameterIndex, (InputStream)bis, attributesAsBytes.length);
        } else {
            preparedSqlStatement.setNull(parameterIndex, 2004);
        }
    }

    private void createVersionTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists(this.getPreferencesVersionTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(String.format(CREATE_PREFERENCES_VERSION_TABLE, this.getPreferencesVersionTableName()));
            }
            this.updateVersion(conn, "9.1");
        }
    }

    private void updateVersion(Connection conn, String currentVersion) throws SQLException {
        try (PreparedStatement pstmt = conn.prepareStatement(String.format(INSERT_INTO_PREFERENCES_VERSION, this.getPreferencesVersionTableName()));){
            pstmt.setString(1, currentVersion);
            pstmt.execute();
        }
    }

    private void createPreferencesTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists(this.getPreferencesTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getPreferencesTableName() + " ( id VARCHAR(36) not null, attributes " + this.getSqlBlobType() + ",  PRIMARY KEY (id))");
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected ModelVersion getPreferencesVersion(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<PreferenceRecord> getPreferenceRecords(Connection connection) throws SQLException {
        LinkedHashSet<PreferenceRecord> records = new LinkedHashSet<PreferenceRecord>();
        ObjectMapper objectMapper = new ObjectMapper();
        try (PreparedStatement stmt = connection.prepareStatement(String.format(SELECT_FROM_PREFERENCES, this.getPreferencesTableName()));){
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String id = rs.getString(1);
                    String attributes = this.getBlobAsString(rs, 2);
                    PreferenceRecordImpl preferenceRecord = new PreferenceRecordImpl(UUID.fromString(id), (Map)objectMapper.readValue(attributes, Map.class));
                    records.add((PreferenceRecord)preferenceRecord);
                }
            }
            catch (JacksonException e) {
                throw new StoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
            }
        }
        return records;
    }

    private String getPreferencesTableName() {
        return this._tableNamePrefix + PREFERENCES_TABLE_NAME;
    }

    private String getPreferencesVersionTableName() {
        return this._tableNamePrefix + PREFERENCES_VERSION_TABLE_NAME;
    }

    static enum StoreState {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING,
        ERRORED;

    }
}

